/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapred.WordCount;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class TestCustomOutputCommitter
extends TestCase {
    static final Path input = new Path("/test/input/");
    static final Path output = new Path("/test/output");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCommitter() throws Exception {
        MiniDFSCluster dfs = null;
        MiniMRCluster mr = null;
        FileSystem fs = null;
        Path testFile = new Path(input, "testfile");
        try {
            Configuration conf = new Configuration();
            dfs = new MiniDFSCluster(conf, 2, true, null);
            fs = dfs.getFileSystem();
            FSDataOutputStream stream = fs.create(testFile);
            stream.write("teststring".getBytes());
            stream.close();
            mr = new MiniMRCluster(2, fs.getUri().toString(), 1);
            String[] args = new String[]{"-libjars", "build/test/testjar/testjob.jar", "-D", "mapred.output.committer.class=testjar.CustomOutputCommitter", input.toString(), output.toString()};
            JobConf jobConf = mr.createJobConf();
            int ret = ToolRunner.run((Configuration)jobConf, (Tool)new WordCount(), (String[])args);
            TestCustomOutputCommitter.assertTrue((String)"not failed ", (ret == 0 ? 1 : 0) != 0);
        }
        finally {
            if (dfs != null) {
                dfs.shutdown();
            }
            if (mr != null) {
                mr.shutdown();
            }
        }
    }
}

