/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.metrics;

import java.io.IOException;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.metrics.NameNodeInstrumentation;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.test.MetricsAsserts;

public class TestNameNodeMetrics
extends TestCase {
    private static final Configuration CONF = new Configuration();
    private static final int DFS_REPLICATION_INTERVAL = 1;
    private static final Path TEST_ROOT_DIR_PATH = new Path(System.getProperty("test.build.data", "build/test/data"));
    private static final int DATANODE_COUNT = 3;
    private MiniDFSCluster cluster;
    private MetricsSource fsnMetrics;
    private DistributedFileSystem fs;
    private Random rand = new Random();
    private FSNamesystem namesystem;
    private NameNodeInstrumentation nnMetrics;

    private static Path getTestPath(String fileName) {
        return new Path(TEST_ROOT_DIR_PATH, fileName);
    }

    protected void setUp() throws Exception {
        this.cluster = new MiniDFSCluster(CONF, 3, true, null);
        this.cluster.waitActive();
        this.namesystem = this.cluster.getNameNode().getNamesystem();
        this.fs = (DistributedFileSystem)this.cluster.getFileSystem();
        this.nnMetrics = NameNode.getNameNodeMetrics();
        this.fsnMetrics = this.namesystem;
    }

    protected void tearDown() throws Exception {
        this.cluster.shutdown();
    }

    private void createFile(Path file, long fileLen, short replicas) throws IOException {
        DFSTestUtil.createFile((FileSystem)this.fs, file, fileLen, replicas, this.rand.nextLong());
    }

    private void updateMetrics() throws Exception {
        Thread.sleep(1000L);
    }

    private void readFile(FileSystem fileSys, Path name) throws IOException {
        FSDataInputStream stm = fileSys.open(name);
        byte[] buffer = new byte[4];
        stm.read(buffer, 0, 4);
        stm.close();
    }

    public void testCapacityMetrics() throws Exception {
        MetricsRecordBuilder rb = MetricsAsserts.getMetrics(this.fsnMetrics);
        long capacityTotal = MetricsAsserts.getLongGauge("CapacityTotal", rb);
        assert (capacityTotal != 0L);
        long capacityUsed = MetricsAsserts.getLongGauge("CapacityUsed", rb);
        long capacityRemaining = MetricsAsserts.getLongGauge("CapacityRemaining", rb);
        long capacityUsedNonDFS = MetricsAsserts.getLongGauge("CapacityUsedNonDFS", rb);
        assert (capacityUsed + capacityRemaining + capacityUsedNonDFS == capacityTotal);
    }

    public void testFileAdd() throws Exception {
        Path file = TestNameNodeMetrics.getTestPath("testFileAdd");
        this.createFile(file, 3200L, (short)3);
        long blockCount = 32L;
        int blockCapacity = this.namesystem.getBlockCapacity();
        this.updateMetrics();
        MetricsAsserts.assertGauge("BlockCapacity", blockCapacity, this.fsnMetrics);
        MetricsRecordBuilder rb = MetricsAsserts.getMetrics((MetricsSource)this.nnMetrics);
        MetricsAsserts.assertCounter("CreateFileOps", 1, rb);
        MetricsAsserts.assertCounter("FilesCreated", file.depth(), rb);
        int threshold = (int)((float)blockCapacity * 0.75f);
        while ((long)threshold < 32L) {
            blockCapacity <<= 1;
        }
        this.updateMetrics();
        long filesTotal = file.depth() + 1;
        rb = MetricsAsserts.getMetrics(this.fsnMetrics);
        MetricsAsserts.assertGauge("FilesTotal", filesTotal, rb);
        MetricsAsserts.assertGauge("BlocksTotal", 32L, rb);
        MetricsAsserts.assertGauge("BlockCapacity", blockCapacity, rb);
        this.fs.delete(file, true);
        Thread.sleep(4000L);
        this.updateMetrics();
        rb = MetricsAsserts.getMetrics(this.fsnMetrics);
        MetricsAsserts.assertGauge("FilesTotal", --filesTotal, rb);
        MetricsAsserts.assertGauge("PendingDeletionBlocks", 0L, rb);
        rb = MetricsAsserts.getMetrics((MetricsSource)this.nnMetrics);
        MetricsAsserts.assertCounter("DeleteFileOps", 1, rb);
        MetricsAsserts.assertCounter("FilesDeleted", 1, rb);
    }

    public void testCorruptBlock() throws Exception {
        this.fs.delete(new Path("/"), true);
        Path file = TestNameNodeMetrics.getTestPath("testCorruptBlock");
        this.createFile(file, 100L, (short)2);
        LocatedBlock block = this.namesystem.getBlockLocations(file.toString(), 0L, 1L).get(0);
        this.namesystem.markBlockAsCorrupt(block.getBlock(), block.getLocations()[0]);
        this.updateMetrics();
        MetricsRecordBuilder rb = MetricsAsserts.getMetrics(this.fsnMetrics);
        MetricsAsserts.assertGauge("CorruptBlocks", 1L, rb);
        MetricsAsserts.assertGauge("PendingReplicationBlocks", 1L, rb);
        MetricsAsserts.assertGauge("ScheduledReplicationBlocks", 1L, rb);
        this.fs.delete(file, true);
        this.updateMetrics();
        rb = MetricsAsserts.getMetrics(this.fsnMetrics);
        MetricsAsserts.assertGauge("CorruptBlocks", 0L, rb);
        MetricsAsserts.assertGauge("PendingReplicationBlocks", 0L, rb);
        MetricsAsserts.assertGauge("ScheduledReplicationBlocks", 0L, rb);
    }

    public void testExcessBlocks() throws Exception {
        Path file = TestNameNodeMetrics.getTestPath("testExcessBlocks");
        this.createFile(file, 100L, (short)2);
        long totalBlocks = 1L;
        this.namesystem.setReplication(file.toString(), (short)1);
        this.updateMetrics();
        MetricsAsserts.assertGauge("ExcessBlocks", totalBlocks, this.fsnMetrics);
        this.fs.delete(file, true);
    }

    public void testMissingBlock() throws Exception {
        Path file = TestNameNodeMetrics.getTestPath("testMissingBlocks");
        this.createFile(file, 100L, (short)1);
        LocatedBlock block = this.namesystem.getBlockLocations(file.toString(), 0L, 1L).get(0);
        this.namesystem.markBlockAsCorrupt(block.getBlock(), block.getLocations()[0]);
        this.updateMetrics();
        MetricsRecordBuilder rb = MetricsAsserts.getMetrics(this.fsnMetrics);
        MetricsAsserts.assertGauge("UnderReplicatedBlocks", 1L, rb);
        MetricsAsserts.assertGauge("MissingBlocks", 1L, rb);
        this.fs.delete(file, true);
        this.updateMetrics();
        MetricsAsserts.assertGauge("UnderReplicatedBlocks", 0L, this.fsnMetrics);
    }

    public void testGetBlockLocationMetric() throws Exception {
        Path file1_Path = new Path(TEST_ROOT_DIR_PATH, "file1.dat");
        MetricsAsserts.assertCounter("GetBlockLocations", 0, (MetricsSource)this.nnMetrics);
        this.createFile(file1_Path, 100L, (short)2);
        this.updateMetrics();
        MetricsAsserts.assertCounter("GetBlockLocations", 0, (MetricsSource)this.nnMetrics);
        this.readFile((FileSystem)this.fs, file1_Path);
        this.updateMetrics();
        MetricsAsserts.assertCounter("GetBlockLocations", 1, (MetricsSource)this.nnMetrics);
        this.readFile((FileSystem)this.fs, file1_Path);
        this.readFile((FileSystem)this.fs, file1_Path);
        this.updateMetrics();
        MetricsAsserts.assertCounter("GetBlockLocations", 3, (MetricsSource)this.nnMetrics);
        this.updateMetrics();
        MetricsAsserts.assertGauge("TotalLoad", 3, this.fsnMetrics);
    }

    static {
        CONF.setLong("dfs.block.size", 100L);
        CONF.setInt("io.bytes.per.checksum", 1);
        CONF.setLong("dfs.heartbeat.interval", 1L);
        CONF.setInt("dfs.replication.interval", 1);
    }
}

