/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.Permission;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hdfs.server.common.HdfsConstants;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestNameNodeFormat
extends TestCase {
    private static final Log LOG = LogFactory.getLog(TestNameNodeFormat.class);
    File hdfsDir;
    String baseDir;
    Configuration config;

    @Before
    public void setUp() throws IOException {
        System.setSecurityManager(new NoExitSecurityManager());
        this.baseDir = System.getProperty("test.build.data", "build/test/data");
        this.hdfsDir = new File(this.baseDir, "dfs/name");
        if (this.hdfsDir.exists() && !FileUtil.fullyDelete((File)this.hdfsDir)) {
            throw new IOException("Could not delete test directory '" + this.hdfsDir + "'");
        }
        LOG.info((Object)("hdfsdir is " + this.hdfsDir.getAbsolutePath()));
        HdfsConstants.StartupOption.FORMAT.setConfirmationNeeded(true);
        HdfsConstants.StartupOption.FORMAT.setInteractive(true);
        this.config = new Configuration();
        this.config.set("dfs.name.dir", this.hdfsDir.getPath());
    }

    @After
    public void tearDown() throws IOException {
        System.setSecurityManager(null);
        if (this.hdfsDir.exists() && !FileUtil.fullyDelete((File)this.hdfsDir)) {
            throw new IOException("Could not tearDown test directory '" + this.hdfsDir + "'");
        }
    }

    @Test
    public void testFormat() throws IOException {
        String[] argv = new String[]{"-format"};
        try {
            NameNode.createNameNode((String[])argv, (Configuration)this.config);
            TestNameNodeFormat.fail((String)"createNameNode() did not call System.exit()");
        }
        catch (ExitException e) {
            TestNameNodeFormat.assertEquals((String)"Format should have succeeded", (int)0, (int)e.status);
        }
        File version = new File(this.hdfsDir, "current/VERSION");
        TestNameNodeFormat.assertTrue((String)"Check version file exists", (boolean)version.exists());
    }

    @Test
    public void testFormatWithForce() throws IOException {
        if (!this.hdfsDir.mkdirs()) {
            TestNameNodeFormat.fail((String)("Failed to create dir " + this.hdfsDir.getPath()));
        }
        String[] argv = new String[]{"-format", "-force"};
        try {
            NameNode.createNameNode((String[])argv, (Configuration)this.config);
            TestNameNodeFormat.fail((String)"createNameNode() did not call System.exit()");
        }
        catch (ExitException e) {
            TestNameNodeFormat.assertEquals((String)"Format should have succeeded", (int)0, (int)e.status);
        }
        File version = new File(this.hdfsDir, "current/VERSION");
        TestNameNodeFormat.assertTrue((String)"Check version file exists", (boolean)version.exists());
    }

    @Test
    public void testFormatWithNonInteractive() throws IOException {
        if (!this.hdfsDir.mkdirs()) {
            TestNameNodeFormat.fail((String)("Failed to create dir " + this.hdfsDir.getPath()));
        }
        String[] argv = new String[]{"-format", "-nonInteractive"};
        try {
            NameNode.createNameNode((String[])argv, (Configuration)this.config);
            TestNameNodeFormat.fail((String)"createNameNode() did not call System.exit()");
        }
        catch (ExitException e) {
            TestNameNodeFormat.assertEquals((String)"Format should have been aborted with exit code 1", (int)1, (int)e.status);
        }
        File version = new File(this.hdfsDir, "current/VERSION");
        TestNameNodeFormat.assertFalse((String)"Check version should not exist", (boolean)version.exists());
    }

    @Test
    public void testFormatWithNonInteractiveNameDirDoesNotExit() throws IOException {
        String[] argv = new String[]{"-format", "-nonInteractive"};
        try {
            NameNode.createNameNode((String[])argv, (Configuration)this.config);
            TestNameNodeFormat.fail((String)"createNameNode() did not call System.exit()");
        }
        catch (ExitException e) {
            TestNameNodeFormat.assertEquals((String)"Format should have succeeded", (int)0, (int)e.status);
        }
        File version = new File(this.hdfsDir, "current/VERSION");
        TestNameNodeFormat.assertTrue((String)"Check version file exists", (boolean)version.exists());
    }

    @Test
    public void testFormatWithNonInteractiveAndForce() throws IOException {
        if (!this.hdfsDir.mkdirs()) {
            TestNameNodeFormat.fail((String)("Failed to create dir " + this.hdfsDir.getPath()));
        }
        String[] argv = new String[]{"-format", "-nonInteractive", "-force"};
        try {
            NameNode.createNameNode((String[])argv, (Configuration)this.config);
            TestNameNodeFormat.fail((String)"createNameNode() did not call System.exit()");
        }
        catch (ExitException e) {
            TestNameNodeFormat.assertEquals((String)"Format should have succeeded", (int)0, (int)e.status);
        }
        File version = new File(this.hdfsDir, "current/VERSION");
        TestNameNodeFormat.assertTrue((String)"Check version file exists", (boolean)version.exists());
    }

    @Test
    public void testFormatWithoutForceEnterN() throws IOException, InterruptedException {
        if (!this.hdfsDir.mkdirs()) {
            TestNameNodeFormat.fail((String)("Failed to create dir " + this.hdfsDir.getPath()));
        }
        InputStream origIn = System.in;
        ByteArrayInputStream bins = new ByteArrayInputStream("N\n".getBytes());
        System.setIn(bins);
        String[] argv = new String[]{"-format"};
        try {
            NameNode.createNameNode((String[])argv, (Configuration)this.config);
            TestNameNodeFormat.fail((String)"createNameNode() did not call System.exit()");
        }
        catch (ExitException e) {
            TestNameNodeFormat.assertEquals((String)"Format should not have succeeded", (int)1, (int)e.status);
        }
        System.setIn(origIn);
        File version = new File(this.hdfsDir, "current/VERSION");
        TestNameNodeFormat.assertFalse((String)"Check version should not exist", (boolean)version.exists());
    }

    @Test
    public void testFormatWithoutForceEnterY() throws IOException, InterruptedException {
        if (!this.hdfsDir.mkdirs()) {
            TestNameNodeFormat.fail((String)("Failed to create dir " + this.hdfsDir.getPath()));
        }
        InputStream origIn = System.in;
        ByteArrayInputStream bins = new ByteArrayInputStream("Y\n".getBytes());
        System.setIn(bins);
        String[] argv = new String[]{"-format"};
        try {
            NameNode.createNameNode((String[])argv, (Configuration)this.config);
            TestNameNodeFormat.fail((String)"createNameNode() did not call System.exit()");
        }
        catch (ExitException e) {
            TestNameNodeFormat.assertEquals((String)"Format should have succeeded", (int)0, (int)e.status);
        }
        System.setIn(origIn);
        File version = new File(this.hdfsDir, "current/VERSION");
        TestNameNodeFormat.assertTrue((String)"Check version file should exist", (boolean)version.exists());
    }

    private static class NoExitSecurityManager
    extends SecurityManager {
        private NoExitSecurityManager() {
        }

        @Override
        public void checkPermission(Permission perm) {
        }

        @Override
        public void checkPermission(Permission perm, Object context) {
        }

        @Override
        public void checkExit(int status) {
            super.checkExit(status);
            throw new ExitException(status);
        }
    }

    private static class ExitException
    extends SecurityException {
        private static final long serialVersionUID = 1L;
        public final int status;

        public ExitException(int status) {
            super("There is no escape!");
            this.status = status;
        }
    }
}

