/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.io.IOUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestBBWBlockReport {
    private final Path src = new Path(System.getProperty("test.build.data", "/tmp"), "testfile");
    private Configuration conf = null;
    private final String fileContent = "PartialBlockReadTest";

    @Before
    public void setUp() {
        this.conf = new Configuration();
        this.conf.setInt("ipc.client.connection.maxidletime", 1000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testDNShouldSendBBWReport() throws Exception {
        FileSystem fileSystem = null;
        FSDataOutputStream outStream = null;
        MiniDFSCluster cluster = new MiniDFSCluster(this.conf, 1, true, null);
        cluster.waitActive();
        try {
            fileSystem = cluster.getFileSystem();
            outStream = this.writeFileAndSync(fileSystem, this.src, "PartialBlockReadTest");
            cluster.restartNameNode();
            Assert.assertEquals((String)"Not able to read the synced block content after NameNode restart (with append support)", (Object)"PartialBlockReadTest", (Object)this.getFileContentFromDFS(fileSystem));
        }
        finally {
            if (null != fileSystem) {
                fileSystem.close();
            }
            if (null != outStream) {
                outStream.close();
            }
            cluster.shutdown();
        }
    }

    private String getFileContentFromDFS(FileSystem fs) throws IOException {
        ByteArrayOutputStream bio = new ByteArrayOutputStream();
        IOUtils.copyBytes((InputStream)fs.open(this.src), (OutputStream)bio, (Configuration)this.conf, (boolean)true);
        return new String(bio.toByteArray());
    }

    private FSDataOutputStream writeFileAndSync(FileSystem fs, Path src, String fileContent) throws IOException {
        FSDataOutputStream fo = fs.create(src);
        fo.writeBytes(fileContent);
        fo.sync();
        return fo;
    }
}

