/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.net.InetSocketAddress;
import java.net.Socket;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenSecretManager;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.io.Text;

public class TestDiskError
extends TestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testShutdown() throws Exception {
        if (System.getProperty("os.name").startsWith("Windows")) {
            return;
        }
        Configuration conf = new Configuration();
        conf.setLong("dfs.block.size", 512L);
        MiniDFSCluster cluster = new MiniDFSCluster(conf, 3, true, null);
        cluster.waitActive();
        FileSystem fs = cluster.getFileSystem();
        boolean dnIndex = false;
        String dataDir = cluster.getDataDirectory();
        File dir1 = new File(new File(dataDir, "data1"), "blocksBeingWritten");
        File dir2 = new File(new File(dataDir, "data2"), "blocksBeingWritten");
        try {
            TestDiskError.assertTrue((boolean)dir1.setReadOnly());
            TestDiskError.assertTrue((boolean)dir2.setReadOnly());
            DataNode dn = cluster.getDataNodes().get(0);
            int i = 0;
            while (DataNode.isDatanodeUp((DataNode)dn)) {
                Path fileName = new Path("/test.txt" + i);
                DFSTestUtil.createFile(fs, fileName, 1024L, (short)2, 1L);
                DFSTestUtil.waitReplication(fs, fileName, (short)2);
                fs.delete(fileName, true);
                ++i;
            }
        }
        finally {
            dir1.setWritable(true);
            dir2.setWritable(true);
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReplicationError() throws Exception {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = new MiniDFSCluster(conf, 1, true, null);
        cluster.waitActive();
        FileSystem fs = cluster.getFileSystem();
        try {
            Path fileName = new Path("/test.txt");
            boolean fileLen = true;
            DFSTestUtil.createFile(fs, fileName, 1L, (short)1, 1L);
            DFSTestUtil.waitReplication(fs, fileName, (short)1);
            LocatedBlocks blocks = cluster.getNameNode().getNamesystem().getBlockLocations(fileName.toString(), 0L, 1L);
            TestDiskError.assertEquals((int)blocks.locatedBlockCount(), (int)1);
            LocatedBlock block = blocks.get(0);
            cluster.startDataNodes(conf, 1, true, null, null);
            cluster.waitActive();
            boolean sndNode = true;
            DataNode datanode = cluster.getDataNodes().get(1);
            InetSocketAddress target = datanode.getSelfAddr();
            Socket s = new Socket(target.getAddress(), target.getPort());
            DataOutputStream out = new DataOutputStream(s.getOutputStream());
            out.writeShort(17);
            out.write(80);
            out.writeLong(block.getBlock().getBlockId());
            out.writeLong(block.getBlock().getGenerationStamp());
            out.writeInt(1);
            out.writeBoolean(false);
            Text.writeString((DataOutput)out, (String)"");
            out.writeBoolean(false);
            out.writeInt(0);
            BlockTokenSecretManager.DUMMY_TOKEN.write((DataOutput)out);
            out.writeByte(1);
            out.writeInt(512);
            out.flush();
            out.close();
            String dataDir = cluster.getDataDirectory();
            File dir1 = new File(new File(dataDir, "data3"), "tmp");
            File dir2 = new File(new File(dataDir, "data4"), "tmp");
            while (dir1.listFiles().length != 0 || dir2.listFiles().length != 0) {
                Thread.sleep(100L);
            }
            fs.setReplication(fileName, (short)2);
            DFSTestUtil.waitReplication(fs, fileName, (short)1);
            fs.delete(fileName, false);
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLocalDirs() throws Exception {
        Configuration conf = new Configuration();
        String permStr = "755";
        FsPermission expected = new FsPermission("755");
        conf.set("dfs.datanode.data.dir.perm", "755");
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster(conf, 1, true, null);
            cluster.waitActive();
            LocalFileSystem localFS = FileSystem.getLocal((Configuration)conf);
            for (DataNode dn : cluster.getDataNodes()) {
                String[] dataDirs;
                for (String dir : dataDirs = dn.getConf().getStrings("dfs.data.dir")) {
                    Path dataDir = new Path(dir);
                    FsPermission actual = localFS.getFileStatus(dataDir).getPermission();
                    TestDiskError.assertEquals((String)("Permission for dir: " + dataDir), (Object)expected, (Object)actual);
                }
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }
}

