/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Random;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.common.HdfsConstants;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.io.IOUtils;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.Test;

public class TestPersistBlocks {
    private static final String HADOOP_1_0_MULTIBLOCK_TGZ = "hadoop-1.0-multiblock-file.tgz";
    private static final int BLOCK_SIZE = 4096;
    private static final int NUM_BLOCKS = 5;
    private static final String FILE_NAME = "/data";
    private static final Path FILE_PATH;
    static final byte[] DATA_BEFORE_RESTART;
    static final byte[] DATA_AFTER_RESTART;

    @Test
    public void TestRestartDfsWithFlush() throws Exception {
        this.testRestartDfs(true);
    }

    @Test
    public void TestRestartDfsWithSync() throws Exception {
        this.testRestartDfs(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void testRestartDfs(boolean useFlush) throws Exception {
        Configuration conf = new Configuration();
        conf.setInt("ipc.client.connection.maxidletime", 0);
        conf.setBoolean("dfs.persist.blocks", true);
        MiniDFSCluster cluster = null;
        long len = 0L;
        try {
            FileStatus status;
            conf.set("dfs.safemode.extension", "1");
            cluster = new MiniDFSCluster(conf, 4, true, null);
            cluster.waitActive();
            FileSystem fs = cluster.getFileSystem();
            FSDataOutputStream stream = fs.create(FILE_PATH, true, 4096, (short)1, 4096L);
            stream.write(DATA_BEFORE_RESTART);
            if (useFlush) {
                stream.flush();
            } else {
                stream.sync();
            }
            while (len <= 4096L) {
                status = fs.getFileStatus(FILE_PATH);
                len = status.getLen();
                Thread.sleep(100L);
            }
            cluster.restartNameNode();
            status = fs.getFileStatus(FILE_PATH);
            Assert.assertTrue((String)("Length too short: " + status.getLen()), (status.getLen() >= len ? 1 : 0) != 0);
            stream.write(DATA_AFTER_RESTART);
            stream.close();
            FSDataInputStream readStream = fs.open(FILE_PATH);
            try {
                byte[] verifyBuf = new byte[DATA_BEFORE_RESTART.length];
                IOUtils.readFully((InputStream)readStream, (byte[])verifyBuf, (int)0, (int)verifyBuf.length);
                Assert.assertArrayEquals((byte[])DATA_BEFORE_RESTART, (byte[])verifyBuf);
                IOUtils.readFully((InputStream)readStream, (byte[])verifyBuf, (int)0, (int)verifyBuf.length);
                Assert.assertArrayEquals((byte[])DATA_AFTER_RESTART, (byte[])verifyBuf);
            }
            finally {
                IOUtils.closeStream((Closeable)readStream);
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRestartWithPartialBlockHflushed() throws IOException {
        Configuration conf = new Configuration();
        conf.setInt("ipc.client.connection.maxidletime", 0);
        conf.setBoolean("dfs.persist.blocks", true);
        MiniDFSCluster cluster = null;
        try {
            conf.set("dfs.safemode.extension", "1");
            cluster = new MiniDFSCluster(conf, 4, true, null);
            cluster.waitActive();
            FileSystem fs = cluster.getFileSystem();
            NameNode.getAddress((Configuration)conf).getPort();
            FSDataOutputStream stream = fs.create(FILE_PATH, true, 4096, (short)1, 4096L);
            stream.write(DATA_BEFORE_RESTART);
            stream.write(1);
            stream.sync();
            cluster.restartNameNode();
            stream.write(2);
            stream.sync();
            stream.close();
            Assert.assertEquals((long)(DATA_BEFORE_RESTART.length + 2), (long)fs.getFileStatus(FILE_PATH).getLen());
            FSDataInputStream readStream = fs.open(FILE_PATH);
            try {
                byte[] verifyBuf = new byte[DATA_BEFORE_RESTART.length + 2];
                IOUtils.readFully((InputStream)readStream, (byte[])verifyBuf, (int)0, (int)verifyBuf.length);
                byte[] expectedBuf = new byte[DATA_BEFORE_RESTART.length + 2];
                System.arraycopy(DATA_BEFORE_RESTART, 0, expectedBuf, 0, DATA_BEFORE_RESTART.length);
                System.arraycopy(new byte[]{1, 2}, 0, expectedBuf, DATA_BEFORE_RESTART.length, 2);
                Assert.assertArrayEquals((byte[])expectedBuf, (byte[])verifyBuf);
            }
            finally {
                IOUtils.closeStream((Closeable)readStream);
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRestartWithAppend() throws IOException {
        Configuration conf = new Configuration();
        conf.set("dfs.safemode.extension", "1");
        conf.setBoolean("dfs.support.broken.append", true);
        conf.setBoolean("dfs.persist.blocks", true);
        MiniDFSCluster cluster = null;
        try {
            conf.set("dfs.safemode.extension", "1");
            cluster = new MiniDFSCluster(conf, 4, true, null);
            cluster.waitActive();
            FileSystem fs = cluster.getFileSystem();
            NameNode.getAddress((Configuration)conf).getPort();
            FSDataOutputStream stream = fs.create(FILE_PATH, true, 4096, (short)1, 4096L);
            stream.write(DATA_BEFORE_RESTART, 0, DATA_BEFORE_RESTART.length / 2);
            stream.close();
            stream = fs.append(FILE_PATH, 4096);
            stream.write(DATA_BEFORE_RESTART, DATA_BEFORE_RESTART.length / 2, DATA_BEFORE_RESTART.length / 2);
            stream.close();
            Assert.assertEquals((long)DATA_BEFORE_RESTART.length, (long)fs.getFileStatus(FILE_PATH).getLen());
            cluster.restartNameNode();
            Assert.assertEquals((long)DATA_BEFORE_RESTART.length, (long)fs.getFileStatus(FILE_PATH).getLen());
            FSDataInputStream readStream = fs.open(FILE_PATH);
            try {
                byte[] verifyBuf = new byte[DATA_BEFORE_RESTART.length];
                IOUtils.readFully((InputStream)readStream, (byte[])verifyBuf, (int)0, (int)verifyBuf.length);
                Assert.assertArrayEquals((byte[])DATA_BEFORE_RESTART, (byte[])verifyBuf);
            }
            finally {
                IOUtils.closeStream((Closeable)readStream);
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    static void assertFileExists(File f) {
        Assert.assertTrue((String)("File " + f + " should exist"), (boolean)f.exists());
    }

    static String readFile(FileSystem fs, Path fileName) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        IOUtils.copyBytes((InputStream)fs.open(fileName), (OutputStream)os, (int)1024, (boolean)true);
        return os.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEarlierVersionEditLog() throws Exception {
        Configuration conf = new Configuration();
        String tarFile = System.getProperty("test.cache.data", "build/test/cache") + "/" + HADOOP_1_0_MULTIBLOCK_TGZ;
        String testDir = System.getProperty("test.build.data", "build/test/data");
        File dfsDir = new File(testDir, "image-1.0");
        if (dfsDir.exists() && !FileUtil.fullyDelete((File)dfsDir)) {
            throw new IOException("Could not delete dfs directory '" + dfsDir + "'");
        }
        FileUtil.unTar((File)new File(tarFile), (File)new File(testDir));
        File nameDir = new File(dfsDir, "name");
        TestPersistBlocks.assertFileExists(nameDir);
        File dataDir = new File(dfsDir, "data");
        TestPersistBlocks.assertFileExists(dataDir);
        conf.set("dfs.name.dir", nameDir.getAbsolutePath());
        conf.set("dfs.data.dir", dataDir.getAbsolutePath());
        conf.setBoolean("dfs.support.broken.append", true);
        conf.set("dfs.safemode.extension", "1");
        MiniDFSCluster cluster = new MiniDFSCluster(0, conf, 1, false, false, HdfsConstants.StartupOption.UPGRADE, null);
        cluster.waitActive();
        try {
            FileSystem fs = cluster.getFileSystem();
            Path testPath = new Path("/user/todd/4blocks");
            TestPersistBlocks.readFile(fs, testPath);
            FSDataOutputStream stm = fs.append(testPath);
            try {
                stm.write(1);
            }
            finally {
                IOUtils.closeStream((Closeable)stm);
            }
        }
        finally {
            cluster.shutdown();
        }
    }

    static {
        ((Log4JLogger)FSImage.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)FSNamesystem.LOG).getLogger().setLevel(Level.ALL);
        FILE_PATH = new Path(FILE_NAME);
        DATA_BEFORE_RESTART = new byte[20480];
        DATA_AFTER_RESTART = new byte[20480];
        Random rand = new Random();
        rand.nextBytes(DATA_BEFORE_RESTART);
        rand.nextBytes(DATA_AFTER_RESTART);
    }
}

