/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.security.PrivilegedExceptionAction;
import java.util.Random;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HftpFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.Test;

public class TestDistributedFileSystem {
    private static final Random RAN = new Random();
    private boolean dualPortTesting;

    public TestDistributedFileSystem() {
        ((Log4JLogger)DFSClient.LOG).getLogger().setLevel(Level.ALL);
        this.dualPortTesting = false;
    }

    private Configuration getTestConfiguration() {
        Configuration conf = new Configuration();
        if (this.dualPortTesting) {
            conf.set("dfs.namenode.servicerpc-address", "localhost:0");
        }
        return conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileSystemCloseAll() throws Exception {
        Configuration conf = this.getTestConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster(conf, 0, true, null);
        URI address = FileSystem.getDefaultUri((Configuration)conf);
        try {
            FileSystem.closeAll();
            conf = this.getTestConfiguration();
            FileSystem.setDefaultUri((Configuration)conf, (URI)address);
            FileSystem.get((Configuration)conf);
            FileSystem.get((Configuration)conf);
            FileSystem.closeAll();
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDFSClose() throws Exception {
        Configuration conf = this.getTestConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster(conf, 2, true, null);
        FileSystem fileSys = cluster.getFileSystem();
        try {
            fileSys.create(new Path("/test/dfsclose/file-0"));
            fileSys.create(new Path("/test/dfsclose/file-1"));
            fileSys.close();
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDFSClient() throws Exception {
        Configuration conf = this.getTestConfiguration();
        long grace = 1000L;
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster(conf, 2, true, null);
            String filepathstring = "/test/LeaseChecker/foo";
            Path[] filepaths = new Path[4];
            for (int i = 0; i < filepaths.length; ++i) {
                filepaths[i] = new Path("/test/LeaseChecker/foo" + i);
            }
            long millis = System.currentTimeMillis();
            DistributedFileSystem dfs = (DistributedFileSystem)cluster.getFileSystem();
            dfs.dfs.getLeaseRenewer().setGraceSleepPeriod(1000L);
            Assert.assertFalse((boolean)dfs.dfs.getLeaseRenewer().isRunning());
            FSDataOutputStream out = dfs.create(filepaths[0]);
            Assert.assertTrue((boolean)dfs.dfs.getLeaseRenewer().isRunning());
            out.writeLong(millis);
            Assert.assertTrue((boolean)dfs.dfs.getLeaseRenewer().isRunning());
            out.close();
            Thread.sleep(750L);
            Assert.assertTrue((boolean)dfs.dfs.getLeaseRenewer().isRunning());
            for (int i = 0; i < 3; ++i) {
                if (!dfs.dfs.getLeaseRenewer().isRunning()) continue;
                Thread.sleep(500L);
            }
            Assert.assertFalse((boolean)dfs.dfs.getLeaseRenewer().isRunning());
            FSDataOutputStream out1 = dfs.create(filepaths[1]);
            Assert.assertTrue((boolean)dfs.dfs.getLeaseRenewer().isRunning());
            FSDataOutputStream out2 = dfs.create(filepaths[2]);
            Assert.assertTrue((boolean)dfs.dfs.getLeaseRenewer().isRunning());
            out1.writeLong(millis);
            Assert.assertTrue((boolean)dfs.dfs.getLeaseRenewer().isRunning());
            out1.close();
            Assert.assertTrue((boolean)dfs.dfs.getLeaseRenewer().isRunning());
            out2.writeLong(millis);
            Assert.assertTrue((boolean)dfs.dfs.getLeaseRenewer().isRunning());
            out2.close();
            Thread.sleep(750L);
            Assert.assertTrue((boolean)dfs.dfs.getLeaseRenewer().isRunning());
            FSDataOutputStream out3 = dfs.create(filepaths[3]);
            Assert.assertTrue((boolean)dfs.dfs.getLeaseRenewer().isRunning());
            Thread.sleep(750L);
            Assert.assertTrue((boolean)dfs.dfs.getLeaseRenewer().isRunning());
            out3.writeLong(millis);
            Assert.assertTrue((boolean)dfs.dfs.getLeaseRenewer().isRunning());
            out3.close();
            Assert.assertTrue((boolean)dfs.dfs.getLeaseRenewer().isRunning());
            Thread.sleep(750L);
            Assert.assertTrue((boolean)dfs.dfs.getLeaseRenewer().isRunning());
            for (int i = 0; i < 3; ++i) {
                if (!dfs.dfs.getLeaseRenewer().isRunning()) continue;
                Thread.sleep(500L);
            }
            Assert.assertFalse((boolean)dfs.dfs.getLeaseRenewer().isRunning());
            dfs.close();
            dfs = (DistributedFileSystem)cluster.getFileSystem();
            Assert.assertFalse((boolean)dfs.dfs.getLeaseRenewer().isRunning());
            FSDataInputStream in = dfs.open(filepaths[0]);
            Assert.assertFalse((boolean)dfs.dfs.getLeaseRenewer().isRunning());
            Assert.assertEquals((long)millis, (long)in.readLong());
            Assert.assertFalse((boolean)dfs.dfs.getLeaseRenewer().isRunning());
            in.close();
            Assert.assertFalse((boolean)dfs.dfs.getLeaseRenewer().isRunning());
            dfs.close();
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStatistics() throws Exception {
        int lsLimit = 2;
        Configuration conf = this.getTestConfiguration();
        conf.setInt("dfs.ls.limit", lsLimit);
        MiniDFSCluster cluster = new MiniDFSCluster(conf, 1, true, null);
        try {
            FileSystem fs = cluster.getFileSystem();
            Path dir = new Path("/test");
            Path file = new Path(dir, "file");
            int readOps = DFSTestUtil.getStatistics(fs).getReadOps();
            int writeOps = DFSTestUtil.getStatistics(fs).getWriteOps();
            int largeReadOps = DFSTestUtil.getStatistics(fs).getLargeReadOps();
            fs.mkdirs(dir);
            this.checkStatistics(fs, readOps, ++writeOps, largeReadOps);
            FSDataOutputStream out = fs.create(file, (short)1);
            out.close();
            this.checkStatistics(fs, readOps, ++writeOps, largeReadOps);
            FileStatus status = fs.getFileStatus(file);
            this.checkStatistics(fs, ++readOps, writeOps, largeReadOps);
            fs.getFileBlockLocations(status, 0L, 0L);
            this.checkStatistics(fs, ++readOps, writeOps, largeReadOps);
            FSDataInputStream in = fs.open(file);
            in.close();
            this.checkStatistics(fs, ++readOps, writeOps, largeReadOps);
            fs.setReplication(file, (short)2);
            this.checkStatistics(fs, readOps, ++writeOps, largeReadOps);
            Path file1 = new Path(dir, "file1");
            fs.rename(file, file1);
            this.checkStatistics(fs, readOps, ++writeOps, largeReadOps);
            fs.getContentSummary(file1);
            this.checkStatistics(fs, ++readOps, writeOps, largeReadOps);
            for (int i = 0; i < 10; ++i) {
                Path p = new Path(dir, Integer.toString(i));
                fs.mkdirs(p);
                FileStatus[] list = fs.listStatus(dir);
                if (list.length > lsLimit) {
                    int iterations = (int)Math.ceil((double)list.length / (double)lsLimit);
                    largeReadOps += iterations;
                    readOps += iterations;
                } else {
                    ++readOps;
                }
                this.checkStatistics(fs, readOps, ++writeOps, largeReadOps);
            }
            fs.getFileChecksum(file1);
            this.checkStatistics(fs, ++readOps, writeOps, largeReadOps);
            fs.setPermission(file1, new FsPermission(511));
            this.checkStatistics(fs, readOps, ++writeOps, largeReadOps);
            fs.setTimes(file1, 0L, 0L);
            this.checkStatistics(fs, readOps, ++writeOps, largeReadOps);
            UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
            fs.setOwner(file1, ugi.getUserName(), ugi.getGroupNames()[0]);
            this.checkStatistics(fs, readOps, ++writeOps, largeReadOps);
            fs.delete(dir, true);
            this.checkStatistics(fs, readOps, ++writeOps, largeReadOps);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    private void checkStatistics(FileSystem fs, int readOps, int writeOps, int largeReadOps) {
        Assert.assertEquals((long)readOps, (long)DFSTestUtil.getStatistics(fs).getReadOps());
        Assert.assertEquals((long)writeOps, (long)DFSTestUtil.getStatistics(fs).getWriteOps());
        Assert.assertEquals((long)largeReadOps, (long)DFSTestUtil.getStatistics(fs).getLargeReadOps());
    }

    @Test
    public void testFileChecksum() throws Exception {
        ((Log4JLogger)HftpFileSystem.LOG).getLogger().setLevel(Level.ALL);
        long seed = RAN.nextLong();
        System.out.println("seed=" + seed);
        RAN.setSeed(seed);
        final Configuration conf = this.getTestConfiguration();
        conf.setBoolean("dfs.webhdfs.enabled", true);
        conf.set("slave.host.name", "localhost");
        MiniDFSCluster cluster = new MiniDFSCluster(conf, 2, true, null);
        FileSystem hdfs = cluster.getFileSystem();
        String nnAddr = conf.get("dfs.http.address");
        UserGroupInformation current = UserGroupInformation.getCurrentUser();
        UserGroupInformation ugi = UserGroupInformation.createUserForTesting((String)(current.getShortUserName() + "x"), (String[])new String[]{"user"});
        try {
            ((DistributedFileSystem)hdfs).getFileChecksum(new Path("/test/TestNonExistingFile"));
            Assert.fail((String)"Expecting FileNotFoundException");
        }
        catch (FileNotFoundException e) {
            Assert.assertTrue((String)"Not throwing the intended exception message", (boolean)e.getMessage().contains("File does not exist: /test/TestNonExistingFile"));
        }
        try {
            Path path = new Path("/test/TestExistingDir/");
            hdfs.mkdirs(path);
            ((DistributedFileSystem)hdfs).getFileChecksum(path);
            Assert.fail((String)"Expecting FileNotFoundException");
        }
        catch (FileNotFoundException e) {
            Assert.assertTrue((String)"Not throwing the intended exception message", (boolean)e.getMessage().contains("File does not exist: /test/TestExistingDir"));
        }
        final String hftpuri = "hftp://" + nnAddr;
        System.out.println("hftpuri=" + hftpuri);
        FileSystem hftp = (FileSystem)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<FileSystem>(){

            @Override
            public FileSystem run() throws Exception {
                return new Path(hftpuri).getFileSystem(conf);
            }
        });
        final String webhdfsuri = "webhdfs://" + nnAddr;
        System.out.println("webhdfsuri=" + webhdfsuri);
        FileSystem webhdfs = (FileSystem)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<FileSystem>(){

            @Override
            public FileSystem run() throws Exception {
                return new Path(webhdfsuri).getFileSystem(conf);
            }
        });
        Path dir = new Path("/filechecksum");
        int block_size = 1024;
        int buffer_size = conf.getInt("io.file.buffer.size", 4096);
        conf.setInt("io.bytes.per.checksum", 512);
        for (int n = 0; n < 5; ++n) {
            byte[] data = new byte[RAN.nextInt(511) + n * 1024 + 1];
            RAN.nextBytes(data);
            System.out.println("data.length=" + data.length);
            Path foo = new Path(dir, "foo" + n);
            FSDataOutputStream out = hdfs.create(foo, false, buffer_size, (short)2, 1024L);
            out.write(data);
            out.close();
            FileChecksum hdfsfoocs = hdfs.getFileChecksum(foo);
            System.out.println("hdfsfoocs=" + hdfsfoocs);
            FileChecksum hftpfoocs = hftp.getFileChecksum(foo);
            System.out.println("hftpfoocs=" + hftpfoocs);
            Path qualified = new Path(hftpuri + dir, "foo" + n);
            FileChecksum qfoocs = hftp.getFileChecksum(qualified);
            System.out.println("qfoocs=" + qfoocs);
            FileChecksum webhdfsfoocs = webhdfs.getFileChecksum(foo);
            System.out.println("webhdfsfoocs=" + webhdfsfoocs);
            Path webhdfsqualified = new Path(webhdfsuri + dir, "foo" + n);
            FileChecksum webhdfs_qfoocs = webhdfs.getFileChecksum(webhdfsqualified);
            System.out.println("webhdfs_qfoocs=" + webhdfs_qfoocs);
            Path bar = new Path(dir, "bar" + n);
            FSDataOutputStream out2 = hdfs.create(bar, false, buffer_size, (short)2, 1024L);
            out2.write(data);
            out2.close();
            FileChecksum barcs = hdfs.getFileChecksum(bar);
            int barhashcode = barcs.hashCode();
            Assert.assertEquals((long)hdfsfoocs.hashCode(), (long)barhashcode);
            Assert.assertEquals((Object)hdfsfoocs, (Object)barcs);
            Assert.assertEquals((long)hftpfoocs.hashCode(), (long)barhashcode);
            Assert.assertEquals((Object)hftpfoocs, (Object)barcs);
            Assert.assertEquals((long)qfoocs.hashCode(), (long)barhashcode);
            Assert.assertEquals((Object)qfoocs, (Object)barcs);
            Assert.assertEquals((long)webhdfsfoocs.hashCode(), (long)barhashcode);
            Assert.assertEquals((Object)webhdfsfoocs, (Object)barcs);
            Assert.assertEquals((long)webhdfs_qfoocs.hashCode(), (long)barhashcode);
            Assert.assertEquals((Object)webhdfs_qfoocs, (Object)barcs);
            hdfs.setPermission(dir, new FsPermission(0));
            try {
                hftp.getFileChecksum(qualified);
                Assert.fail();
            }
            catch (IOException ioe) {
                FileSystem.LOG.info((Object)"GOOD: getting an exception", (Throwable)ioe);
            }
            try {
                webhdfs.getFileChecksum(webhdfsqualified);
                Assert.fail();
            }
            catch (IOException ioe) {
                FileSystem.LOG.info((Object)"GOOD: getting an exception", (Throwable)ioe);
            }
            hdfs.setPermission(dir, new FsPermission(511));
        }
        cluster.shutdown();
    }

    @Test
    public void testAllWithDualPort() throws Exception {
        this.dualPortTesting = true;
        this.testFileSystemCloseAll();
        this.testDFSClose();
        this.testDFSClient();
        this.testFileChecksum();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testFileCloseStatus() throws IOException {
        Configuration conf = this.getTestConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster(conf, 1, true, null);
        DistributedFileSystem fs = (DistributedFileSystem)cluster.getFileSystem();
        try {
            Path file = new Path("/simpleFlush.dat");
            FSDataOutputStream output = fs.create(file);
            output.writeBytes("Some test data");
            output.flush();
            Assert.assertFalse((String)"File status should be open", (boolean)fs.isFileClosed(file));
            output.close();
            Assert.assertTrue((String)"File status should be closed", (boolean)fs.isFileClosed(file));
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }
}

