/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.Semaphore;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;

public class TestFileSystemCaching
extends TestCase {
    public void testDefaultFsUris() throws Exception {
        Configuration conf = new Configuration();
        conf.set("fs.defaultfs.impl", DefaultFs.class.getName());
        URI defaultUri = URI.create("defaultfs://host");
        FileSystem.setDefaultUri((Configuration)conf, (URI)defaultUri);
        FileSystem fs = null;
        FileSystem defaultFs = FileSystem.get((Configuration)conf);
        TestFileSystemCaching.assertEquals((Object)defaultUri, (Object)defaultFs.getUri());
        fs = FileSystem.get((URI)URI.create("defaultfs:/"), (Configuration)conf);
        TestFileSystemCaching.assertSame((Object)defaultFs, (Object)fs);
        fs = FileSystem.get((URI)URI.create("defaultfs:///"), (Configuration)conf);
        TestFileSystemCaching.assertSame((Object)defaultFs, (Object)fs);
        fs = FileSystem.get((URI)URI.create("defaultfs://host"), (Configuration)conf);
        TestFileSystemCaching.assertSame((Object)defaultFs, (Object)fs);
        fs = FileSystem.get((URI)URI.create("defaultfs://host2"), (Configuration)conf);
        TestFileSystemCaching.assertNotSame((Object)defaultFs, (Object)fs);
        fs = FileSystem.get((URI)URI.create("/"), (Configuration)conf);
        TestFileSystemCaching.assertSame((Object)defaultFs, (Object)fs);
        try {
            fs = FileSystem.get((URI)URI.create("//host"), (Configuration)conf);
            TestFileSystemCaching.fail((String)"got fs with auth but no scheme");
        }
        catch (Exception e) {
            TestFileSystemCaching.assertEquals((String)"No FileSystem for scheme: null", (String)e.getMessage());
        }
        try {
            fs = FileSystem.get((URI)URI.create("//host2"), (Configuration)conf);
            TestFileSystemCaching.fail((String)"got fs with auth but no scheme");
        }
        catch (Exception e) {
            TestFileSystemCaching.assertEquals((String)"No FileSystem for scheme: null", (String)e.getMessage());
        }
    }

    public void testCacheEnabledWithInitializeForeverFS() throws Exception {
        final Configuration conf = new Configuration();
        Thread t = new Thread(){

            @Override
            public void run() {
                conf.set("fs.localfs1.impl", "org.apache.hadoop.fs.TestFileSystemCaching$InitializeForeverFileSystem");
                try {
                    FileSystem.get((URI)new URI("localfs1://a"), (Configuration)conf);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
            }
        };
        t.start();
        InitializeForeverFileSystem.sem.acquire();
        conf.set("fs.cachedfile.impl", conf.get("fs.file.impl"));
        FileSystem.get((URI)new URI("cachedfile://a"), (Configuration)conf);
        t.interrupt();
        t.join();
    }

    public static class InitializeForeverFileSystem
    extends LocalFileSystem {
        static final Semaphore sem = new Semaphore(0);

        public void initialize(URI uri, Configuration conf) throws IOException {
            sem.release();
            try {
                while (true) {
                    Thread.sleep(1000L);
                }
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }

    static class DefaultFs
    extends LocalFileSystem {
        URI uri;

        DefaultFs() {
        }

        public void initialize(URI uri, Configuration conf) {
            this.uri = uri;
        }

        public URI getUri() {
            return this.uri;
        }
    }
}

