/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.conf;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.codehaus.jackson.map.ObjectMapper;

public class TestConfiguration
extends TestCase {
    private Configuration conf;
    static final String CONFIG = new File("./test-config.xml").getAbsolutePath();
    static final String CONFIG2 = new File("./test-config2.xml").getAbsolutePath();
    static final Random RAN = new Random();
    final String UNSPEC;
    ArrayList<Prop> props = new ArrayList();
    BufferedWriter out;

    public TestConfiguration() {
        this.UNSPEC = null;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.conf = new Configuration();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        new File(CONFIG).delete();
        new File(CONFIG2).delete();
    }

    private void startConfig() throws IOException {
        this.out.write("<?xml version=\"1.0\"?>\n");
        this.out.write("<configuration>\n");
    }

    private void endConfig() throws IOException {
        this.out.write("</configuration>\n");
        this.out.close();
    }

    private void addInclude(String filename) throws IOException {
        this.out.write("<xi:include href=\"" + filename + "\" xmlns:xi=\"http://www.w3.org/2001/XInclude\"  />\n ");
    }

    public void testVariableSubstitution() throws IOException {
        this.out = new BufferedWriter(new FileWriter(CONFIG));
        this.startConfig();
        this.declareProperty("my.int", "${intvar}", "42");
        this.declareProperty("intvar", "42", "42");
        this.declareProperty("my.base", "/tmp/${user.name}", this.UNSPEC);
        this.declareProperty("my.file", "hello", "hello");
        this.declareProperty("my.suffix", ".txt", ".txt");
        this.declareProperty("my.relfile", "${my.file}${my.suffix}", "hello.txt");
        this.declareProperty("my.fullfile", "${my.base}/${my.file}${my.suffix}", this.UNSPEC);
        this.declareProperty("my.failsexpand", "a${my.undefvar}b", "a${my.undefvar}b");
        this.endConfig();
        Path fileResource = new Path(CONFIG);
        this.conf.addResource(fileResource);
        for (Prop p : this.props) {
            System.out.println("p=" + p.name);
            String gotVal = this.conf.get(p.name);
            String gotRawVal = this.conf.getRaw(p.name);
            TestConfiguration.assertEq(p.val, gotRawVal);
            if (p.expectEval == this.UNSPEC) {
                TestConfiguration.assertTrue((gotVal != null && -1 == gotVal.indexOf("${") ? 1 : 0) != 0);
                continue;
            }
            TestConfiguration.assertEq(p.expectEval, gotVal);
        }
        TestConfiguration.assertTrue((this.conf.getInt("intvar", -1) == 42 ? 1 : 0) != 0);
        TestConfiguration.assertTrue((this.conf.getInt("my.int", -1) == 42 ? 1 : 0) != 0);
    }

    public void testFinalParam() throws IOException {
        this.out = new BufferedWriter(new FileWriter(CONFIG));
        this.startConfig();
        this.declareProperty("my.var", "", "", true);
        this.endConfig();
        Path fileResource = new Path(CONFIG);
        Configuration conf1 = new Configuration();
        conf1.addResource(fileResource);
        TestConfiguration.assertNull((String)"my var is not null", (Object)conf1.get("my.var"));
        this.out = new BufferedWriter(new FileWriter(CONFIG2));
        this.startConfig();
        this.declareProperty("my.var", "myval", "myval", false);
        this.endConfig();
        fileResource = new Path(CONFIG2);
        Configuration conf2 = new Configuration(conf1);
        conf2.addResource(fileResource);
        TestConfiguration.assertNull((String)"my var is not final", (Object)conf2.get("my.var"));
    }

    public static void assertEq(Object a, Object b) {
        System.out.println("assertEq: " + a + ", " + b);
        TestConfiguration.assertEquals((Object)a, (Object)b);
    }

    void declareProperty(String name, String val, String expectEval) throws IOException {
        this.declareProperty(name, val, expectEval, false);
    }

    void declareProperty(String name, String val, String expectEval, boolean isFinal) throws IOException {
        this.appendProperty(name, val, isFinal);
        Prop p = new Prop();
        p.name = name;
        p.val = val;
        p.expectEval = expectEval;
        this.props.add(p);
    }

    void appendProperty(String name, String val) throws IOException {
        this.appendProperty(name, val, false);
    }

    void appendProperty(String name, String val, boolean isFinal) throws IOException {
        this.out.write("<property>");
        this.out.write("<name>");
        this.out.write(name);
        this.out.write("</name>");
        this.out.write("<value>");
        this.out.write(val);
        this.out.write("</value>");
        if (isFinal) {
            this.out.write("<final>true</final>");
        }
        this.out.write("</property>\n");
    }

    public void testOverlay() throws IOException {
        this.out = new BufferedWriter(new FileWriter(CONFIG));
        this.startConfig();
        this.appendProperty("a", "b");
        this.appendProperty("b", "c");
        this.appendProperty("d", "e");
        this.appendProperty("e", "f", true);
        this.endConfig();
        this.out = new BufferedWriter(new FileWriter(CONFIG2));
        this.startConfig();
        this.appendProperty("a", "b");
        this.appendProperty("b", "d");
        this.appendProperty("e", "e");
        this.endConfig();
        Path fileResource = new Path(CONFIG);
        this.conf.addResource(fileResource);
        this.conf.set("c", "d");
        this.conf.set("a", "d");
        Configuration clone = new Configuration(this.conf);
        clone.addResource(new Path(CONFIG2));
        TestConfiguration.assertEquals((String)clone.get("a"), (String)"d");
        TestConfiguration.assertEquals((String)clone.get("b"), (String)"d");
        TestConfiguration.assertEquals((String)clone.get("c"), (String)"d");
        TestConfiguration.assertEquals((String)clone.get("d"), (String)"e");
        TestConfiguration.assertEquals((String)clone.get("e"), (String)"f");
    }

    public void testCommentsInValue() throws IOException {
        this.out = new BufferedWriter(new FileWriter(CONFIG));
        this.startConfig();
        this.appendProperty("my.comment", "this <!--comment here--> contains a comment");
        this.endConfig();
        Path fileResource = new Path(CONFIG);
        this.conf.addResource(fileResource);
        TestConfiguration.assertEquals((String)"this  contains a comment", (String)this.conf.get("my.comment"));
    }

    public void testTrim() throws IOException {
        this.out = new BufferedWriter(new FileWriter(CONFIG));
        this.startConfig();
        String[] whitespaces = new String[]{"", " ", "\n", "\t"};
        String[] name = new String[100];
        for (int i = 0; i < name.length; ++i) {
            name[i] = "foo" + i;
            StringBuilder prefix = new StringBuilder();
            StringBuilder postfix = new StringBuilder();
            for (int j = 0; j < 3; ++j) {
                prefix.append(whitespaces[RAN.nextInt(whitespaces.length)]);
                postfix.append(whitespaces[RAN.nextInt(whitespaces.length)]);
            }
            this.appendProperty(prefix + name[i] + postfix, name[i] + ".value");
        }
        this.endConfig();
        this.conf.addResource(new Path(CONFIG));
        for (String n : name) {
            TestConfiguration.assertEquals((String)(n + ".value"), (String)this.conf.get(n));
        }
    }

    public void testToString() throws IOException {
        this.out = new BufferedWriter(new FileWriter(CONFIG));
        this.startConfig();
        this.endConfig();
        Path fileResource = new Path(CONFIG);
        this.conf.addResource(fileResource);
        String expectedOutput = "Configuration: core-default.xml, core-site.xml, " + fileResource.toString();
        TestConfiguration.assertEquals((String)expectedOutput, (String)this.conf.toString());
    }

    public void testIncludes() throws Exception {
        this.tearDown();
        System.out.println("XXX testIncludes");
        this.out = new BufferedWriter(new FileWriter(CONFIG2));
        this.startConfig();
        this.appendProperty("a", "b");
        this.appendProperty("c", "d");
        this.endConfig();
        this.out = new BufferedWriter(new FileWriter(CONFIG));
        this.startConfig();
        this.addInclude(CONFIG2);
        this.appendProperty("e", "f");
        this.appendProperty("g", "h");
        this.endConfig();
        Path fileResource = new Path(CONFIG);
        this.conf.addResource(fileResource);
        TestConfiguration.assertEquals((String)this.conf.get("a"), (String)"b");
        TestConfiguration.assertEquals((String)this.conf.get("c"), (String)"d");
        TestConfiguration.assertEquals((String)this.conf.get("e"), (String)"f");
        TestConfiguration.assertEquals((String)this.conf.get("g"), (String)"h");
        this.tearDown();
    }

    public void testIntegerRanges() {
        Configuration conf = new Configuration();
        conf.set("first", "-100");
        conf.set("second", "4-6,9-10,27");
        conf.set("third", "34-");
        Configuration.IntegerRanges range = conf.getRange("first", null);
        System.out.println("first = " + range);
        TestConfiguration.assertEquals((boolean)true, (boolean)range.isIncluded(0));
        TestConfiguration.assertEquals((boolean)true, (boolean)range.isIncluded(1));
        TestConfiguration.assertEquals((boolean)true, (boolean)range.isIncluded(100));
        TestConfiguration.assertEquals((boolean)false, (boolean)range.isIncluded(101));
        range = conf.getRange("second", null);
        System.out.println("second = " + range);
        TestConfiguration.assertEquals((boolean)false, (boolean)range.isIncluded(3));
        TestConfiguration.assertEquals((boolean)true, (boolean)range.isIncluded(4));
        TestConfiguration.assertEquals((boolean)true, (boolean)range.isIncluded(6));
        TestConfiguration.assertEquals((boolean)false, (boolean)range.isIncluded(7));
        TestConfiguration.assertEquals((boolean)false, (boolean)range.isIncluded(8));
        TestConfiguration.assertEquals((boolean)true, (boolean)range.isIncluded(9));
        TestConfiguration.assertEquals((boolean)true, (boolean)range.isIncluded(10));
        TestConfiguration.assertEquals((boolean)false, (boolean)range.isIncluded(11));
        TestConfiguration.assertEquals((boolean)false, (boolean)range.isIncluded(26));
        TestConfiguration.assertEquals((boolean)true, (boolean)range.isIncluded(27));
        TestConfiguration.assertEquals((boolean)false, (boolean)range.isIncluded(28));
        range = conf.getRange("third", null);
        System.out.println("third = " + range);
        TestConfiguration.assertEquals((boolean)false, (boolean)range.isIncluded(33));
        TestConfiguration.assertEquals((boolean)true, (boolean)range.isIncluded(34));
        TestConfiguration.assertEquals((boolean)true, (boolean)range.isIncluded(100000000));
    }

    public void testHexValues() throws IOException {
        this.out = new BufferedWriter(new FileWriter(CONFIG));
        this.startConfig();
        this.appendProperty("test.hex1", "0x10");
        this.appendProperty("test.hex2", "0xF");
        this.appendProperty("test.hex3", "-0x10");
        this.endConfig();
        Path fileResource = new Path(CONFIG);
        this.conf.addResource(fileResource);
        TestConfiguration.assertEquals((int)16, (int)this.conf.getInt("test.hex1", 0));
        TestConfiguration.assertEquals((long)16L, (long)this.conf.getLong("test.hex1", 0L));
        TestConfiguration.assertEquals((int)15, (int)this.conf.getInt("test.hex2", 0));
        TestConfiguration.assertEquals((long)15L, (long)this.conf.getLong("test.hex2", 0L));
        TestConfiguration.assertEquals((int)-16, (int)this.conf.getInt("test.hex3", 0));
        TestConfiguration.assertEquals((long)-16L, (long)this.conf.getLong("test.hex3", 0L));
    }

    public void testIntegerValues() throws IOException {
        this.out = new BufferedWriter(new FileWriter(CONFIG));
        this.startConfig();
        this.appendProperty("test.int1", "20");
        this.appendProperty("test.int2", "020");
        this.appendProperty("test.int3", "-20");
        this.endConfig();
        Path fileResource = new Path(CONFIG);
        this.conf.addResource(fileResource);
        TestConfiguration.assertEquals((int)20, (int)this.conf.getInt("test.int1", 0));
        TestConfiguration.assertEquals((long)20L, (long)this.conf.getLong("test.int1", 0L));
        TestConfiguration.assertEquals((int)20, (int)this.conf.getInt("test.int2", 0));
        TestConfiguration.assertEquals((long)20L, (long)this.conf.getLong("test.int2", 0L));
        TestConfiguration.assertEquals((int)-20, (int)this.conf.getInt("test.int3", 0));
        TestConfiguration.assertEquals((long)-20L, (long)this.conf.getLong("test.int3", 0L));
    }

    public void testEnum() throws IOException {
        Configuration conf = new Configuration();
        conf.setEnum("test.enum", (Enum)Dingo.FOO);
        TestConfiguration.assertSame((Object)((Object)Dingo.FOO), (Object)conf.getEnum("test.enum", (Enum)Dingo.BAR));
        TestConfiguration.assertSame((Object)((Object)Yak.FOO), (Object)conf.getEnum("test.enum", (Enum)Yak.RAB));
        boolean fail = false;
        try {
            conf.setEnum("test.enum", (Enum)Dingo.BAR);
            Yak y = (Yak)conf.getEnum("test.enum", (Enum)Yak.FOO);
        }
        catch (IllegalArgumentException e) {
            fail = true;
        }
        TestConfiguration.assertTrue((boolean)fail);
    }

    public void testReload() throws IOException {
        this.out = new BufferedWriter(new FileWriter(CONFIG));
        this.startConfig();
        this.appendProperty("test.key1", "final-value1", true);
        this.appendProperty("test.key2", "value2");
        this.endConfig();
        Path fileResource = new Path(CONFIG);
        this.conf.addResource(fileResource);
        this.out = new BufferedWriter(new FileWriter(CONFIG2));
        this.startConfig();
        this.appendProperty("test.key1", "value1");
        this.appendProperty("test.key3", "value3");
        this.endConfig();
        Path fileResource1 = new Path(CONFIG2);
        this.conf.addResource(fileResource1);
        this.conf.set("test.key3", "value4");
        this.conf.set("test.key4", "value5");
        TestConfiguration.assertEquals((String)"final-value1", (String)this.conf.get("test.key1"));
        TestConfiguration.assertEquals((String)"value2", (String)this.conf.get("test.key2"));
        TestConfiguration.assertEquals((String)"value4", (String)this.conf.get("test.key3"));
        TestConfiguration.assertEquals((String)"value5", (String)this.conf.get("test.key4"));
        this.out = new BufferedWriter(new FileWriter(CONFIG));
        this.startConfig();
        this.appendProperty("test.key1", "final-value1");
        this.appendProperty("test.key3", "final-value3", true);
        this.endConfig();
        this.conf.reloadConfiguration();
        TestConfiguration.assertEquals((String)"value1", (String)this.conf.get("test.key1"));
        TestConfiguration.assertEquals((String)"value4", (String)this.conf.get("test.key3"));
        TestConfiguration.assertEquals(null, (String)this.conf.get("test.key2"));
        TestConfiguration.assertEquals((String)"value5", (String)this.conf.get("test.key4"));
    }

    public void testSize() throws IOException {
        Configuration conf = new Configuration(false);
        conf.set("a", "A");
        conf.set("b", "B");
        TestConfiguration.assertEquals((int)2, (int)conf.size());
    }

    public void testClear() throws IOException {
        Configuration conf = new Configuration(false);
        conf.set("a", "A");
        conf.set("b", "B");
        conf.clear();
        TestConfiguration.assertEquals((int)0, (int)conf.size());
        TestConfiguration.assertFalse((boolean)conf.iterator().hasNext());
    }

    public static void main(String[] argv) throws Exception {
        TestRunner.main((String[])new String[]{TestConfiguration.class.getName()});
    }

    public void testDumpConfiguration() throws IOException {
        StringWriter outWriter = new StringWriter();
        Configuration.dumpConfiguration((Configuration)this.conf, (Writer)outWriter);
        String jsonStr = outWriter.toString();
        ObjectMapper mapper = new ObjectMapper();
        JsonConfiguration jconf = (JsonConfiguration)mapper.readValue(jsonStr, JsonConfiguration.class);
        int defaultLength = jconf.getProperties().length;
        this.out = new BufferedWriter(new FileWriter(CONFIG));
        this.startConfig();
        this.appendProperty("test.key1", "value1");
        this.appendProperty("test.key2", "value2", true);
        this.appendProperty("test.key3", "value3");
        this.endConfig();
        Path fileResource = new Path(CONFIG);
        this.conf.addResource(fileResource);
        this.out.close();
        outWriter = new StringWriter();
        Configuration.dumpConfiguration((Configuration)this.conf, (Writer)outWriter);
        jsonStr = outWriter.toString();
        mapper = new ObjectMapper();
        jconf = (JsonConfiguration)mapper.readValue(jsonStr, JsonConfiguration.class);
        int length = jconf.getProperties().length;
        TestConfiguration.assertEquals((int)length, (int)(defaultLength + 3));
        this.out = new BufferedWriter(new FileWriter(CONFIG2));
        this.startConfig();
        this.appendProperty("test.key1", "newValue1");
        this.appendProperty("test.key2", "newValue2");
        this.endConfig();
        Path fileResource1 = new Path(CONFIG2);
        this.conf.addResource(fileResource1);
        this.out.close();
        outWriter = new StringWriter();
        Configuration.dumpConfiguration((Configuration)this.conf, (Writer)outWriter);
        jsonStr = outWriter.toString();
        mapper = new ObjectMapper();
        jconf = (JsonConfiguration)mapper.readValue(jsonStr, JsonConfiguration.class);
        HashMap<String, JsonProperty> confDump = new HashMap<String, JsonProperty>();
        for (JsonProperty prop : jconf.getProperties()) {
            confDump.put(prop.getKey(), prop);
        }
        TestConfiguration.assertEquals((String)"newValue1", (String)((JsonProperty)confDump.get("test.key1")).getValue());
        TestConfiguration.assertEquals((boolean)false, (boolean)((JsonProperty)confDump.get("test.key1")).getIsFinal());
        TestConfiguration.assertEquals((String)fileResource1.toString(), (String)((JsonProperty)confDump.get("test.key1")).getResource());
        TestConfiguration.assertEquals((String)"value2", (String)((JsonProperty)confDump.get("test.key2")).getValue());
        TestConfiguration.assertEquals((boolean)true, (boolean)((JsonProperty)confDump.get("test.key2")).getIsFinal());
        TestConfiguration.assertEquals((String)fileResource.toString(), (String)((JsonProperty)confDump.get("test.key2")).getResource());
        TestConfiguration.assertEquals((String)"value3", (String)((JsonProperty)confDump.get("test.key3")).getValue());
        TestConfiguration.assertEquals((boolean)false, (boolean)((JsonProperty)confDump.get("test.key3")).getIsFinal());
        TestConfiguration.assertEquals((String)fileResource.toString(), (String)((JsonProperty)confDump.get("test.key3")).getResource());
        this.conf.set("test.key4", "value4");
        this.conf.set("test.key5", "value5");
        this.conf.set("test.key6", "${test.key5}");
        outWriter = new StringWriter();
        Configuration.dumpConfiguration((Configuration)this.conf, (Writer)outWriter);
        jsonStr = outWriter.toString();
        mapper = new ObjectMapper();
        jconf = (JsonConfiguration)mapper.readValue(jsonStr, JsonConfiguration.class);
        confDump = new HashMap();
        for (JsonProperty prop : jconf.getProperties()) {
            confDump.put(prop.getKey(), prop);
        }
        TestConfiguration.assertEquals((String)"value5", (String)((JsonProperty)confDump.get("test.key6")).getValue());
        TestConfiguration.assertEquals((String)"Unknown", (String)((JsonProperty)confDump.get("test.key4")).getResource());
        outWriter.close();
    }

    public void testDumpConfiguratioWithoutDefaults() throws IOException {
        Configuration config = new Configuration(false);
        StringWriter outWriter = new StringWriter();
        Configuration.dumpConfiguration((Configuration)config, (Writer)outWriter);
        String jsonStr = outWriter.toString();
        ObjectMapper mapper = new ObjectMapper();
        JsonConfiguration jconf = (JsonConfiguration)mapper.readValue(jsonStr, JsonConfiguration.class);
        TestConfiguration.assertEquals((int)0, (int)jconf.getProperties().length);
        this.out = new BufferedWriter(new FileWriter(CONFIG));
        this.startConfig();
        this.appendProperty("test.key1", "value1");
        this.appendProperty("test.key2", "value2", true);
        this.endConfig();
        Path fileResource = new Path(CONFIG);
        config.addResource(fileResource);
        this.out.close();
        outWriter = new StringWriter();
        Configuration.dumpConfiguration((Configuration)config, (Writer)outWriter);
        jsonStr = outWriter.toString();
        mapper = new ObjectMapper();
        jconf = (JsonConfiguration)mapper.readValue(jsonStr, JsonConfiguration.class);
        HashMap<String, JsonProperty> confDump = new HashMap<String, JsonProperty>();
        for (JsonProperty prop : jconf.getProperties()) {
            confDump.put(prop.getKey(), prop);
        }
        TestConfiguration.assertEquals((int)2, (int)jconf.getProperties().length);
        TestConfiguration.assertEquals((String)((JsonProperty)confDump.get("test.key1")).getValue(), (String)"value1");
        TestConfiguration.assertEquals((String)((JsonProperty)confDump.get("test.key2")).getValue(), (String)"value2");
        TestConfiguration.assertEquals((boolean)false, (boolean)((JsonProperty)confDump.get("test.key1")).getIsFinal());
        TestConfiguration.assertEquals((boolean)true, (boolean)((JsonProperty)confDump.get("test.key2")).getIsFinal());
        for (JsonProperty prop : jconf.getProperties()) {
            TestConfiguration.assertEquals((String)fileResource.toString(), (String)prop.getResource());
        }
    }

    public void testGetValByRegex() {
        Configuration conf = new Configuration();
        String key1 = "t.abc.key1";
        String key2 = "t.abc.key2";
        String key3 = "tt.abc.key3";
        String key4 = "t.abc.ey3";
        conf.set(key1, "value1");
        conf.set(key2, "value2");
        conf.set(key3, "value3");
        conf.set(key4, "value3");
        Map res = conf.getValByRegex("^t\\..*\\.key\\d");
        TestConfiguration.assertTrue((String)("Conf didn't get key " + key1), (boolean)res.containsKey(key1));
        TestConfiguration.assertTrue((String)("Conf didn't get key " + key2), (boolean)res.containsKey(key2));
        TestConfiguration.assertTrue((String)("Picked out wrong key " + key3), (!res.containsKey(key3) ? 1 : 0) != 0);
        TestConfiguration.assertTrue((String)("Picked out wrong key " + key4), (!res.containsKey(key4) ? 1 : 0) != 0);
    }

    public void testUnset() {
        Configuration conf = new Configuration();
        conf.set("foo", "bar");
        TestConfiguration.assertNotNull((Object)conf.get("foo"));
        conf.unset("foo");
        TestConfiguration.assertNull((Object)conf.get("foo"));
    }

    static class JsonProperty {
        String key;
        String value;
        boolean isFinal;
        String resource;

        JsonProperty() {
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public boolean getIsFinal() {
            return this.isFinal;
        }

        public void setIsFinal(boolean isFinal) {
            this.isFinal = isFinal;
        }

        public String getResource() {
            return this.resource;
        }

        public void setResource(String resource) {
            this.resource = resource;
        }
    }

    static class JsonConfiguration {
        JsonProperty[] properties;

        JsonConfiguration() {
        }

        public JsonProperty[] getProperties() {
            return this.properties;
        }

        public void setProperties(JsonProperty[] properties) {
            this.properties = properties;
        }
    }

    static enum Yak {
        RAB,
        FOO;

    }

    static enum Dingo {
        FOO,
        BAR;

    }

    static class Prop {
        String name;
        String val;
        String expectEval;

        Prop() {
        }
    }
}

