/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.rumen;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobHistory;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.UtilsForTests;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.tools.rumen.ConcatenatedInputFilesDemuxer;
import org.apache.hadoop.tools.rumen.DeepCompare;
import org.apache.hadoop.tools.rumen.DeepInequalityException;
import org.apache.hadoop.tools.rumen.DefaultInputDemuxer;
import org.apache.hadoop.tools.rumen.HadoopLogsAnalyzer;
import org.apache.hadoop.tools.rumen.HistoryEvent;
import org.apache.hadoop.tools.rumen.JobBuilder;
import org.apache.hadoop.tools.rumen.JobConfPropertyNames;
import org.apache.hadoop.tools.rumen.JobConfigurationParser;
import org.apache.hadoop.tools.rumen.JobHistoryParser;
import org.apache.hadoop.tools.rumen.JobHistoryParserFactory;
import org.apache.hadoop.tools.rumen.JsonObjectMapperParser;
import org.apache.hadoop.tools.rumen.LoggedJob;
import org.apache.hadoop.tools.rumen.LoggedNetworkTopology;
import org.apache.hadoop.tools.rumen.LoggedTask;
import org.apache.hadoop.tools.rumen.LoggedTaskAttempt;
import org.apache.hadoop.tools.rumen.Pair;
import org.apache.hadoop.tools.rumen.ParsedJob;
import org.apache.hadoop.tools.rumen.ParsedTask;
import org.apache.hadoop.tools.rumen.ParsedTaskAttempt;
import org.apache.hadoop.tools.rumen.PossiblyDecompressedInputStream;
import org.apache.hadoop.tools.rumen.Pre21JobHistoryConstants;
import org.apache.hadoop.tools.rumen.ResourceUsageMetrics;
import org.apache.hadoop.tools.rumen.RewindableInputStream;
import org.apache.hadoop.tools.rumen.TaskAttemptFinishedEvent;
import org.apache.hadoop.tools.rumen.TaskAttemptUnsuccessfulCompletionEvent;
import org.apache.hadoop.tools.rumen.TaskStartedEvent;
import org.apache.hadoop.tools.rumen.TopologyBuilder;
import org.apache.hadoop.tools.rumen.TraceBuilder;
import org.apache.hadoop.tools.rumen.TreePath;
import org.apache.hadoop.tools.rumen.ZombieJob;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.Assert;
import org.junit.Test;

public class TestRumenJobTraces {
    private static final Log LOG = LogFactory.getLog(TestRumenJobTraces.class);

    @Test
    public void testSmallTrace() throws Exception {
        this.performSingleTest("sample-job-tracker-logs.gz", "job-tracker-logs-topology-output", "job-tracker-logs-trace-output.gz");
    }

    @Test
    public void testTruncatedTask() throws Exception {
        this.performSingleTest("truncated-job-tracker-log", "truncated-topology-output", "truncated-trace-output");
    }

    private void performSingleTest(String jtLogName, String goldTopology, String goldTrace) throws Exception {
        Configuration conf = new Configuration();
        LocalFileSystem lfs = FileSystem.getLocal((Configuration)conf);
        Path rootInputDir = new Path(System.getProperty("test.tools.input.dir", "")).makeQualified((FileSystem)lfs);
        Path rootTempDir = new Path(System.getProperty("test.build.data", "/tmp")).makeQualified((FileSystem)lfs);
        Path rootInputFile = new Path(rootInputDir, "rumen/small-trace-test");
        Path tempDir = new Path(rootTempDir, "TestRumenJobTraces");
        lfs.delete(tempDir, true);
        Path topologyFile = new Path(tempDir, jtLogName + "-topology.json");
        Path traceFile = new Path(tempDir, jtLogName + "-trace.json");
        Path inputFile = new Path(rootInputFile, jtLogName);
        System.out.println("topology result file = " + topologyFile);
        System.out.println("trace result file = " + traceFile);
        String[] args = new String[]{"-v1", "-write-topology", topologyFile.toString(), "-write-job-trace", traceFile.toString(), inputFile.toString()};
        Path topologyGoldFile = new Path(rootInputFile, goldTopology);
        Path traceGoldFile = new Path(rootInputFile, goldTrace);
        HadoopLogsAnalyzer analyzer = new HadoopLogsAnalyzer();
        int result = ToolRunner.run((Tool)analyzer, (String[])args);
        Assert.assertEquals((String)"Non-zero exit", (long)0L, (long)result);
        TestRumenJobTraces.jsonFileMatchesGold(conf, topologyFile, topologyGoldFile, LoggedNetworkTopology.class, "topology");
        TestRumenJobTraces.jsonFileMatchesGold(conf, traceFile, traceGoldFile, LoggedJob.class, "trace");
    }

    @Test
    public void testRumenViaDispatch() throws Exception {
        Configuration conf = new Configuration();
        LocalFileSystem lfs = FileSystem.getLocal((Configuration)conf);
        Path rootInputDir = new Path(System.getProperty("test.tools.input.dir", "")).makeQualified((FileSystem)lfs);
        Path rootTempDir = new Path(System.getProperty("test.build.data", "/tmp")).makeQualified((FileSystem)lfs);
        Path rootInputPath = new Path(rootInputDir, "rumen/small-trace-test");
        Path tempDir = new Path(rootTempDir, "TestRumenViaDispatch");
        lfs.delete(tempDir, true);
        Path topologyPath = new Path(tempDir, "dispatch-topology.json");
        Path tracePath = new Path(tempDir, "dispatch-trace.json");
        Path inputPath = new Path(rootInputPath, "dispatch-sample-v20-jt-log.gz");
        System.out.println("topology result file = " + topologyPath);
        System.out.println("testRumenViaDispatch() trace result file = " + tracePath);
        String demuxerClassName = ConcatenatedInputFilesDemuxer.class.getName();
        String[] args = new String[]{"-demuxer", demuxerClassName, tracePath.toString(), topologyPath.toString(), inputPath.toString()};
        Path topologyGoldFile = new Path(rootInputPath, "dispatch-topology-output.json.gz");
        Path traceGoldFile = new Path(rootInputPath, "dispatch-trace-output.json.gz");
        TraceBuilder analyzer = new TraceBuilder();
        int result = ToolRunner.run((Tool)analyzer, (String[])args);
        Assert.assertEquals((String)"Non-zero exit", (long)0L, (long)result);
        TestRumenJobTraces.jsonFileMatchesGold(conf, topologyPath, topologyGoldFile, LoggedNetworkTopology.class, "topology");
        TestRumenJobTraces.jsonFileMatchesGold(conf, tracePath, traceGoldFile, LoggedJob.class, "trace");
    }

    @Test
    public void testBracketedCounters() throws Exception {
        Configuration conf = new Configuration();
        LocalFileSystem lfs = FileSystem.getLocal((Configuration)conf);
        Path rootInputDir = new Path(System.getProperty("test.tools.input.dir", "")).makeQualified((FileSystem)lfs);
        Path rootTempDir = new Path(System.getProperty("test.build.data", "/tmp")).makeQualified((FileSystem)lfs);
        Path rootInputPath = new Path(rootInputDir, "rumen/small-trace-test");
        Path tempDir = new Path(rootTempDir, "TestBracketedCounters");
        lfs.delete(tempDir, true);
        Path topologyPath = new Path(tempDir, "dispatch-topology.json");
        Path tracePath = new Path(tempDir, "dispatch-trace.json");
        Path inputPath = new Path(rootInputPath, "counters-format-test-logs");
        System.out.println("topology result file = " + topologyPath);
        System.out.println("testBracketedCounters() trace result file = " + tracePath);
        Path goldPath = new Path(rootInputPath, "counters-test-trace.json.gz");
        String[] args = new String[]{tracePath.toString(), topologyPath.toString(), inputPath.toString()};
        TraceBuilder analyzer = new TraceBuilder();
        int result = ToolRunner.run((Tool)analyzer, (String[])args);
        Assert.assertEquals((String)"Non-zero exit", (long)0L, (long)result);
        TestRumenJobTraces.jsonFileMatchesGold(conf, tracePath, goldPath, LoggedJob.class, "trace");
    }

    private void validateParsedJob(ParsedJob parsedJob, int numMaps, int numReduces, String queueName) {
        this.validateParsedJobAPI(parsedJob, numMaps, numReduces, queueName);
        List maps = parsedJob.obtainMapTasks();
        for (ParsedTask task : maps) {
            this.validateParsedTask(task);
        }
        List reduces = parsedJob.obtainReduceTasks();
        for (ParsedTask task : reduces) {
            this.validateParsedTask(task);
        }
        List others = parsedJob.obtainOtherTasks();
        for (ParsedTask task : others) {
            this.validateParsedTask(task);
        }
    }

    private void validateParsedJobAPI(ParsedJob parsedJob, int numMaps, int numReduces, String queueName) {
        LOG.info((Object)("Validating ParsedJob.obtainXXX api... for " + parsedJob.getJobID()));
        Assert.assertNotNull((String)"Job acls in ParsedJob is null", (Object)parsedJob.obtainJobAcls());
        Assert.assertNotNull((String)"Job conf path in ParsedJob is null", (Object)parsedJob.obtainJobConfpath());
        Assert.assertEquals((String)"Job queue in ParsedJob is wrong", (Object)queueName, (Object)parsedJob.getQueue());
        Assert.assertNotNull((String)"Map Counters in ParsedJob is null", (Object)parsedJob.obtainMapCounters());
        Assert.assertNotNull((String)"Reduce Counters in ParsedJob is null", (Object)parsedJob.obtainReduceCounters());
        Assert.assertNotNull((String)"Total Counters in ParsedJob is null", (Object)parsedJob.obtainTotalCounters());
        Assert.assertNotNull((String)"Map Tasks List in ParsedJob is null", (Object)parsedJob.obtainMapTasks());
        Assert.assertNotNull((String)"Reduce Tasks List in ParsedJob is null", (Object)parsedJob.obtainReduceTasks());
        Assert.assertNotNull((String)"Other Tasks List in ParsedJob is null", (Object)parsedJob.obtainOtherTasks());
        Assert.assertEquals((String)"Number of map tasks in ParsedJob is wrong", (long)numMaps, (long)parsedJob.obtainMapTasks().size());
        Assert.assertEquals((String)"Number of reduce tasks in ParsedJob is wrong", (double)numReduces, (double)parsedJob.obtainReduceTasks().size(), (double)1.0);
        Assert.assertTrue((String)"Total Counters in ParsedJob is empty", (parsedJob.obtainTotalCounters().size() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Map Counters in ParsedJob is empty", (parsedJob.obtainMapCounters().size() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Reduce Counters in ParsedJob is empty", (parsedJob.obtainReduceCounters().size() > 0 ? 1 : 0) != 0);
    }

    private void validateParsedTask(ParsedTask parsedTask) {
        this.validateParsedTaskAPI(parsedTask);
        List attempts = parsedTask.obtainTaskAttempts();
        for (ParsedTaskAttempt attempt : attempts) {
            this.validateParsedTaskAttemptAPI(attempt);
        }
    }

    private void validateParsedTaskAPI(ParsedTask parsedTask) {
        LOG.info((Object)("Validating ParsedTask.obtainXXX api... for " + parsedTask.getTaskID()));
        Assert.assertNotNull((String)"Task counters in ParsedTask is null", (Object)parsedTask.obtainCounters());
        if (parsedTask.getTaskStatus() == Pre21JobHistoryConstants.Values.SUCCESS) {
            Assert.assertTrue((String)"Task counters in ParsedTask is empty", (parsedTask.obtainCounters().size() > 0 ? 1 : 0) != 0);
            Assert.assertNull((String)"Diagnostic-info is non-null for a succeeded task", (Object)parsedTask.obtainDiagnosticInfo());
            Assert.assertNull((String)"Failed-due-to-attemptId is non-null for a succeeded task", (Object)parsedTask.obtainFailedDueToAttemptId());
        } else {
            Assert.assertNotNull((String)"Diagnostic-info is non-null for a succeeded task", (Object)parsedTask.obtainDiagnosticInfo());
            Assert.assertNotNull((String)"Failed-due-to-attemptId is non-null for a succeeded task", (Object)parsedTask.obtainFailedDueToAttemptId());
        }
        List attempts = parsedTask.obtainTaskAttempts();
        Assert.assertNotNull((String)"TaskAttempts list in ParsedTask is null", (Object)attempts);
        Assert.assertTrue((String)"TaskAttempts list in ParsedTask is empty", (attempts.size() > 0 ? 1 : 0) != 0);
    }

    private void validateParsedTaskAttemptAPI(ParsedTaskAttempt parsedTaskAttempt) {
        LOG.info((Object)("Validating ParsedTaskAttempt.obtainXXX api... for " + parsedTaskAttempt.getAttemptID()));
        Assert.assertNotNull((String)"Counters in ParsedTaskAttempt is null", (Object)parsedTaskAttempt.obtainCounters());
        if (parsedTaskAttempt.getResult() == Pre21JobHistoryConstants.Values.SUCCESS) {
            Assert.assertTrue((String)"Counters in ParsedTaskAttempt is empty", (parsedTaskAttempt.obtainCounters().size() > 0 ? 1 : 0) != 0);
            Assert.assertNull((String)"Diagnostic-info is non-null for a succeeded taskAttempt", (Object)parsedTaskAttempt.obtainDiagnosticInfo());
        } else {
            Assert.assertNotNull((String)"Diagnostic-info is non-null for a succeeded taskAttempt", (Object)parsedTaskAttempt.obtainDiagnosticInfo());
        }
        Assert.assertNotNull((String)"TrackerName in ParsedTaskAttempt is null", (Object)parsedTaskAttempt.obtainTrackerName());
        Assert.assertNotNull((String)"http-port info in ParsedTaskAttempt is null", (Object)parsedTaskAttempt.obtainHttpPort());
    }

    @Test
    public void testHadoop20JHParser() throws Exception {
    }

    @Test
    public void testJobHistoryFilenameParsing() throws IOException {
        Configuration conf = new Configuration();
        LocalFileSystem lfs = FileSystem.getLocal((Configuration)conf);
        String user = "test";
        JobID jid = new JobID("12345", 1);
        Path rootInputDir = new Path(System.getProperty("test.tools.input.dir", "")).makeQualified((FileSystem)lfs);
        Path jhFilename = new Path(jid + "_1234_user_jobname");
        org.apache.hadoop.mapreduce.JobID extractedJID = org.apache.hadoop.mapreduce.JobID.forName((String)TraceBuilder.extractJobID((String)jhFilename.getName()));
        Assert.assertEquals((String)"TraceBuilder failed to parse the current JH filename", (Object)jid, (Object)extractedJID);
        Path jhConfFilename = new Path(jid + "_conf.xml");
        Assert.assertTrue((String)"TraceBuilder failed to parse the current JH conf filename", (boolean)TraceBuilder.isJobConfXml((String)jhConfFilename.getName(), null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProcessInputArgument() throws Exception {
        Configuration conf = new Configuration();
        LocalFileSystem lfs = FileSystem.getLocal((Configuration)conf);
        Path rootTempDir = new Path(System.getProperty("test.build.data", "/tmp")).makeQualified(lfs.getUri(), lfs.getWorkingDirectory());
        Path testRootInputDir = new Path(rootTempDir, "TestProcessInputArgument");
        Path nestedInputDir = new Path(testRootInputDir, "1/2/3/4");
        Path globbedInputNestedDir = lfs.makeQualified(new Path(testRootInputDir, "*/*/*/*/*"));
        try {
            lfs.delete(nestedInputDir, true);
            ArrayList<String> recursiveInputPaths = new ArrayList<String>();
            ArrayList<String> nonRecursiveInputPaths = new ArrayList<String>();
            this.createHistoryLogsHierarchy(nestedInputDir, (FileSystem)lfs, recursiveInputPaths, nonRecursiveInputPaths);
            List inputs = TraceBuilder.MyOptions.processInputArgument((String)globbedInputNestedDir.toString(), (Configuration)conf, (boolean)false);
            this.validateHistoryLogPaths(inputs, nonRecursiveInputPaths);
            inputs = TraceBuilder.MyOptions.processInputArgument((String)globbedInputNestedDir.toString(), (Configuration)conf, (boolean)true);
            this.validateHistoryLogPaths(inputs, recursiveInputPaths);
        }
        finally {
            lfs.delete(testRootInputDir, true);
        }
    }

    private void validateHistoryLogPaths(List<Path> inputs, List<String> expectedHistoryFileNames) throws IOException {
        System.out.println("\nExpected history files are:");
        for (String historyFile : expectedHistoryFileNames) {
            System.out.println(historyFile);
        }
        System.out.println("\nResultant history files are:");
        ArrayList<String> historyLogs = new ArrayList<String>();
        for (Path p : inputs) {
            historyLogs.add(p.toUri().getPath());
            System.out.println(p.toUri().getPath());
        }
        Assert.assertEquals((String)"Number of history logs found is different from the expected.", (long)expectedHistoryFileNames.size(), (long)inputs.size());
        Assert.assertTrue((String)"Some of the history log files do not match the expected.", (boolean)((Object)historyLogs).equals(expectedHistoryFileNames));
    }

    private void createHistoryLogsHierarchy(Path nestedInputDir, FileSystem fs, List<String> recursiveInputPaths, List<String> nonRecursiveInputPaths) throws IOException {
        ArrayList<Path> dirs = new ArrayList<Path>();
        Path inputPath1 = new Path(nestedInputDir, "historyFile.txt");
        Path emptyDir = new Path(nestedInputDir, "emptyDir");
        Path historyDir = new Path(nestedInputDir, "historyDir");
        fs.mkdirs(nestedInputDir);
        fs.createNewFile(inputPath1);
        fs.mkdirs(emptyDir);
        fs.mkdirs(historyDir);
        dirs.add(historyDir);
        Path subDir1 = new Path(historyDir, "subDir1");
        fs.mkdirs(subDir1);
        dirs.add(subDir1);
        Path subDir2 = new Path(historyDir, "subDir2");
        fs.mkdirs(subDir2);
        dirs.add(subDir2);
        Path subDir11 = new Path(subDir1, "subDir11");
        fs.mkdirs(subDir11);
        dirs.add(subDir11);
        Path subDir21 = new Path(subDir2, "subDir21");
        fs.mkdirs(subDir21);
        int i = 0;
        for (Path dir : dirs) {
            Path gzPath = new Path(dir, "historyFile" + ++i + ".gz");
            Path txtPath = new Path(dir, "historyFile" + i + ".txt");
            fs.createNewFile(txtPath);
            fs.createNewFile(gzPath);
            recursiveInputPaths.add(gzPath.toUri().getPath());
            recursiveInputPaths.add(txtPath.toUri().getPath());
            if (i != 1) continue;
            nonRecursiveInputPaths.add(gzPath.toUri().getPath());
            nonRecursiveInputPaths.add(txtPath.toUri().getPath());
        }
        recursiveInputPaths.add(inputPath1.toUri().getPath());
        nonRecursiveInputPaths.add(inputPath1.toUri().getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCurrentJHParser() throws Exception {
        Configuration conf = new Configuration();
        LocalFileSystem lfs = FileSystem.getLocal((Configuration)conf);
        Path rootTempDir = new Path(System.getProperty("test.build.data", "/tmp")).makeQualified((FileSystem)lfs);
        Path tempDir = new Path(rootTempDir, "TestCurrentJHParser");
        lfs.delete(tempDir, true);
        String queueName = "testQueue";
        conf.setInt("mapred.tasktracker.map.tasks.maximum", 1);
        conf.setInt("mapred.tasktracker.reduce.tasks.maximum", 1);
        conf.set("mapred.queue.names", queueName);
        MiniMRCluster mrCluster = new MiniMRCluster(1, "file:///", 1, null, null, new JobConf(conf));
        Path inDir = new Path(tempDir, "input");
        Path outDir = new Path(tempDir, "output");
        JobHistoryParser parser = null;
        RewindableInputStream ris = null;
        ArrayList<String> seenEvents = new ArrayList<String>(10);
        RunningJob rJob = null;
        try {
            HistoryEvent e;
            JobConf jobConf = mrCluster.createJobConf();
            jobConf.setQueueName(queueName);
            rJob = UtilsForTests.runJob(jobConf, inDir, outDir, 1, 1);
            rJob.waitForCompletion();
            Assert.assertTrue((String)"Job failed", (boolean)rJob.isSuccessful());
            JobID id = rJob.getID();
            Path inputPath = new Path(JobHistory.getHistoryFilePath((JobID)JobID.downgrade((org.apache.hadoop.mapreduce.JobID)id)));
            for (int i = 0; i < 100 && !lfs.exists(inputPath); ++i) {
                ((Object)((Object)TimeUnit.MILLISECONDS)).wait(100L);
            }
            Assert.assertTrue((String)"Missing job history file", (boolean)lfs.exists(inputPath));
            DefaultInputDemuxer inputDemuxer = new DefaultInputDemuxer();
            inputDemuxer.bindTo(inputPath, conf);
            Pair filePair = inputDemuxer.getNext();
            Assert.assertNotNull((Object)filePair);
            ris = new RewindableInputStream((InputStream)filePair.second());
            parser = JobHistoryParserFactory.getParser((RewindableInputStream)ris);
            String jobId = TraceBuilder.extractJobID((String)((String)filePair.first()));
            JobBuilder builder = new JobBuilder(jobId);
            while ((e = parser.nextEvent()) != null) {
                String eventString = e.getEventType().toString();
                System.out.println(eventString);
                seenEvents.add(eventString);
                if (builder == null) continue;
                builder.process(e);
            }
            ParsedJob parsedJob = builder.build();
            this.validateParsedJob(parsedJob, 1, 1, queueName);
        }
        finally {
            mrCluster.shutdown();
            if (ris != null) {
                ris.close();
            }
            if (parser != null) {
                parser.close();
            }
            lfs.delete(tempDir, true);
        }
        System.out.println("testCurrentJHParser validating using gold std ");
        String[] goldLines = new String[]{"JOB_SUBMITTED", "JOB_PRIORITY_CHANGED", "JOB_STATUS_CHANGED", "JOB_INITED", "JOB_INFO_CHANGED", "TASK_STARTED", "MAP_ATTEMPT_STARTED", "MAP_ATTEMPT_FINISHED", "MAP_ATTEMPT_FINISHED", "TASK_UPDATED", "TASK_FINISHED", "JOB_STATUS_CHANGED", "TASK_STARTED", "MAP_ATTEMPT_STARTED", "MAP_ATTEMPT_FINISHED", "MAP_ATTEMPT_FINISHED", "TASK_UPDATED", "TASK_FINISHED", "TASK_STARTED", "MAP_ATTEMPT_STARTED", "MAP_ATTEMPT_FINISHED", "REDUCE_ATTEMPT_FINISHED", "TASK_UPDATED", "TASK_FINISHED", "TASK_STARTED", "MAP_ATTEMPT_STARTED", "MAP_ATTEMPT_FINISHED", "MAP_ATTEMPT_FINISHED", "TASK_UPDATED", "TASK_FINISHED", "JOB_STATUS_CHANGED", "JOB_FINISHED"};
        Assert.assertEquals((String)"Size mismatch", (long)goldLines.length, (long)seenEvents.size());
        int index = 0;
        for (String goldLine : goldLines) {
            Assert.assertEquals((String)"Content mismatch", (Object)goldLine, seenEvents.get(index++));
        }
    }

    @Test
    public void testJobConfigurationParsing() throws Exception {
        LocalFileSystem lfs = FileSystem.getLocal((Configuration)new Configuration());
        Path rootTempDir = new Path(System.getProperty("test.build.data", "/tmp")).makeQualified(lfs.getUri(), lfs.getWorkingDirectory());
        Path tempDir = new Path(rootTempDir, "TestJobConfigurationParser");
        lfs.delete(tempDir, true);
        JobConf jConf = new JobConf(false);
        String key = "test.data";
        String value = "hello world";
        jConf.set(key, value);
        Path jobConfPath = new Path(tempDir.toString(), "job.xml");
        lfs.delete(jobConfPath, false);
        FSDataOutputStream jobConfStream = lfs.create(jobConfPath);
        jConf.writeXml((OutputStream)jobConfStream);
        jobConfStream.close();
        Properties properties = JobConfigurationParser.parse((InputStream)lfs.open(jobConfPath));
        Assert.assertEquals((String)("Total number of extracted properties (" + properties.size() + ") doesn't match the expected size of 1 [" + "JobConfigurationParser]"), (long)1L, (long)properties.size());
        Assert.assertTrue((String)("Key " + key + " is missing in the configuration extracted " + "[JobConfigurationParser]"), (boolean)properties.keySet().contains(key));
        Assert.assertEquals((String)"JobConfigurationParser couldn't recover the parameters correctly", (Object)value, (Object)properties.get(key));
        LoggedJob job = new LoggedJob();
        job.setJobProperties(properties);
        ZombieJob zjob = new ZombieJob(job, null);
        JobConf zconf = zjob.getJobConf();
        Assert.assertEquals((String)"ZombieJob couldn't recover the parameters correctly", (Object)value, (Object)zconf.get(key));
    }

    @Test
    public void testJobConfigurationParser() throws Exception {
        this.validateJobConfParser("sample-conf.file.xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateJobConfParser(String confFile) throws Exception {
        Configuration conf = new Configuration();
        LocalFileSystem lfs = FileSystem.getLocal((Configuration)conf);
        Path rootInputDir = new Path(System.getProperty("test.tools.input.dir", "")).makeQualified((FileSystem)lfs);
        Path rootInputPath = new Path(rootInputDir, "rumen/small-trace-test");
        Path inputPath = new Path(rootInputPath, confFile);
        PossiblyDecompressedInputStream inputConfStream = new PossiblyDecompressedInputStream(inputPath, conf);
        try {
            Properties props = JobConfigurationParser.parse((InputStream)inputConfStream);
            inputConfStream.close();
            Assert.assertEquals((String)"Config property for job queue name is not  extracted properly.", (Object)"TheQueue", (Object)JobBuilder.extract((Properties)props, (String[])JobConfPropertyNames.QUEUE_NAMES.getCandidates(), null));
            Assert.assertEquals((String)"Config property for job name is not  extracted properly.", (Object)"MyMRJob", (Object)JobBuilder.extract((Properties)props, (String[])JobConfPropertyNames.JOB_NAMES.getCandidates(), null));
            this.validateChildJavaOpts(props);
        }
        finally {
            inputConfStream.close();
        }
    }

    private void validateChildJavaOpts(Properties props) {
        Assert.assertEquals((String)"mapred.child.java.opts is not extracted properly.", (Object)"-server -Xmx640m -Djava.net.preferIPv4Stack=true", (Object)JobBuilder.extract((Properties)props, (String[])JobConfPropertyNames.TASK_JAVA_OPTS_S.getCandidates(), null));
        Assert.assertEquals((String)"New config property mapred.map.child.java.opts is not extracted properly when the old config property mapred.child.java.opts is set.", (Object)"-server -Xmx640m -Djava.net.preferIPv4Stack=true", (Object)JobBuilder.extract((Properties)props, (String[])JobConfPropertyNames.MAP_JAVA_OPTS_S.getCandidates(), null));
        Assert.assertEquals((String)"New config property mapred.reduce.child.java.opts is not extracted properly when the old config property mapred.child.java.opts is set.", (Object)"-server -Xmx640m -Djava.net.preferIPv4Stack=true", (Object)JobBuilder.extract((Properties)props, (String[])JobConfPropertyNames.REDUCE_JAVA_OPTS_S.getCandidates(), null));
    }

    @Test
    public void testResourceUsageMetrics() throws Exception {
        long cpuUsage = 100L;
        long pMemUsage = 200L;
        long vMemUsage = 300L;
        long heapUsage = 400L;
        ResourceUsageMetrics metrics = new ResourceUsageMetrics();
        metrics.setCumulativeCpuUsage(100L);
        metrics.setPhysicalMemoryUsage(200L);
        metrics.setVirtualMemoryUsage(300L);
        metrics.setHeapUsage(400L);
        Assert.assertEquals((String)"Cpu usage values mismatch via set", (long)100L, (long)metrics.getCumulativeCpuUsage());
        Assert.assertEquals((String)"Physical memory usage values mismatch via set", (long)200L, (long)metrics.getPhysicalMemoryUsage());
        Assert.assertEquals((String)"Virtual memory usage values mismatch via set", (long)300L, (long)metrics.getVirtualMemoryUsage());
        Assert.assertEquals((String)"Heap usage values mismatch via set", (long)400L, (long)metrics.getHeapUsage());
        TestRumenJobTraces.testResourceUsageMetricViaDeepCompare(metrics, 100L, 300L, 200L, 400L, true);
        TestRumenJobTraces.testResourceUsageMetricViaDeepCompare(metrics, 0L, 300L, 200L, 400L, false);
        TestRumenJobTraces.testResourceUsageMetricViaDeepCompare(metrics, 100L, 300L, 0L, 400L, false);
        TestRumenJobTraces.testResourceUsageMetricViaDeepCompare(metrics, 100L, 0L, 200L, 400L, false);
        TestRumenJobTraces.testResourceUsageMetricViaDeepCompare(metrics, 100L, 300L, 200L, 0L, false);
        ResourceUsageMetrics metrics2 = new ResourceUsageMetrics(){

            public int size() {
                return -1;
            }
        };
        metrics2.setCumulativeCpuUsage(100L);
        metrics2.setPhysicalMemoryUsage(200L);
        metrics2.setVirtualMemoryUsage(300L);
        metrics2.setHeapUsage(400L);
        TestRumenJobTraces.testResourceUsageMetricViaDeepCompare(metrics2, 100L, 300L, 200L, 400L, false);
    }

    private static void testResourceUsageMetricViaDeepCompare(ResourceUsageMetrics metrics, long cpuUsage, long vMemUsage, long pMemUsage, long heapUsage, boolean shouldPass) {
        ResourceUsageMetrics testMetrics = new ResourceUsageMetrics();
        testMetrics.setCumulativeCpuUsage(cpuUsage);
        testMetrics.setPhysicalMemoryUsage(pMemUsage);
        testMetrics.setVirtualMemoryUsage(vMemUsage);
        testMetrics.setHeapUsage(heapUsage);
        Boolean passed = null;
        try {
            metrics.deepCompare((DeepCompare)testMetrics, new TreePath(null, "<root>"));
            passed = true;
        }
        catch (DeepInequalityException die) {
            passed = false;
        }
        Assert.assertEquals((String)"ResourceUsageMetrics deepCompare() failed!", (Object)shouldPass, (Object)passed);
    }

    @Test
    public void testResourceUsageMetricsWithHadoopLogsAnalyzer() throws IOException {
        Configuration conf = new Configuration();
        Path rootInputDir = new Path(System.getProperty("test.tools.input.dir", ""));
        Path rootInputSubFolder = new Path(rootInputDir, "rumen/small-trace-test");
        Path traceFile = new Path(rootInputSubFolder, "v20-resource-usage-log.gz");
        LocalFileSystem lfs = FileSystem.getLocal((Configuration)conf);
        Path rootTempDir = new Path(System.getProperty("test.build.data", "/tmp"));
        Path outputDir = new Path(rootTempDir, "testResourceUsageMetricsWithHadoopLogsAnalyzer");
        lfs.delete(outputDir, true);
        lfs.deleteOnExit(outputDir);
        HadoopLogsAnalyzer analyzer = new HadoopLogsAnalyzer();
        analyzer.setConf(conf);
        Path traceOutput = new Path(outputDir, "trace.json");
        analyzer.run(new String[]{"-write-job-trace", traceOutput.toString(), "-v1", traceFile.toString()});
        JsonObjectMapperParser traceParser = new JsonObjectMapperParser(traceOutput, LoggedJob.class, conf);
        LoggedJob job = (LoggedJob)traceParser.getNext();
        LoggedTaskAttempt attempt = (LoggedTaskAttempt)((LoggedTask)job.getMapTasks().get(0)).getAttempts().get(0);
        ResourceUsageMetrics metrics = attempt.getResourceUsageMetrics();
        TestRumenJobTraces.testResourceUsageMetricViaDeepCompare(metrics, 200L, 100L, 75L, 50L, true);
    }

    @Test
    public void testTopologyBuilder() throws Exception {
        TopologyBuilder subject = new TopologyBuilder();
        subject.process(new Properties());
        subject.process((HistoryEvent)new TaskAttemptFinishedEvent(TaskAttemptID.forName((String)"attempt_200904211745_0003_m_000004_0"), TaskType.valueOf((String)"MAP"), "STATUS", 1234567890L, "/194\\.6\\.134\\.64/cluster50261\\.secondleveldomain\\.com", "SUCCESS", null));
        subject.process((HistoryEvent)new TaskAttemptUnsuccessfulCompletionEvent(TaskAttemptID.forName((String)"attempt_200904211745_0003_m_000004_1"), TaskType.valueOf((String)"MAP"), "STATUS", 1234567890L, "/194\\.6\\.134\\.80/cluster50262\\.secondleveldomain\\.com", "MACHINE_EXPLODED"));
        subject.process((HistoryEvent)new TaskAttemptUnsuccessfulCompletionEvent(TaskAttemptID.forName((String)"attempt_200904211745_0003_m_000004_2"), TaskType.valueOf((String)"MAP"), "STATUS", 1234567890L, "/194\\.6\\.134\\.80/cluster50263\\.secondleveldomain\\.com", "MACHINE_EXPLODED"));
        subject.process((HistoryEvent)new TaskStartedEvent(TaskID.forName((String)"task_200904211745_0003_m_000004"), 1234567890L, TaskType.valueOf((String)"MAP"), "/194\\.6\\.134\\.80/cluster50263\\.secondleveldomain\\.com"));
        LoggedNetworkTopology topology = subject.build();
        List racks = topology.getChildren();
        Assert.assertEquals((String)"Wrong number of racks", (long)2L, (long)racks.size());
        boolean sawSingleton = false;
        boolean sawDoubleton = false;
        for (LoggedNetworkTopology rack : racks) {
            List nodes = rack.getChildren();
            if (rack.getName().endsWith(".64")) {
                Assert.assertEquals((String)"The singleton rack has the wrong number of elements", (long)1L, (long)nodes.size());
                sawSingleton = true;
                continue;
            }
            if (rack.getName().endsWith(".80")) {
                Assert.assertEquals((String)"The doubleton rack has the wrong number of elements", (long)2L, (long)nodes.size());
                sawDoubleton = true;
                continue;
            }
            Assert.assertTrue((String)"Unrecognized rack name", (boolean)false);
        }
        Assert.assertTrue((String)"Did not see singleton rack", (boolean)sawSingleton);
        Assert.assertTrue((String)"Did not see doubleton rack", (boolean)sawDoubleton);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static <T extends DeepCompare> void jsonFileMatchesGold(Configuration conf, Path result, Path gold, Class<? extends T> clazz, String fileDescription) throws IOException {
        JsonObjectMapperParser resultParser;
        JsonObjectMapperParser goldParser;
        block7: {
            goldParser = new JsonObjectMapperParser(gold, clazz, conf);
            resultParser = new JsonObjectMapperParser(result, clazz, conf);
            block4: while (true) {
                while (true) {
                    DeepCompare goldJob = (DeepCompare)goldParser.getNext();
                    DeepCompare resultJob = (DeepCompare)resultParser.getNext();
                    if (goldJob == null || resultJob == null) {
                        Assert.assertTrue((goldJob == resultJob ? 1 : 0) != 0);
                        break block4;
                    }
                    try {
                        resultJob.deepCompare(goldJob, new TreePath(null, "<root>"));
                        continue block4;
                    }
                    catch (DeepInequalityException e) {
                        String error = e.path.toString();
                        Assert.assertFalse((String)(fileDescription + " mismatches: " + error), (boolean)true);
                        continue;
                    }
                    break;
                }
            }
            break block7;
            catch (Throwable throwable) {
                IOUtils.cleanup(null, (Closeable[])new Closeable[]{goldParser, resultParser});
                throw throwable;
            }
        }
        IOUtils.cleanup(null, (Closeable[])new Closeable[]{goldParser, resultParser});
    }
}

