/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;
import javax.security.auth.login.LoginException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.QueueManager;
import org.apache.hadoop.mapred.TestQueueManager;
import org.apache.hadoop.mapred.UtilsForTests;
import org.apache.hadoop.security.UserGroupInformation;

public class TestQueueManagerForJobKillAndJobPriority
extends TestQueueManager {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOwnerAllowedForJobKill() throws IOException, InterruptedException {
        try {
            final UserGroupInformation ugi = this.createNecessaryUsers();
            ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    JobConf conf = TestQueueManagerForJobKillAndJobPriority.this.setupConf(QueueManager.toFullPropertyName((String)"default", (String)TestQueueManagerForJobKillAndJobPriority.this.adminAcl), "junk-user");
                    TestQueueManagerForJobKillAndJobPriority.this.verifyJobKill(ugi, conf, true);
                    return null;
                }
            });
        }
        finally {
            this.tearDownCluster();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUserDisabledACLForJobKill() throws IOException, InterruptedException {
        try {
            UserGroupInformation ugi = this.createNecessaryUsers();
            final UserGroupInformation otherUGI = UserGroupInformation.createUserForTesting((String)"user1", (String[])new String[]{"group1"});
            ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    JobConf conf = TestQueueManagerForJobKillAndJobPriority.this.setupConf(QueueManager.toFullPropertyName((String)"default", (String)TestQueueManagerForJobKillAndJobPriority.this.adminAcl), "dummy-user");
                    TestQueueManagerForJobKillAndJobPriority.this.verifyJobKill(otherUGI, conf, false);
                    return null;
                }
            });
        }
        finally {
            this.tearDownCluster();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUserEnabledACLForJobKill() throws IOException, LoginException, InterruptedException {
        try {
            UserGroupInformation ugi = this.createNecessaryUsers();
            final UserGroupInformation otherUGI = UserGroupInformation.createUserForTesting((String)"user1", (String[])new String[]{"group1"});
            ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
                    JobConf conf = TestQueueManagerForJobKillAndJobPriority.this.setupConf(QueueManager.toFullPropertyName((String)"default", (String)TestQueueManagerForJobKillAndJobPriority.this.adminAcl), "user1");
                    TestQueueManagerForJobKillAndJobPriority.this.verifyJobKill(otherUGI, conf, true);
                    return null;
                }
            });
        }
        finally {
            this.tearDownCluster();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUserDisabledForJobPriorityChange() throws IOException, InterruptedException {
        try {
            UserGroupInformation ugi = this.createNecessaryUsers();
            final UserGroupInformation otherUGI = UserGroupInformation.createUserForTesting((String)"user1", (String[])new String[]{"group1"});
            ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    JobConf conf = TestQueueManagerForJobKillAndJobPriority.this.setupConf(QueueManager.toFullPropertyName((String)"default", (String)TestQueueManagerForJobKillAndJobPriority.this.adminAcl), "junk-user");
                    TestQueueManagerForJobKillAndJobPriority.this.verifyJobPriorityChangeAsOtherUser(otherUGI, conf, false);
                    return null;
                }
            });
        }
        finally {
            this.tearDownCluster();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testACLRefresh() throws Exception {
        try {
            String queueConfigPath = System.getProperty("test.build.extraconf", "build/test/extraconf");
            File queueConfigFile = new File(queueConfigPath, "mapred-queue-acls.xml");
            File hadoopConfigFile = new File(queueConfigPath, "mapred-site.xml");
            try {
                Properties hadoopConfProps = new Properties();
                hadoopConfProps.put("mapred.queue.names", "default,q1,q2");
                hadoopConfProps.put("mapred.acls.enabled", "true");
                hadoopConfProps.put(QueueManager.toFullPropertyName((String)"default", (String)this.submitAcl), "u1");
                hadoopConfProps.put(QueueManager.toFullPropertyName((String)"q1", (String)this.submitAcl), "u2");
                hadoopConfProps.put(QueueManager.toFullPropertyName((String)"q2", (String)this.submitAcl), "u1");
                UtilsForTests.setUpConfigFile(hadoopConfProps, hadoopConfigFile);
                Properties queueConfProps = new Properties();
                queueConfProps.put(QueueManager.toFullPropertyName((String)"default", (String)this.submitAcl), " ");
                UtilsForTests.setUpConfigFile(queueConfProps, queueConfigFile);
                JobConf conf = new JobConf();
                QueueManager queueManager = new QueueManager((Configuration)conf);
                UserGroupInformation ugi = UserGroupInformation.createUserForTesting((String)"user1", (String[])new String[]{"group1"});
                TestQueueManagerForJobKillAndJobPriority.assertFalse((String)"User Job Submission Succeeded before refresh.", (boolean)queueManager.hasAccess("default", QueueManager.QueueACL.SUBMIT_JOB, ugi));
                TestQueueManagerForJobKillAndJobPriority.assertFalse((String)"User Job Submission Succeeded before refresh.", (boolean)queueManager.hasAccess("q1", QueueManager.QueueACL.SUBMIT_JOB, ugi));
                TestQueueManagerForJobKillAndJobPriority.assertFalse((String)"User Job Submission Succeeded before refresh.", (boolean)queueManager.hasAccess("q2", QueueManager.QueueACL.SUBMIT_JOB, ugi));
                UserGroupInformation alternateUgi = UserGroupInformation.createUserForTesting((String)"u1", (String[])new String[]{"user"});
                TestQueueManagerForJobKillAndJobPriority.assertTrue((String)"Alternate User Job Submission failed before refresh.", (boolean)queueManager.hasAccess("q2", QueueManager.QueueACL.SUBMIT_JOB, alternateUgi));
                queueConfProps.put(QueueManager.toFullPropertyName((String)"default", (String)this.submitAcl), ugi.getShortUserName());
                queueConfProps.put(QueueManager.toFullPropertyName((String)"q1", (String)this.submitAcl), ugi.getShortUserName());
                queueConfProps.put(QueueManager.toFullPropertyName((String)"q2", (String)this.submitAcl), ugi.getShortUserName());
                UtilsForTests.setUpConfigFile(queueConfProps, queueConfigFile);
                queueManager.refreshQueues((Configuration)conf);
                TestQueueManagerForJobKillAndJobPriority.assertTrue((String)"User Job Submission failed after refresh.", (boolean)queueManager.hasAccess("default", QueueManager.QueueACL.SUBMIT_JOB, ugi));
                TestQueueManagerForJobKillAndJobPriority.assertTrue((String)"User Job Submission failed after refresh.", (boolean)queueManager.hasAccess("q1", QueueManager.QueueACL.SUBMIT_JOB, ugi));
                TestQueueManagerForJobKillAndJobPriority.assertTrue((String)"User Job Submission failed after refresh.", (boolean)queueManager.hasAccess("q2", QueueManager.QueueACL.SUBMIT_JOB, ugi));
                TestQueueManagerForJobKillAndJobPriority.assertFalse((String)"Alternate User Job Submission succeeded after refresh.", (boolean)queueManager.hasAccess("q2", QueueManager.QueueACL.SUBMIT_JOB, alternateUgi));
                queueConfigFile.delete();
                hadoopConfProps.put("mapred.acls.enabled", "true");
                hadoopConfProps.put(QueueManager.toFullPropertyName((String)"q1", (String)this.submitAcl), ugi.getShortUserName());
                UtilsForTests.setUpConfigFile(hadoopConfProps, hadoopConfigFile);
                queueManager.refreshQueues((Configuration)conf);
                TestQueueManagerForJobKillAndJobPriority.assertTrue((String)"User Job Submission allowed after refresh and no queue acls file.", (boolean)queueManager.hasAccess("q1", QueueManager.QueueACL.SUBMIT_JOB, ugi));
            }
            finally {
                if (queueConfigFile.exists()) {
                    queueConfigFile.delete();
                }
                if (hadoopConfigFile.exists()) {
                    hadoopConfigFile.delete();
                }
            }
        }
        finally {
            this.tearDownCluster();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testQueueAclRefreshWithInvalidConfFile() throws IOException {
        try {
            String queueConfigPath = System.getProperty("test.build.extraconf", "build/test/extraconf");
            File queueConfigFile = new File(queueConfigPath, "mapred-queue-acls.xml");
            File hadoopConfigFile = new File(queueConfigPath, "hadoop-site.xml");
            try {
                Properties hadoopConfProps = new Properties();
                hadoopConfProps.put("mapred.queue.names", "default,q1,q2");
                hadoopConfProps.put("mapred.acls.enabled", "true");
                UtilsForTests.setUpConfigFile(hadoopConfProps, hadoopConfigFile);
                Properties queueConfProps = new Properties();
                UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
                queueConfProps.put(QueueManager.toFullPropertyName((String)"default", (String)this.submitAcl), ugi.getShortUserName());
                queueConfProps.put(QueueManager.toFullPropertyName((String)"q1", (String)this.submitAcl), ugi.getShortUserName());
                queueConfProps.put(QueueManager.toFullPropertyName((String)"q2", (String)this.submitAcl), ugi.getShortUserName());
                UtilsForTests.setUpConfigFile(queueConfProps, queueConfigFile);
                JobConf conf = new JobConf();
                QueueManager queueManager = new QueueManager((Configuration)conf);
                TestQueueManagerForJobKillAndJobPriority.assertTrue((String)"User Job Submission failed.", (boolean)queueManager.hasAccess("default", QueueManager.QueueACL.SUBMIT_JOB, ugi));
                TestQueueManagerForJobKillAndJobPriority.assertTrue((String)"User Job Submission failed.", (boolean)queueManager.hasAccess("q1", QueueManager.QueueACL.SUBMIT_JOB, ugi));
                TestQueueManagerForJobKillAndJobPriority.assertTrue((String)"User Job Submission failed.", (boolean)queueManager.hasAccess("q2", QueueManager.QueueACL.SUBMIT_JOB, ugi));
                PrintWriter writer = new PrintWriter(new FileOutputStream(queueConfigFile));
                writer.println("<configuration>");
                writer.println("<property>");
                writer.flush();
                writer.close();
                try {
                    queueManager.refreshQueues((Configuration)conf);
                    TestQueueManagerForJobKillAndJobPriority.fail((String)"Refresh of ACLs should have failed with invalid conf file.");
                }
                catch (Exception e) {
                    // empty catch block
                }
                TestQueueManagerForJobKillAndJobPriority.assertTrue((String)"User Job Submission failed after invalid conf file refresh.", (boolean)queueManager.hasAccess("default", QueueManager.QueueACL.SUBMIT_JOB, ugi));
                TestQueueManagerForJobKillAndJobPriority.assertTrue((String)"User Job Submission failed after invalid conf file refresh.", (boolean)queueManager.hasAccess("q1", QueueManager.QueueACL.SUBMIT_JOB, ugi));
                TestQueueManagerForJobKillAndJobPriority.assertTrue((String)"User Job Submission failed after invalid conf file refresh.", (boolean)queueManager.hasAccess("q2", QueueManager.QueueACL.SUBMIT_JOB, ugi));
            }
            finally {
                if (hadoopConfigFile.exists()) {
                    hadoopConfigFile.delete();
                }
                if (queueConfigFile.exists()) {
                    queueConfigFile.delete();
                }
            }
        }
        finally {
            this.tearDownCluster();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGroupsEnabledACLForJobSubmission() throws IOException, LoginException, InterruptedException {
        try {
            UserGroupInformation ugi = this.createNecessaryUsers();
            String[] groups = ugi.getGroupNames();
            JobConf conf = this.setupConf(QueueManager.toFullPropertyName((String)"default", (String)this.submitAcl), "3698-junk-user1,3698-junk-user2 " + groups[groups.length - 1] + ",3698-junk-group");
            this.verifyJobSubmissionToDefaultQueue(conf, true, ugi.getShortUserName() + "," + groups[groups.length - 1]);
        }
        finally {
            this.tearDownCluster();
        }
    }
}

