/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapred.TestMiniMRDFSSort;
import org.apache.hadoop.mapred.UtilsForTests;

public class TestMapredHeartbeat
extends TestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testJobDirCleanup() throws IOException {
        MiniMRCluster mr = null;
        try {
            int taskTrackers = 2;
            JobConf conf = new JobConf();
            mr = new MiniMRCluster(taskTrackers, "file:///", 3, null, null, conf);
            JobClient jc = new JobClient(mr.createJobConf());
            while (jc.getClusterStatus().getTaskTrackers() != taskTrackers) {
                UtilsForTests.waitFor(100L);
            }
            TestMapredHeartbeat.assertEquals((int)300, (int)mr.getJobTrackerRunner().getJobTracker().getNextHeartbeatInterval());
            mr.shutdown();
            taskTrackers = 5;
            conf.setInt("mapred.heartbeats.in.second", 1);
            mr = new MiniMRCluster(taskTrackers, "file:///", 3, null, null, conf);
            jc = new JobClient(mr.createJobConf());
            while (jc.getClusterStatus().getTaskTrackers() != taskTrackers) {
                UtilsForTests.waitFor(100L);
            }
            TestMapredHeartbeat.assertEquals((int)(taskTrackers * 1000), (int)mr.getJobTrackerRunner().getJobTracker().getNextHeartbeatInterval());
            mr.shutdown();
            taskTrackers = 5;
            conf.setInt("mapred.heartbeats.in.second", 10);
            mr = new MiniMRCluster(taskTrackers, "file:///", 3, null, null, conf);
            jc = new JobClient(mr.createJobConf());
            while (jc.getClusterStatus().getTaskTrackers() != taskTrackers) {
                UtilsForTests.waitFor(100L);
            }
            TestMapredHeartbeat.assertEquals((int)300, (int)mr.getJobTrackerRunner().getJobTracker().getNextHeartbeatInterval());
        }
        finally {
            if (mr != null) {
                mr.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOutOfBandHeartbeats() throws Exception {
        MiniDFSCluster dfs = null;
        MiniMRCluster mr = null;
        try {
            Configuration conf = new Configuration();
            dfs = new MiniDFSCluster(conf, 4, true, null);
            int taskTrackers = 1;
            JobConf jobConf = new JobConf();
            jobConf.setFloat("mapreduce.jobtracker.heartbeats.scaling.factor", 30.0f);
            jobConf.setBoolean("mapreduce.tasktracker.outofband.heartbeat", true);
            mr = new MiniMRCluster(taskTrackers, dfs.getFileSystem().getUri().toString(), 3, null, null, jobConf);
            long start = System.currentTimeMillis();
            TestMiniMRDFSSort.runRandomWriter(mr.createJobConf(), new Path("rw"));
            long end = System.currentTimeMillis();
            int expectedRuntimeSecs = 120;
            int runTimeSecs = (int)((end - start) / 1000L);
            System.err.println("Runtime is " + runTimeSecs);
            TestMapredHeartbeat.assertEquals((String)("Actual runtime " + runTimeSecs + "s not less than expected " + "runtime of " + 120 + "s!"), (boolean)true, (runTimeSecs <= 120 ? 1 : 0) != 0);
        }
        finally {
            if (mr != null) {
                mr.shutdown();
            }
            if (dfs != null) {
                dfs.shutdown();
            }
        }
    }
}

