/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import junit.framework.TestCase;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobHistoryServer;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapred.lib.IdentityMapper;
import org.apache.hadoop.mapred.lib.IdentityReducer;
import org.apache.hadoop.mapred.lib.NullOutputFormat;
import org.junit.Assert;

public class TestJobHistoryServer
extends TestCase {
    private static final Log LOG = LogFactory.getLog(TestJobHistoryServer.class);
    private String inputPath = System.getProperty("test.build.data", "build/test/data") + "/TestJobHistoryServer";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testHistoryServerEmbedded() {
        MiniMRCluster mrCluster = null;
        JobConf conf = new JobConf();
        try {
            conf.setLong("mapred.job.tracker.retiredjobs.cache.size", 1L);
            conf.setLong("mapred.jobtracker.retirejob.interval", 0L);
            conf.setLong("mapred.jobtracker.retirejob.check", 0L);
            conf.setLong("mapred.jobtracker.completeuserjobs.maximum", 2L);
            conf.set("mapreduce.history.server.http.address", "localhost:0");
            mrCluster = new MiniMRCluster(1, conf.get("fs.default.name"), 1, null, null, conf);
            String historyAddress = JobHistoryServer.getHistoryUrlPrefix((JobConf)mrCluster.getJobTrackerRunner().getJobTracker().conf);
            LOG.info((Object)("******** History Address: " + historyAddress));
            conf = mrCluster.createJobConf();
            this.createInputFile((Configuration)conf, this.inputPath);
            RunningJob job = this.runJob(conf);
            LOG.info((Object)("Job details: " + job));
            String redirectUrl = this.getRedirectUrl(job.getTrackingURL());
            Assert.assertEquals((Object)redirectUrl.contains(historyAddress), (Object)true);
        }
        catch (IOException e) {
            LOG.error((Object)"Failure running test", (Throwable)e);
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (mrCluster != null) {
                mrCluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testHistoryServerStandalone() {
        MiniMRCluster mrCluster = null;
        JobConf conf = new JobConf();
        JobHistoryServer server = null;
        try {
            conf.setLong("mapred.job.tracker.retiredjobs.cache.size", 1L);
            conf.setLong("mapred.jobtracker.retirejob.interval", 0L);
            conf.setLong("mapred.jobtracker.retirejob.check", 0L);
            conf.setLong("mapred.jobtracker.completeuserjobs.maximum", 2L);
            conf.set("mapreduce.history.server.http.address", "localhost:8090");
            conf.setBoolean("mapreduce.history.server.embedded", false);
            mrCluster = new MiniMRCluster(1, conf.get("fs.default.name"), 1, null, null, conf);
            server = new JobHistoryServer(conf);
            server.start();
            String historyAddress = JobHistoryServer.getHistoryUrlPrefix((JobConf)conf);
            LOG.info((Object)("******** History Address: " + historyAddress));
            conf = mrCluster.createJobConf();
            this.createInputFile((Configuration)conf, this.inputPath);
            RunningJob job = this.runJob(conf);
            LOG.info((Object)("Job details: " + job));
            String redirectUrl = this.getRedirectUrl(job.getTrackingURL());
            Assert.assertEquals((Object)redirectUrl.contains(historyAddress), (Object)true);
        }
        catch (IOException e) {
            LOG.error((Object)"Failure running test", (Throwable)e);
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (mrCluster != null) {
                mrCluster.shutdown();
            }
            try {
                if (server != null) {
                    server.shutdown();
                }
            }
            catch (Exception ignore) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createInputFile(Configuration conf, String path) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)conf);
        FSDataOutputStream out = fs.create(new Path(path));
        try {
            out.write("hello world".getBytes());
        }
        finally {
            out.close();
        }
    }

    private synchronized RunningJob runJob(JobConf conf) throws IOException {
        conf.setJobName("History");
        conf.setInputFormat(TextInputFormat.class);
        conf.setMapOutputKeyClass(LongWritable.class);
        conf.setMapOutputValueClass(Text.class);
        conf.setOutputFormat(NullOutputFormat.class);
        conf.setOutputKeyClass(LongWritable.class);
        conf.setOutputValueClass(Text.class);
        conf.setMapperClass(IdentityMapper.class);
        conf.setReducerClass(IdentityReducer.class);
        FileInputFormat.setInputPaths((JobConf)conf, (String)this.inputPath);
        return JobClient.runJob((JobConf)conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getRedirectUrl(String jobUrl) throws IOException {
        HttpClient client = new HttpClient();
        GetMethod method = new GetMethod(jobUrl);
        method.setFollowRedirects(false);
        try {
            int status = client.executeMethod((HttpMethod)method);
            Assert.assertEquals((long)status, (long)302L);
            LOG.info((Object)("Location: " + method.getResponseHeader("Location")));
            String string = method.getResponseHeader("Location").getValue();
            return string;
        }
        finally {
            method.releaseConnection();
        }
    }
}

