/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.examples.SleepJob;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JobPriority;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapred.QueueManager;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestJobACLs {
    static final Log LOG = LogFactory.getLog(TestJobACLs.class);
    private MiniMRCluster mr = null;
    private static final Path TEST_DIR = new Path(System.getProperty("test.build.data", "/tmp"), TestJobACLs.class.getCanonicalName() + "/" + "completed-job-store");
    private String jobSubmitter = "jobSubmitter";
    private String viewColleague = "viewColleague";
    private String modifyColleague = "modifyColleague";
    private String qAdmin = "qAdmin";

    @Before
    public void setup() throws IOException {
        this.startCluster(false);
    }

    private void startCluster(boolean reStart) throws IOException {
        UserGroupInformation MR_UGI = UserGroupInformation.getLoginUser();
        JobConf conf = new JobConf();
        conf.setBoolean("mapred.acls.enabled", true);
        conf.set(QueueManager.toFullPropertyName((String)"default", (String)QueueManager.QueueACL.ADMINISTER_JOBS.getAclName()), this.qAdmin);
        conf.set(QueueManager.toFullPropertyName((String)"default", (String)QueueManager.QueueACL.SUBMIT_JOB.getAclName()), this.jobSubmitter);
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        if (!reStart) {
            fs.delete(TEST_DIR, true);
        }
        conf.set("mapred.job.tracker.persist.jobstatus.dir", fs.makeQualified(TEST_DIR).toString());
        conf.setBoolean("mapred.job.tracker.persist.jobstatus.active", true);
        conf.set("mapred.job.tracker.persist.jobstatus.hours", "1");
        conf.set("mapred.tasktracker.map.tasks.maximum", "4");
        this.mr = new MiniMRCluster(0, 0, 2, "file:///", 1, null, null, MR_UGI, conf);
    }

    @After
    public void tearDown() {
        if (this.mr != null) {
            this.mr.shutdown();
        }
    }

    @Test
    public void testACLS() throws IOException, InterruptedException, ClassNotFoundException {
        this.verifyACLViewJob();
        this.verifyACLModifyJob(this.modifyColleague);
        this.verifyACLModifyJob(this.qAdmin);
        this.verifyACLPersistence();
    }

    private void verifyACLViewJob() throws IOException, InterruptedException {
        JobConf myConf = this.mr.createJobConf();
        myConf.set("mapreduce.job.acl-view-job", this.viewColleague);
        RunningJob job = this.submitJobAsUser(myConf, this.jobSubmitter);
        JobID jobId = job.getID();
        this.verifyViewJobAsUnauthorizedUser(myConf, jobId, this.modifyColleague);
        this.verifyViewJobAsAuthorizedUser(myConf, jobId, this.viewColleague);
        this.verifyViewJobAsAuthorizedUser(myConf, jobId, this.qAdmin);
        job.killJob();
    }

    private RunningJob submitJobAsUser(final JobConf clusterConf, String user) throws IOException, InterruptedException {
        UserGroupInformation ugi = UserGroupInformation.createUserForTesting((String)user, (String[])new String[0]);
        RunningJob job = (RunningJob)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                JobClient jobClient = new JobClient(clusterConf);
                SleepJob sleepJob = new SleepJob();
                sleepJob.setConf((Configuration)clusterConf);
                JobConf jobConf = sleepJob.setupJobConf(1, 0, 2000L, 1000, 1000L, 1000);
                RunningJob runningJob = jobClient.submitJob(jobConf);
                return runningJob;
            }
        });
        return job;
    }

    private void verifyViewJobAsAuthorizedUser(final JobConf myConf, final JobID jobId, String authorizedUser) throws IOException, InterruptedException {
        UserGroupInformation authorizedUGI = UserGroupInformation.createUserForTesting((String)authorizedUser, (String[])new String[0]);
        authorizedUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                RunningJob myJob = null;
                JobClient client = null;
                try {
                    client = new JobClient(myConf);
                    myJob = client.getJob(jobId);
                }
                catch (Exception e) {
                    Assert.fail((String)("Exception .." + e));
                }
                Assert.assertNotNull((String)("Job " + jobId + " is not known to the JobTracker!"), (Object)myJob);
                try {
                    myJob.getCounters();
                }
                catch (IOException ioe) {
                    Assert.fail((String)("Unexpected.. exception.. " + ioe));
                }
                try {
                    client.getCleanupTaskReports(jobId);
                }
                catch (IOException ioe) {
                    Assert.fail((String)("Unexpected.. exception.. " + ioe));
                }
                return null;
            }
        });
    }

    private void verifyViewJobAsUnauthorizedUser(final JobConf myConf, final JobID jobId, String unauthorizedUser) throws IOException, InterruptedException {
        UserGroupInformation unauthorizedUGI = UserGroupInformation.createUserForTesting((String)unauthorizedUser, (String[])new String[0]);
        unauthorizedUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() {
                RunningJob myJob = null;
                JobClient client = null;
                try {
                    client = new JobClient(myConf);
                    myJob = client.getJob(jobId);
                }
                catch (Exception e) {
                    Assert.fail((String)("Exception .." + e));
                }
                Assert.assertNotNull((String)("Job " + jobId + " is not known to the JobTracker!"), (Object)myJob);
                try {
                    myJob.getCounters();
                    Assert.fail((String)"AccessControlException expected..");
                }
                catch (IOException ioe) {
                    Assert.assertTrue((boolean)ioe.getMessage().contains("AccessControlException"));
                }
                try {
                    client.getSetupTaskReports(jobId);
                    Assert.fail((String)"AccessControlException expected..");
                }
                catch (IOException ioe) {
                    Assert.assertTrue((boolean)ioe.getMessage().contains("AccessControlException"));
                }
                return null;
            }
        });
    }

    private void verifyACLModifyJob(String authorizedUser) throws IOException, InterruptedException, ClassNotFoundException {
        JobConf myConf = this.mr.createJobConf();
        myConf.set("mapreduce.job.acl-modify-job", this.modifyColleague);
        RunningJob job = this.submitJobAsUser(myConf, this.jobSubmitter);
        JobID jobId = job.getID();
        this.verifyModifyJobAsUnauthorizedUser(myConf, jobId, this.viewColleague);
        this.verifyModifyJobAsAuthorizedUser(myConf, jobId, authorizedUser);
    }

    private void verifyModifyJobAsAuthorizedUser(final JobConf clusterConf, final JobID jobId, String authorizedUser) throws IOException, InterruptedException {
        UserGroupInformation authorizedUGI = UserGroupInformation.createUserForTesting((String)authorizedUser, (String[])new String[0]);
        authorizedUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                RunningJob myJob = null;
                try {
                    JobClient client = new JobClient(clusterConf);
                    myJob = client.getJob(jobId);
                }
                catch (Exception e) {
                    Assert.fail((String)("Exception .." + e));
                }
                Assert.assertNotNull((String)("Job " + jobId + " is not known to the JobTracker!"), (Object)myJob);
                try {
                    myJob.setJobPriority(JobPriority.HIGH.toString());
                }
                catch (IOException ioe) {
                    Assert.fail((String)("Unexpected.. exception.. " + ioe));
                }
                try {
                    myJob.killJob();
                }
                catch (IOException ioe) {
                    Assert.fail((String)("Unexpected.. exception.. " + ioe));
                }
                return null;
            }
        });
    }

    private void verifyModifyJobAsUnauthorizedUser(final JobConf clusterConf, final JobID jobId, String unauthorizedUser) throws IOException, InterruptedException {
        UserGroupInformation unauthorizedUGI = UserGroupInformation.createUserForTesting((String)unauthorizedUser, (String[])new String[0]);
        unauthorizedUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() {
                RunningJob myJob = null;
                try {
                    JobClient client = new JobClient(clusterConf);
                    myJob = client.getJob(jobId);
                }
                catch (Exception e) {
                    Assert.fail((String)("Exception .." + e));
                }
                Assert.assertNotNull((String)("Job " + jobId + " is not known to the JobTracker!"), (Object)myJob);
                try {
                    myJob.killJob();
                    Assert.fail((String)"AccessControlException expected..");
                }
                catch (IOException ioe) {
                    Assert.assertTrue((boolean)ioe.getMessage().contains("AccessControlException"));
                }
                try {
                    myJob.setJobPriority(JobPriority.HIGH.toString());
                    Assert.fail((String)"AccessControlException expected..");
                }
                catch (IOException ioe) {
                    Assert.assertTrue((boolean)ioe.getMessage().contains("AccessControlException"));
                }
                return null;
            }
        });
    }

    private void verifyACLPersistence() throws IOException, InterruptedException {
        JobConf myConf = this.mr.createJobConf();
        myConf.set("mapreduce.job.acl-view-job", this.viewColleague + " group2");
        RunningJob job = this.submitJobAsUser(myConf, this.jobSubmitter);
        final JobID jobId = job.getID();
        job.killJob();
        while (job.getJobState() != 5) {
            LOG.info((Object)"Waiting for the job to be killed successfully..");
            Thread.sleep(200L);
        }
        this.tearDown();
        this.startCluster(true);
        final JobConf myNewJobConf = this.mr.createJobConf();
        this.verifyViewJobAsAuthorizedUser(myNewJobConf, jobId, this.viewColleague);
        this.verifyViewJobAsAuthorizedUser(myNewJobConf, jobId, this.qAdmin);
        UserGroupInformation unauthorizedUGI = UserGroupInformation.createUserForTesting((String)this.modifyColleague, (String[])new String[0]);
        unauthorizedUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() {
                RunningJob myJob = null;
                try {
                    JobClient client = new JobClient(myNewJobConf);
                    myJob = client.getJob(jobId);
                }
                catch (Exception e) {
                    Assert.fail((String)("Exception .." + e));
                }
                Assert.assertNotNull((String)("Job " + jobId + " is not known to the JobTracker!"), (Object)myJob);
                try {
                    myJob.getCounters();
                    Assert.fail((String)"AccessControlException expected..");
                }
                catch (IOException ioe) {
                    Assert.assertTrue((boolean)ioe.getMessage().contains("AccessControlException"));
                }
                return null;
            }
        });
    }
}

