/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.file.tfile;

import java.io.IOException;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.file.tfile.Compression;
import org.apache.hadoop.io.file.tfile.TFile;

public class TestTFileComparators
extends TestCase {
    private static String ROOT = System.getProperty("test.build.data", "/tmp/tfile-test");
    private static final int BLOCK_SIZE = 512;
    private FileSystem fs;
    private Configuration conf;
    private Path path;
    private FSDataOutputStream out;
    private TFile.Writer writer;
    private String compression = Compression.Algorithm.GZ.getName();
    private String outputFile = "TFileTestComparators";
    private int records1stBlock = 4480;
    private int records2ndBlock = 4263;

    public void setUp() throws IOException {
        this.conf = new Configuration();
        this.path = new Path(ROOT, this.outputFile);
        this.fs = this.path.getFileSystem(this.conf);
        this.out = this.fs.create(this.path);
    }

    public void tearDown() throws IOException {
        this.fs.delete(this.path, true);
    }

    public void testFailureBadComparatorNames() throws IOException {
        try {
            this.writer = new TFile.Writer(this.out, 512, this.compression, "badcmp", this.conf);
            Assert.fail((String)"Failed to catch unsupported comparator names");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void testFailureBadJClassNames() throws IOException {
        try {
            this.writer = new TFile.Writer(this.out, 512, this.compression, "jclass: some.non.existence.clazz", this.conf);
            Assert.fail((String)"Failed to catch unsupported comparator names");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void testFailureBadJClasses() throws IOException {
        try {
            this.writer = new TFile.Writer(this.out, 512, this.compression, "jclass:org.apache.hadoop.io.file.tfile.Chunk", this.conf);
            Assert.fail((String)"Failed to catch unsupported comparator names");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void closeOutput() throws IOException {
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
        if (this.out != null) {
            this.out.close();
            this.out = null;
        }
    }
}

