/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.http;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.FilterContainer;
import org.apache.hadoop.http.FilterInitializer;
import org.apache.hadoop.http.HttpServer;
import org.apache.hadoop.http.resource.JerseyResource;
import org.apache.hadoop.security.Groups;
import org.apache.hadoop.security.ShellBasedUnixGroupsMapping;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mortbay.util.ajax.JSON;

public class TestHttpServer {
    static final Log LOG = LogFactory.getLog(TestHttpServer.class);
    private HttpServer server;
    private URL baseUrl;

    private String readOutput(URL url) throws IOException {
        StringBuilder out = new StringBuilder();
        InputStream in = url.openConnection().getInputStream();
        byte[] buffer = new byte[65536];
        int len = in.read(buffer);
        while (len > 0) {
            out.append(new String(buffer, 0, len));
            len = in.read(buffer);
        }
        return out.toString();
    }

    @Before
    public void setup() throws Exception {
        new File(System.getProperty("build.webapps", "build/webapps") + "/test").mkdirs();
        this.server = new HttpServer("test", "0.0.0.0", 0, true);
        this.server.addServlet("echo", "/echo", EchoServlet.class);
        this.server.addServlet("echomap", "/echomap", EchoMapServlet.class);
        this.server.addJerseyResourcePackage(JerseyResource.class.getPackage().getName(), "/jersey/*");
        this.server.start();
        int port = this.server.getPort();
        this.baseUrl = new URL("http://localhost:" + port + "/");
    }

    @After
    public void cleanup() throws Exception {
        this.server.stop();
    }

    @Test
    public void testEcho() throws Exception {
        Assert.assertEquals((Object)"a:b\nc:d\n", (Object)this.readOutput(new URL(this.baseUrl, "/echo?a=b&c=d")));
        Assert.assertEquals((Object)"a:b\nc&lt;:d\ne:&gt;\n", (Object)this.readOutput(new URL(this.baseUrl, "/echo?a=b&c<=d&e=>")));
    }

    @Test
    public void testEchoMap() throws Exception {
        Assert.assertEquals((Object)"a:b\nc:d\n", (Object)this.readOutput(new URL(this.baseUrl, "/echomap?a=b&c=d")));
        Assert.assertEquals((Object)"a:b,&gt;\nc&lt;:d\n", (Object)this.readOutput(new URL(this.baseUrl, "/echomap?a=b&c<=d&a=>")));
    }

    static int getHttpStatusCode(String urlstring, String userName) throws IOException {
        URL url = new URL(urlstring + "?user.name=" + userName);
        System.out.println("Accessing " + url + " as user " + userName);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.connect();
        return connection.getResponseCode();
    }

    @Test
    public void testDisabledAuthorizationOfDefaultServlets() throws Exception {
        Configuration conf = new Configuration();
        conf.set("hadoop.http.filter.initializers", DummyFilterInitializer.class.getName());
        conf.set("hadoop.security.group.mapping", MyGroupsProvider.class.getName());
        Groups.getUserToGroupsMappingService((Configuration)conf);
        MyGroupsProvider.clearMapping();
        MyGroupsProvider.mapping.put("userA", Arrays.asList("groupA"));
        MyGroupsProvider.mapping.put("userB", Arrays.asList("groupB"));
        HttpServer myServer = new HttpServer("test", "0.0.0.0", 0, true, conf);
        myServer.setAttribute("hadoop.conf", (Object)conf);
        myServer.start();
        int port = myServer.getPort();
        String serverURL = "http://localhost:" + port + "/";
        for (String servlet : new String[]{"logs", "stacks", "logLevel"}) {
            for (String user : new String[]{"userA", "userB"}) {
                Assert.assertEquals((long)200L, (long)TestHttpServer.getHttpStatusCode(serverURL + servlet, user));
            }
        }
        myServer.stop();
    }

    @Test
    public void testAuthorizationOfDefaultServlets() throws Exception {
        Configuration conf = new Configuration();
        conf.setBoolean("hadoop.security.authorization", true);
        conf.set("hadoop.http.filter.initializers", DummyFilterInitializer.class.getName());
        conf.set("hadoop.security.group.mapping", MyGroupsProvider.class.getName());
        Groups.getUserToGroupsMappingService((Configuration)conf);
        MyGroupsProvider.clearMapping();
        MyGroupsProvider.mapping.put("userA", Arrays.asList("groupA"));
        MyGroupsProvider.mapping.put("userB", Arrays.asList("groupB"));
        MyGroupsProvider.mapping.put("userC", Arrays.asList("groupC"));
        MyGroupsProvider.mapping.put("userD", Arrays.asList("groupD"));
        MyGroupsProvider.mapping.put("userE", Arrays.asList("groupE"));
        HttpServer myServer = new HttpServer("test", "0.0.0.0", 0, true, conf, new AccessControlList("userA,userB groupC,groupD"));
        myServer.setAttribute("hadoop.conf", (Object)conf);
        myServer.start();
        int port = myServer.getPort();
        String serverURL = "http://localhost:" + port + "/";
        for (String servlet : new String[]{"logs", "stacks", "logLevel"}) {
            for (String user : new String[]{"userA", "userB", "userC", "userD"}) {
                Assert.assertEquals((long)200L, (long)TestHttpServer.getHttpStatusCode(serverURL + servlet, user));
            }
            Assert.assertEquals((long)401L, (long)TestHttpServer.getHttpStatusCode(serverURL + servlet, "userE"));
        }
        myServer.stop();
    }

    private static Map<String, Object> parse(String jsonString) {
        return (Map)JSON.parse((String)jsonString);
    }

    @Test
    public void testJersey() throws Exception {
        LOG.info((Object)"BEGIN testJersey()");
        String js = this.readOutput(new URL(this.baseUrl, "/jersey/foo?op=bar"));
        Map<String, Object> m = TestHttpServer.parse(js);
        LOG.info((Object)("m=" + m));
        Assert.assertEquals((Object)"foo", (Object)m.get("path"));
        Assert.assertEquals((Object)"bar", (Object)m.get("op"));
        LOG.info((Object)"END testJersey()");
    }

    @Test
    public void testHasAdministratorAccess() throws Exception {
        Configuration conf = new Configuration();
        conf.setBoolean("hadoop.security.authorization", false);
        ServletContext context = (ServletContext)Mockito.mock(ServletContext.class);
        Mockito.when((Object)context.getAttribute("hadoop.conf")).thenReturn((Object)conf);
        Mockito.when((Object)context.getAttribute("admins.acl")).thenReturn(null);
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.getRemoteUser()).thenReturn(null);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        Assert.assertTrue((boolean)HttpServer.hasAdministratorAccess((ServletContext)context, (HttpServletRequest)request, (HttpServletResponse)response));
        response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        conf.setBoolean("hadoop.security.authorization", true);
        Assert.assertFalse((boolean)HttpServer.hasAdministratorAccess((ServletContext)context, (HttpServletRequest)request, (HttpServletResponse)response));
        ((HttpServletResponse)Mockito.verify((Object)response)).sendError(Mockito.eq((int)401), Mockito.anyString());
        response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        Mockito.when((Object)request.getRemoteUser()).thenReturn((Object)"foo");
        Assert.assertTrue((boolean)HttpServer.hasAdministratorAccess((ServletContext)context, (HttpServletRequest)request, (HttpServletResponse)response));
        response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        AccessControlList acls = (AccessControlList)Mockito.mock(AccessControlList.class);
        Mockito.when((Object)acls.isUserAllowed((UserGroupInformation)Mockito.any())).thenReturn((Object)false);
        Mockito.when((Object)context.getAttribute("admins.acl")).thenReturn((Object)acls);
        Assert.assertFalse((boolean)HttpServer.hasAdministratorAccess((ServletContext)context, (HttpServletRequest)request, (HttpServletResponse)response));
        ((HttpServletResponse)Mockito.verify((Object)response)).sendError(Mockito.eq((int)401), Mockito.anyString());
        response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        Mockito.when((Object)acls.isUserAllowed((UserGroupInformation)Mockito.any())).thenReturn((Object)true);
        Mockito.when((Object)context.getAttribute("admins.acl")).thenReturn((Object)acls);
        Assert.assertTrue((boolean)HttpServer.hasAdministratorAccess((ServletContext)context, (HttpServletRequest)request, (HttpServletResponse)response));
    }

    public static class MyGroupsProvider
    extends ShellBasedUnixGroupsMapping {
        static Map<String, List<String>> mapping = new HashMap<String, List<String>>();

        static void clearMapping() {
            mapping.clear();
        }

        public List<String> getGroups(String user) throws IOException {
            return mapping.get(user);
        }
    }

    public static class DummyFilterInitializer
    extends FilterInitializer {
        public void initFilter(FilterContainer container, Configuration conf) {
            container.addFilter("DummyFilter", DummyServletFilter.class.getName(), null);
        }
    }

    public static class DummyServletFilter
    implements Filter {
        public void destroy() {
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
            final String userName = request.getParameter("user.name");
            HttpServletRequestWrapper requestModified = new HttpServletRequestWrapper((HttpServletRequest)request){

                public String getRemoteUser() {
                    return userName;
                }
            };
            filterChain.doFilter((ServletRequest)requestModified, response);
        }

        public void init(FilterConfig arg0) throws ServletException {
        }
    }

    public static class EchoServlet
    extends HttpServlet {
        public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            PrintStream out = new PrintStream((OutputStream)response.getOutputStream());
            TreeSet sortedKeys = new TreeSet();
            Enumeration keys = request.getParameterNames();
            while (keys.hasMoreElements()) {
                sortedKeys.add(keys.nextElement());
            }
            for (String key : sortedKeys) {
                out.print(key);
                out.print(':');
                out.print(request.getParameter(key));
                out.print('\n');
            }
            out.close();
        }
    }

    public static class EchoMapServlet
    extends HttpServlet {
        public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            PrintStream out = new PrintStream((OutputStream)response.getOutputStream());
            Map params = request.getParameterMap();
            TreeSet keys = new TreeSet(params.keySet());
            for (String key : keys) {
                out.print(key);
                out.print(':');
                String[] values = (String[])params.get(key);
                if (values.length > 0) {
                    out.print(values[0]);
                    for (int i = 1; i < values.length; ++i) {
                        out.print(',');
                        out.print(values[i]);
                    }
                }
                out.print('\n');
            }
            out.close();
        }
    }
}

