/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.LeaseManager;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class TestLeaseManager
extends TestCase {
    public static final Log LOG = LogFactory.getLog(TestLeaseManager.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMultiPathLeaseRecovery() throws IOException, InterruptedException {
        LeaseManager leaseManager;
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = new MiniDFSCluster(conf, 3, true, null);
        NameNode namenode = cluster.getNameNode();
        FSNamesystem spyNamesystem = (FSNamesystem)Mockito.spy((Object)namenode.getNamesystem());
        spyNamesystem.leaseManager = leaseManager = new LeaseManager(spyNamesystem);
        spyNamesystem.lmthread.interrupt();
        String holder = "client-1";
        String path1 = "/file-1";
        String path2 = "/file-2";
        CalledAnswer internalReleaseCalled = new CalledAnswer();
        CalledAnswer internalReleaseOneCalled = new CalledAnswer();
        ((FSNamesystem)Mockito.doAnswer(internalReleaseCalled).when((Object)spyNamesystem)).internalReleaseLease((LeaseManager.Lease)Matchers.anyObject(), Matchers.anyString());
        ((FSNamesystem)Mockito.doAnswer(internalReleaseOneCalled).when((Object)spyNamesystem)).internalReleaseLeaseOne((LeaseManager.Lease)Matchers.anyObject(), Matchers.anyString());
        leaseManager.setLeasePeriod(1L, 2L);
        leaseManager.addLease(holder, path1);
        leaseManager.addLease(holder, path2);
        Thread.sleep(1000L);
        FSNamesystem fSNamesystem = spyNamesystem;
        synchronized (fSNamesystem) {
            leaseManager.checkLeases();
        }
        TestLeaseManager.assertTrue((String)"internalReleaseOne not called", (boolean)internalReleaseOneCalled.isCalled());
        TestLeaseManager.assertFalse((String)"internalRelease called", (boolean)internalReleaseCalled.isCalled());
    }

    private static class CalledAnswer<T>
    implements Answer<T> {
        private volatile boolean called = false;

        private CalledAnswer() {
        }

        public T answer(InvocationOnMock invocationOnMock) throws Throwable {
            this.called = true;
            return (T)invocationOnMock.callRealMethod();
        }

        public boolean isCalled() {
            return this.called;
        }
    }
}

