/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.junit.Assert;
import org.junit.Test;

public class TestINodeFile {
    static final short BLOCKBITS = 48;
    static final long BLKSIZE_MAXVALUE = 0xFFFFFFFFFFFFL;
    private String userName = "Test";
    private short replication;
    private long preferredBlockSize;

    @Test
    public void testReplication() {
        this.replication = (short)3;
        this.preferredBlockSize = 0x8000000L;
        INodeFile inf = new INodeFile(new PermissionStatus(this.userName, null, FsPermission.getDefault()), null, this.replication, 0L, 0L, this.preferredBlockSize);
        Assert.assertEquals((String)"True has to be returned in this case", (long)this.replication, (long)inf.getReplication());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testReplicationBelowLowerBound() throws IllegalArgumentException {
        this.replication = (short)-1;
        this.preferredBlockSize = 0x8000000L;
        INodeFile inf = new INodeFile(new PermissionStatus(this.userName, null, FsPermission.getDefault()), null, this.replication, 0L, 0L, this.preferredBlockSize);
    }

    @Test
    public void testPreferredBlockSize() {
        this.replication = (short)3;
        this.preferredBlockSize = 0x8000000L;
        INodeFile inf = new INodeFile(new PermissionStatus(this.userName, null, FsPermission.getDefault()), null, this.replication, 0L, 0L, this.preferredBlockSize);
        Assert.assertEquals((String)"True has to be returned in this case", (long)this.preferredBlockSize, (long)inf.getPreferredBlockSize());
    }

    @Test
    public void testPreferredBlockSizeUpperBound() {
        this.replication = (short)3;
        this.preferredBlockSize = 0xFFFFFFFFFFFFL;
        INodeFile inf = new INodeFile(new PermissionStatus(this.userName, null, FsPermission.getDefault()), null, this.replication, 0L, 0L, this.preferredBlockSize);
        Assert.assertEquals((String)"True has to be returned in this case", (long)0xFFFFFFFFFFFFL, (long)inf.getPreferredBlockSize());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testPreferredBlockSizeBelowLowerBound() throws IllegalArgumentException {
        this.replication = (short)3;
        this.preferredBlockSize = -1L;
        INodeFile inf = new INodeFile(new PermissionStatus(this.userName, null, FsPermission.getDefault()), null, this.replication, 0L, 0L, this.preferredBlockSize);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testPreferredBlockSizeAboveUpperBound() throws IllegalArgumentException {
        this.replication = (short)3;
        this.preferredBlockSize = 0x1000000000000L;
        INodeFile inf = new INodeFile(new PermissionStatus(this.userName, null, FsPermission.getDefault()), null, this.replication, 0L, 0L, this.preferredBlockSize);
    }
}

