/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.FSEditLog;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.junit.Assert;
import org.junit.Test;

public class TestEditLogLoading {
    private static final int NUM_DATA_NODES = 0;

    @Test
    public void testDisplayRecentEditLogOpCodes() throws IOException {
        Configuration conf = new Configuration();
        conf.set("dfs.name.dir", new File(MiniDFSCluster.getBaseDir(), "name").getPath());
        MiniDFSCluster cluster = null;
        FileSystem fileSys = null;
        cluster = new MiniDFSCluster(0, conf, 0, true, false, null, null);
        cluster.waitActive();
        fileSys = cluster.getFileSystem();
        FSNamesystem namesystem = cluster.getNameNode().getNamesystem();
        FSImage fsimage = namesystem.getFSImage();
        FSEditLog editLog = fsimage.getEditLog();
        for (int i = 0; i < 20; ++i) {
            fileSys.mkdirs(new Path("/tmp/tmp" + i));
        }
        File editFile = editLog.getFsEditName();
        System.out.println("edit log file: " + editFile);
        editLog.close();
        cluster.shutdown();
        long fileLen = editFile.length();
        RandomAccessFile rwf = new RandomAccessFile(editFile, "rw");
        rwf.seek(fileLen - 40L);
        for (int i = 0; i < 20; ++i) {
            rwf.write(2);
        }
        rwf.close();
        String expectedErrorMessage = "^Error replaying edit log at offset \\d+\n";
        expectedErrorMessage = expectedErrorMessage + "Recent opcode offsets: (\\d+\\s*){4}$";
        try {
            cluster = new MiniDFSCluster(0, conf, 0, false, false, null, null);
            cluster.waitActive();
            Assert.fail((String)"should not be able to start");
        }
        catch (IOException e) {
            Assert.assertTrue((String)"error message contains opcodes message", (boolean)e.getMessage().matches(expectedErrorMessage));
        }
    }
}

