/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.BlockReader;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.BlockListAsLongs;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.token.Token;

public class TestDataNodeVolumeFailure
extends TestCase {
    private final int block_size = 512;
    MiniDFSCluster cluster = null;
    int dn_num = 2;
    int blocks_num = 30;
    short repl = (short)2;
    File dataDir = null;
    File data_fail = null;
    File failedDir = null;
    Map<String, BlockLocs> block_map = new HashMap<String, BlockLocs>();

    public void setUp() throws Exception {
        Configuration conf = new Configuration();
        conf.setLong("dfs.block.size", 512L);
        conf.setInt("dfs.datanode.failed.volumes.tolerated", 1);
        this.cluster = new MiniDFSCluster(conf, this.dn_num, true, null);
        this.cluster.waitActive();
    }

    public void testVolumeFailure() throws IOException {
        FileSystem fs = this.cluster.getFileSystem();
        this.dataDir = new File(this.cluster.getDataDirectory());
        System.out.println("Data dir: is " + this.dataDir.getPath());
        String filename = "/test.txt";
        Path filePath = new Path(filename);
        int filesize = 512 * this.blocks_num;
        DFSTestUtil.createFile(fs, filePath, filesize, this.repl, 1L);
        DFSTestUtil.waitReplication(fs, filePath, this.repl);
        System.out.println("file " + filename + "(size " + filesize + ") is created and replicated");
        this.data_fail = new File(this.dataDir, "data3");
        this.failedDir = new File(this.data_fail, "current");
        if (this.failedDir.exists() && !this.deteteBlocks(this.failedDir)) {
            throw new IOException("Could not delete hdfs directory '" + this.failedDir + "'");
        }
        this.data_fail.setReadOnly();
        this.failedDir.setReadOnly();
        System.out.println("Deleteing " + this.failedDir.getPath() + "; exist=" + this.failedDir.exists());
        this.triggerFailure(filename, filesize);
        DataNode dn = this.cluster.getDataNodes().get(1);
        this.cluster.getNameNode().blockReport(dn.dnRegistration, BlockListAsLongs.convertToArrayLongs((Block[])this.cluster.getBlockReport(1)));
        this.verify(filename, filesize);
        System.out.println("creating file test1.txt");
        Path fileName1 = new Path("/test1.txt");
        DFSTestUtil.createFile(fs, fileName1, filesize, this.repl, 1L);
        DFSTestUtil.waitReplication(fs, fileName1, this.repl);
        System.out.println("file " + fileName1.getName() + " is created and replicated");
    }

    private void verify(String fn, int fs) throws IOException {
        int totalReal = this.countRealBlocks(this.block_map);
        System.out.println("countRealBlocks counted " + totalReal + " blocks");
        int totalNN = this.countNNBlocks(this.block_map, fn, fs);
        System.out.println("countNNBlocks counted " + totalNN + " blocks");
        for (String bid : this.block_map.keySet()) {
            BlockLocs bl = this.block_map.get(bid);
            TestDataNodeVolumeFailure.assertEquals((int)bl.num_files, (int)bl.num_locs);
        }
        TestDataNodeVolumeFailure.assertEquals((int)totalReal, (int)totalNN);
        FSNamesystem fsn = FSNamesystem.getFSNamesystem();
        fsn.computeDatanodeWork();
        long underRepl = fsn.getUnderReplicatedBlocks();
        long pendRepl = fsn.getPendingReplicationBlocks();
        long totalRepl = underRepl + pendRepl;
        System.out.println("underreplicated after = " + underRepl + " and pending repl =" + pendRepl + "; total underRepl = " + totalRepl);
        System.out.println("total blocks (real and replicating):" + ((long)totalReal + totalRepl) + " vs. all files blocks " + this.blocks_num * 2);
        TestDataNodeVolumeFailure.assertEquals((long)((long)totalReal + totalRepl), (long)(this.blocks_num * this.repl));
    }

    private void triggerFailure(String path, long size) throws IOException {
        NameNode nn = this.cluster.getNameNode();
        List locatedBlocks = nn.getBlockLocations(path, 0L, size).getLocatedBlocks();
        for (LocatedBlock lb : locatedBlocks) {
            DatanodeInfo dinfo = lb.getLocations()[1];
            Block b = lb.getBlock();
            try {
                this.accessBlock(dinfo, lb);
            }
            catch (IOException e) {
                System.out.println("Failure triggered, on block: " + b.getBlockId() + "; corresponding volume should be removed by now");
                break;
            }
        }
    }

    private boolean deteteBlocks(File dir) {
        File[] fileList;
        for (File f : fileList = dir.listFiles()) {
            if (!f.getName().startsWith("blk_") || f.delete()) continue;
            return false;
        }
        return true;
    }

    private void accessBlock(DatanodeInfo datanode, LocatedBlock lblock) throws IOException {
        InetSocketAddress targetAddr = null;
        Socket s = null;
        BlockReader blockReader = null;
        Block block = lblock.getBlock();
        targetAddr = NetUtils.createSocketAddr((String)datanode.getName());
        s = new Socket();
        s.connect(targetAddr, 60000);
        s.setSoTimeout(60000);
        blockReader = DFSClient.RemoteBlockReader.newBlockReader((Socket)s, (String)(targetAddr.toString() + ":" + block.getBlockId()), (long)block.getBlockId(), (Token)lblock.getBlockToken(), (long)block.getGenerationStamp(), (long)0L, (long)-1L, (int)4096);
    }

    private int countNNBlocks(Map<String, BlockLocs> map, String path, long size) throws IOException {
        int total = 0;
        NameNode nn = this.cluster.getNameNode();
        List locatedBlocks = nn.getBlockLocations(path, 0L, size).getLocatedBlocks();
        for (LocatedBlock lb : locatedBlocks) {
            String blockId = "" + lb.getBlock().getBlockId();
            DatanodeInfo[] dn_locs = lb.getLocations();
            BlockLocs bl = map.get(blockId);
            if (bl == null) {
                bl = new BlockLocs();
            }
            total += dn_locs.length;
            bl.num_locs += dn_locs.length;
            map.put(blockId, bl);
        }
        return total;
    }

    private int countRealBlocks(Map<String, BlockLocs> map) {
        int total = 0;
        for (int i = 0; i < this.dn_num; ++i) {
            for (int j = 1; j <= 2; ++j) {
                File dir = new File(new File(this.dataDir, "data" + (2 * i + j)), "current");
                if (dir == null) {
                    System.out.println("dir is null for dn=" + i + " and data_dir=" + j);
                    continue;
                }
                String[] res = this.metaFilesInDir(dir);
                if (res == null) {
                    System.out.println("res is null for dir = " + dir + " i=" + i + " and j=" + j);
                    continue;
                }
                for (String s : res) {
                    TestDataNodeVolumeFailure.assertNotNull((Object)s);
                    String bid = s.substring(s.indexOf("_") + 1, s.lastIndexOf("_"));
                    BlockLocs val = map.get(bid);
                    if (val == null) {
                        val = new BlockLocs();
                    }
                    ++val.num_files;
                    map.put(bid, val);
                }
                total += res.length;
            }
        }
        return total;
    }

    private String[] metaFilesInDir(File dir) {
        String[] res = dir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("blk_") && name.endsWith(".meta");
            }
        });
        return res;
    }

    public void tearDown() throws Exception {
        if (this.data_fail != null) {
            this.data_fail.setWritable(true);
        }
        if (this.failedDir != null) {
            this.failedDir.setWritable(true);
        }
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    private class BlockLocs {
        public int num_files = 0;
        public int num_locs = 0;

        private BlockLocs() {
        }
    }
}

