/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.util.Arrays;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.junit.Test;

public class TestLargeBlock
extends TestCase {
    static final String DIR = "/" + TestLargeBlock.class.getSimpleName() + "/";
    static final boolean verifyData = true;
    static final byte[] pattern = new byte[]{68, 69, 65, 68, 66, 69, 69, 70};
    static final boolean simulatedStorage = false;

    static FSDataOutputStream createFile(FileSystem fileSys, Path name, int repl, long blockSize) throws IOException {
        FSDataOutputStream stm = fileSys.create(name, true, fileSys.getConf().getInt("io.file.buffer.size", 4096), (short)repl, blockSize);
        System.out.println("createFile: Created " + name + " with " + repl + " replica.");
        return stm;
    }

    static void writeFile(FSDataOutputStream stm, long fileSize) throws IOException {
        int writeSize = pattern.length * 8 * 1024 * 1024;
        if (writeSize > Integer.MAX_VALUE) {
            throw new IOException("A single write is too large " + writeSize);
        }
        long bytesToWrite = fileSize;
        byte[] b = new byte[writeSize];
        for (int j = 0; j < writeSize; ++j) {
            b[j] = pattern[j % pattern.length];
        }
        while (bytesToWrite > 0L) {
            int thiswrite = (int)Math.min((long)writeSize, bytesToWrite);
            stm.write(b, 0, thiswrite);
            bytesToWrite -= (long)thiswrite;
        }
    }

    static void checkFullFile(FileSystem fs, Path name, long fileSize) throws IOException {
        int readSize = pattern.length * 16 * 1024 * 1024;
        if (readSize > Integer.MAX_VALUE) {
            throw new IOException("A single read is too large " + readSize);
        }
        byte[] b = new byte[readSize];
        long bytesToRead = fileSize;
        byte[] compb = new byte[readSize];
        for (int j = 0; j < readSize; ++j) {
            compb[j] = pattern[j % pattern.length];
        }
        FSDataInputStream stm = fs.open(name);
        while (bytesToRead > 0L) {
            int thisread = (int)Math.min((long)readSize, bytesToRead);
            stm.readFully(b, 0, thisread);
            if (thisread == readSize) {
                TestLargeBlock.assertTrue((String)("file corrupted at or after byte " + (fileSize - bytesToRead)), (boolean)Arrays.equals(b, compb));
            } else {
                for (int k = 0; k < thisread; ++k) {
                    TestLargeBlock.assertTrue((String)("file corrupted at or after byte " + (fileSize - bytesToRead)), (b[k] == compb[k] ? 1 : 0) != 0);
                }
            }
            bytesToRead -= (long)thisread;
        }
        stm.close();
    }

    @Test
    public void testLargeBlockSize() throws IOException {
        long blockSize = 0x80000200L;
        this.runTest(0x80000200L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTest(long blockSize) throws IOException {
        long fileSize = blockSize + 1L;
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = new MiniDFSCluster(conf, 1, true, null);
        FileSystem fs = cluster.getFileSystem();
        try {
            Path file1 = new Path(System.getProperty("test.build.data") + "/" + Long.toString(blockSize) + ".dat");
            FSDataOutputStream stm = TestLargeBlock.createFile(fs, file1, 1, blockSize);
            System.out.println("File " + file1 + " created with file size " + fileSize + " blocksize " + blockSize);
            TestLargeBlock.assertTrue((String)(file1 + " should be a file and not a dir"), (!fs.getFileStatus(file1).isDir() ? 1 : 0) != 0);
            TestLargeBlock.writeFile(stm, fileSize);
            System.out.println("File " + file1 + " written to.");
            stm.close();
            System.out.println("File " + file1 + " closed.");
            TestLargeBlock.checkFullFile(fs, file1, fileSize);
            long len = fs.getFileStatus(file1).getLen();
            TestLargeBlock.assertTrue((String)(file1 + " should be of size " + fileSize + " but found to be of size " + len), (len == fileSize ? 1 : 0) != 0);
        }
        finally {
            cluster.shutdown();
        }
    }
}

