/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.ClientDatanodeProtocol;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.FSConstants;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.server.common.UpgradeStatusReport;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NotReplicatedYetException;
import org.apache.hadoop.hdfs.web.WebHdfsTestUtil;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.ipc.VersionedProtocol;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.StringUtils;
import org.apache.log4j.Level;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class TestDFSClientRetries
extends TestCase {
    private static final String ADDRESS = "0.0.0.0";
    private static final int PING_INTERVAL = 1000;
    private static final int MIN_SLEEP_TIME = 1000;
    public static final Log LOG = LogFactory.getLog((String)TestDFSClientRetries.class.getName());
    private static final Configuration conf = new Configuration();

    private static void writeData(OutputStream out, int len) throws IOException {
        byte[] buf = new byte[65536];
        while (len > 0) {
            int toWrite = Math.min(len, buf.length);
            out.write(buf, 0, toWrite);
            len -= toWrite;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWriteTimeoutAtDataNode() throws IOException, InterruptedException {
        int writeTimeout = 100;
        conf.setInt("dfs.datanode.socket.write.timeout", 100);
        int blockSize = 0xA00000;
        conf.setInt("dfs.block.size", 0xA00000);
        conf.setInt("dfs.client.max.block.acquire.failures", 1);
        int bufferSize = 4096;
        conf.setInt("io.file.buffer.size", 4096);
        MiniDFSCluster cluster = new MiniDFSCluster(conf, 3, true, null);
        try {
            cluster.waitActive();
            FileSystem fs = cluster.getFileSystem();
            Path filePath = new Path("/testWriteTimeoutAtDataNode");
            FSDataOutputStream out = fs.create(filePath, true, 4096);
            TestDFSClientRetries.writeData((OutputStream)out, 0x1400000);
            out.close();
            byte[] buf = new byte[0x100000];
            FSDataInputStream in = fs.open(filePath, 4096);
            IOUtils.readFully((InputStream)in, (byte[])buf, (int)0, (int)2048);
            for (int i = 0; i < 10; ++i) {
                Thread.sleep(200L);
                IOUtils.readFully((InputStream)in, (byte[])buf, (int)0, (int)buf.length);
            }
            in.close();
        }
        finally {
            cluster.shutdown();
        }
    }

    public void testNotYetReplicatedErrors() throws IOException {
        conf.setInt("dfs.client.block.write.locateFollowingBlock.retries", 1);
        TestNameNode tnn = new TestNameNode(conf);
        DFSClient client = new DFSClient(null, (ClientProtocol)tnn, conf, null);
        OutputStream os = client.create("testfile", true);
        os.write(20);
        try {
            os.close();
        }
        catch (Exception e) {
            TestDFSClientRetries.assertTrue((String)"Retries are not being stopped correctly", (boolean)e.getMessage().equals(tnn.ADD_BLOCK_EXCEPTION));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFailuresArePerOperation() throws Exception {
        long fileSize = 4096L;
        Path file = new Path("/testFile");
        MiniDFSCluster cluster = new MiniDFSCluster(conf, 1, true, null);
        int maxBlockAcquires = DFSClient.getMaxBlockAcquireFailures((Configuration)conf);
        TestDFSClientRetries.assertTrue((maxBlockAcquires > 0 ? 1 : 0) != 0);
        try {
            cluster.waitActive();
            FileSystem fs = cluster.getFileSystem();
            NameNode preSpyNN = cluster.getNameNode();
            NameNode spyNN = (NameNode)Mockito.spy((Object)preSpyNN);
            DFSClient client = new DFSClient(null, (ClientProtocol)spyNN, conf, null);
            DFSTestUtil.createFile(fs, file, fileSize, (short)1, 12345L);
            ((NameNode)Mockito.doAnswer((Answer)new FailNTimesAnswer(preSpyNN, maxBlockAcquires + 1)).when((Object)spyNN)).getBlockLocations(Matchers.anyString(), Matchers.anyLong(), Matchers.anyLong());
            try {
                IOUtils.copyBytes((InputStream)client.open(file.toString()), (OutputStream)new IOUtils.NullOutputStream(), (Configuration)conf, (boolean)true);
                TestDFSClientRetries.fail((String)"Didn't get exception");
            }
            catch (IOException ioe) {
                DFSClient.LOG.info((Object)"Got expected exception", (Throwable)ioe);
            }
            ((NameNode)Mockito.doAnswer((Answer)new FailNTimesAnswer(preSpyNN, maxBlockAcquires)).when((Object)spyNN)).getBlockLocations(Matchers.anyString(), Matchers.anyLong(), Matchers.anyLong());
            IOUtils.copyBytes((InputStream)client.open(file.toString()), (OutputStream)new IOUtils.NullOutputStream(), (Configuration)conf, (boolean)true);
            DFSClient.LOG.info((Object)"Starting test case for failure reset");
            ((NameNode)Mockito.doAnswer((Answer)new FailNTimesAnswer(preSpyNN, maxBlockAcquires)).when((Object)spyNN)).getBlockLocations(Matchers.anyString(), Matchers.anyLong(), Matchers.anyLong());
            DFSClient.DFSInputStream is = client.open(file.toString());
            byte[] buf = new byte[10];
            IOUtils.readFully((InputStream)is, (byte[])buf, (int)0, (int)buf.length);
            DFSClient.LOG.info((Object)"First read successful after some failures.");
            ((NameNode)Mockito.doAnswer((Answer)new FailNTimesAnswer(preSpyNN, maxBlockAcquires)).when((Object)spyNN)).getBlockLocations(Matchers.anyString(), Matchers.anyLong(), Matchers.anyLong());
            is.openInfo();
            is.seek(0L);
            IOUtils.readFully((InputStream)is, (byte[])buf, (int)0, (int)buf.length);
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testClientDNProtocolTimeout() throws IOException {
        TestServer server;
        block5: {
            server = new TestServer(1, true);
            server.start();
            InetSocketAddress addr = NetUtils.getConnectAddress((Server)server);
            DatanodeID fakeDnId = new DatanodeID("localhost:" + addr.getPort(), "fake-storage", 0, addr.getPort());
            DatanodeInfo dnInfo = new DatanodeInfo(fakeDnId);
            LocatedBlock fakeBlock = new LocatedBlock(new Block(12345L), new DatanodeInfo[0]);
            ClientDatanodeProtocol proxy = null;
            try {
                proxy = DFSClient.createClientDatanodeProtocolProxy((DatanodeInfo)dnInfo, (Configuration)conf, (Block)fakeBlock.getBlock(), (Token)fakeBlock.getBlockToken(), (int)500, (boolean)false);
                TestDFSClientRetries.fail((String)"Did not get expected exception: SocketTimeoutException");
                if (proxy == null) break block5;
            }
            catch (SocketTimeoutException e) {
                block6: {
                    try {
                        LOG.info((Object)"Got the expected Exception: SocketTimeoutException");
                        if (proxy == null) break block6;
                    }
                    catch (Throwable throwable) {
                        if (proxy != null) {
                            RPC.stopProxy(proxy);
                        }
                        server.stop();
                        throw throwable;
                    }
                    RPC.stopProxy((VersionedProtocol)proxy);
                }
                server.stop();
            }
            RPC.stopProxy((VersionedProtocol)proxy);
        }
        server.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetFileChecksum() throws Exception {
        String f = "/testGetFileChecksum";
        Path p = new Path("/testGetFileChecksum");
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = new MiniDFSCluster(conf, 3, true, null);
        try {
            cluster.waitActive();
            FileSystem fs = cluster.getFileSystem();
            DFSTestUtil.createFile(fs, p, 0x100000L, (short)3, 20100402L);
            FileChecksum cs1 = fs.getFileChecksum(p);
            TestDFSClientRetries.assertTrue((cs1 != null ? 1 : 0) != 0);
            List locatedblocks = DFSClient.callGetBlockLocations((ClientProtocol)cluster.getNameNode(), (String)"/testGetFileChecksum", (long)0L, (long)Long.MAX_VALUE).getLocatedBlocks();
            DatanodeInfo first = ((LocatedBlock)locatedblocks.get(0)).getLocations()[0];
            cluster.stopDataNode(first.getName());
            FileChecksum cs2 = fs.getFileChecksum(p);
            TestDFSClientRetries.assertEquals((Object)cs1, (Object)cs2);
        }
        finally {
            cluster.shutdown();
        }
    }

    public void testNamenodeRestart() throws Exception {
        TestDFSClientRetries.namenodeRestartTest(new Configuration(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void namenodeRestartTest(final Configuration conf, final boolean isWebHDFS) throws Exception {
        ((Log4JLogger)DFSClient.LOG).getLogger().setLevel(Level.ALL);
        final ArrayList<Exception> exceptions = new ArrayList<Exception>();
        Path dir = new Path("/testNamenodeRestart");
        conf.setBoolean("dfs.client.retry.policy.enabled", true);
        conf.setInt("dfs.namenode.safemode.min.datanodes", 1);
        conf.setInt("dfs.safemode.extension.testing", 5000);
        int numDatanodes = 3;
        final MiniDFSCluster cluster = new MiniDFSCluster(conf, 3, true, null);
        try {
            int r;
            cluster.waitActive();
            final DistributedFileSystem dfs = (DistributedFileSystem)cluster.getFileSystem();
            DistributedFileSystem fs = isWebHDFS ? WebHdfsTestUtil.getWebHdfsFileSystem(conf) : dfs;
            final URI uri = dfs.getUri();
            TestDFSClientRetries.assertTrue((boolean)DistributedFileSystem.isHealthy((URI)uri));
            long length = 0x100000L;
            final Path file1 = new Path(dir, "foo");
            DFSTestUtil.createFile((FileSystem)fs, file1, 0x100000L, (short)3, 20120406L);
            final FileStatus s1 = fs.getFileStatus(file1);
            TestDFSClientRetries.assertEquals((long)0x100000L, (long)s1.getLen());
            Path file4 = new Path(dir, "file4");
            final FSDataOutputStream out4 = fs.create(file4, false, 4096, fs.getDefaultReplication(file4), 1024L, null);
            final byte[] bytes = new byte[1000];
            new Random().nextBytes(bytes);
            out4.write(bytes);
            out4.write(bytes);
            out4.sync();
            TestDFSClientRetries.assertTrue((boolean)DistributedFileSystem.isHealthy((URI)uri));
            cluster.shutdownNameNode();
            TestDFSClientRetries.assertFalse((boolean)DistributedFileSystem.isHealthy((URI)uri));
            Thread file4thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        out4.write(bytes);
                        out4.write(bytes);
                        out4.write(bytes);
                        out4.close();
                    }
                    catch (Exception e) {
                        exceptions.add(e);
                    }
                }
            });
            file4thread.start();
            Thread reader = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        FileSystem fs = TestDFSClientRetries.createFsWithDifferentUsername(conf, isWebHDFS);
                        FSDataInputStream in = fs.open(file1);
                        int count = 0;
                        while (in.read() != -1) {
                            ++count;
                        }
                        in.close();
                        Assert.assertEquals((long)s1.getLen(), (long)count);
                    }
                    catch (Exception e) {
                        exceptions.add(e);
                    }
                }
            });
            reader.start();
            final Path file3 = new Path(dir, "file");
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        FileSystem fs = TestDFSClientRetries.createFsWithDifferentUsername(conf, isWebHDFS);
                        DFSTestUtil.createFile(fs, file3, 0x100000L, (short)3, 20120406L);
                    }
                    catch (Exception e) {
                        exceptions.add(e);
                    }
                }
            });
            thread.start();
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        TimeUnit.SECONDS.sleep(30L);
                        Assert.assertFalse((boolean)DistributedFileSystem.isHealthy((URI)uri));
                        cluster.restartNameNode(false, false);
                        cluster.waitActive();
                        Assert.assertTrue((boolean)DistributedFileSystem.isHealthy((URI)uri));
                    }
                    catch (Exception e) {
                        exceptions.add(e);
                    }
                }
            }).start();
            FileStatus s2 = fs.getFileStatus(file1);
            TestDFSClientRetries.assertEquals((Object)s1, (Object)s2);
            thread.join();
            TestDFSClientRetries.assertEmpty(exceptions);
            TestDFSClientRetries.assertEquals((long)s1.getLen(), (long)fs.getFileStatus(file3).getLen());
            TestDFSClientRetries.assertEquals((Object)fs.getFileChecksum(file1), (Object)fs.getFileChecksum(file3));
            reader.join();
            TestDFSClientRetries.assertEmpty(exceptions);
            file4thread.join();
            TestDFSClientRetries.assertEmpty(exceptions);
            FSDataInputStream in = fs.open(file4);
            int count = 0;
            while ((r = in.read()) != -1) {
                Assert.assertEquals((String)String.format("count=%d", count), (byte)bytes[count % bytes.length], (byte)((byte)r));
                ++count;
            }
            Assert.assertEquals((int)(5 * bytes.length), (int)count);
            in.close();
            TestDFSClientRetries.assertTrue((boolean)DistributedFileSystem.isHealthy((URI)uri));
            dfs.setSafeMode(FSConstants.SafeModeAction.SAFEMODE_ENTER);
            TestDFSClientRetries.assertFalse((boolean)DistributedFileSystem.isHealthy((URI)uri));
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        TimeUnit.SECONDS.sleep(30L);
                        Assert.assertFalse((boolean)DistributedFileSystem.isHealthy((URI)uri));
                        dfs.setSafeMode(FSConstants.SafeModeAction.SAFEMODE_LEAVE);
                        Assert.assertTrue((boolean)DistributedFileSystem.isHealthy((URI)uri));
                    }
                    catch (Exception e) {
                        exceptions.add(e);
                    }
                }
            }).start();
            Path file2 = new Path(dir, "bar");
            DFSTestUtil.createFile((FileSystem)fs, file2, 0x100000L, (short)3, 20120406L);
            TestDFSClientRetries.assertEquals((Object)fs.getFileChecksum(file1), (Object)fs.getFileChecksum(file2));
            TestDFSClientRetries.assertTrue((boolean)DistributedFileSystem.isHealthy((URI)uri));
            Path nonExisting = new Path(dir, "nonExisting");
            LOG.info((Object)("setPermission: " + nonExisting));
            try {
                fs.setPermission(nonExisting, new FsPermission(0));
                TestDFSClientRetries.fail();
            }
            catch (FileNotFoundException fnfe) {
                LOG.info((Object)"GOOD!", (Throwable)fnfe);
            }
            TestDFSClientRetries.assertEmpty(exceptions);
        }
        finally {
            cluster.shutdown();
        }
    }

    static void assertEmpty(List<Exception> exceptions) {
        if (!exceptions.isEmpty()) {
            StringBuilder b = new StringBuilder("There are ").append(exceptions.size()).append(" exception(s):");
            for (int i = 0; i < exceptions.size(); ++i) {
                b.append("\n  Exception ").append(i).append(": ").append(StringUtils.stringifyException((Throwable)exceptions.get(i)));
            }
            TestDFSClientRetries.fail((String)b.toString());
        }
    }

    private static FileSystem createFsWithDifferentUsername(Configuration conf, boolean isWebHDFS) throws IOException, InterruptedException {
        String username = UserGroupInformation.getCurrentUser().getShortUserName() + "_XXX";
        UserGroupInformation ugi = UserGroupInformation.createUserForTesting((String)username, (String[])new String[]{"supergroup"});
        return isWebHDFS ? WebHdfsTestUtil.getWebHdfsFileSystemAs(ugi, conf) : DFSTestUtil.getFileSystemAs(ugi, conf);
    }

    public void testMultipleLinearRandomRetry() {
        TestDFSClientRetries.parseMultipleLinearRandomRetry(null, "");
        TestDFSClientRetries.parseMultipleLinearRandomRetry(null, "11");
        TestDFSClientRetries.parseMultipleLinearRandomRetry(null, "11,22,33");
        TestDFSClientRetries.parseMultipleLinearRandomRetry(null, "11,22,33,44,55");
        TestDFSClientRetries.parseMultipleLinearRandomRetry(null, "AA");
        TestDFSClientRetries.parseMultipleLinearRandomRetry(null, "11,AA");
        TestDFSClientRetries.parseMultipleLinearRandomRetry(null, "11,22,33,FF");
        TestDFSClientRetries.parseMultipleLinearRandomRetry(null, "11,-22");
        TestDFSClientRetries.parseMultipleLinearRandomRetry(null, "-11,22");
        TestDFSClientRetries.parseMultipleLinearRandomRetry("[22x11ms]", "11,22");
        TestDFSClientRetries.parseMultipleLinearRandomRetry("[22x11ms, 44x33ms]", "11,22,33,44");
        TestDFSClientRetries.parseMultipleLinearRandomRetry("[22x11ms, 44x33ms, 66x55ms]", "11,22,33,44,55,66");
        TestDFSClientRetries.parseMultipleLinearRandomRetry("[22x11ms, 44x33ms, 66x55ms]", "   11,   22, 33,  44, 55,  66   ");
    }

    static void parseMultipleLinearRandomRetry(String expected, String s) {
        RetryPolicies.MultipleLinearRandomRetry r = RetryPolicies.MultipleLinearRandomRetry.parseCommaSeparatedString((String)s);
        LOG.info((Object)("input=" + s + ", parsed=" + r + ", expected=" + expected));
        if (r == null) {
            Assert.assertEquals((String)expected, null);
        } else {
            Assert.assertEquals((String)("MultipleLinearRandomRetry" + expected), (String)r.toString());
        }
    }

    private static class FailNTimesAnswer
    implements Answer<LocatedBlocks> {
        private int failuresLeft;
        private NameNode realNN;

        public FailNTimesAnswer(NameNode realNN, int timesToFail) {
            this.failuresLeft = timesToFail;
            this.realNN = realNN;
        }

        public LocatedBlocks answer(InvocationOnMock invocation) throws IOException {
            Object[] args = invocation.getArguments();
            LocatedBlocks realAnswer = this.realNN.getBlockLocations((String)args[0], ((Long)args[1]).longValue(), ((Long)args[2]).longValue());
            if (this.failuresLeft-- > 0) {
                NameNode.LOG.info((Object)"FailNTimesAnswer injecting failure.");
                return this.makeBadBlockList(realAnswer);
            }
            NameNode.LOG.info((Object)"FailNTimesAnswer no longer failing.");
            return realAnswer;
        }

        private LocatedBlocks makeBadBlockList(LocatedBlocks goodBlockList) {
            LocatedBlock goodLocatedBlock = goodBlockList.get(0);
            LocatedBlock badLocatedBlock = new LocatedBlock(goodLocatedBlock.getBlock(), new DatanodeInfo[]{new DatanodeInfo(new DatanodeID("255.255.255.255:234"))}, goodLocatedBlock.getStartOffset(), false);
            ArrayList<LocatedBlock> badBlocks = new ArrayList<LocatedBlock>();
            badBlocks.add(badLocatedBlock);
            return new LocatedBlocks(goodBlockList.getFileLength(), badBlocks, false);
        }
    }

    class TestNameNode
    implements ClientProtocol {
        int num_calls = 0;
        int num_calls_allowed;
        public final String ADD_BLOCK_EXCEPTION = "Testing exception thrown fromTestDFSClientRetries::TestNameNode::addBlock";
        public final String RETRY_CONFIG = "dfs.client.block.write.locateFollowingBlock.retries";

        public TestNameNode(Configuration conf) throws IOException {
            this.num_calls_allowed = conf.getInt("dfs.client.block.write.locateFollowingBlock.retries", 5) + 1;
        }

        public long getProtocolVersion(String protocol, long clientVersion) throws IOException {
            return 61L;
        }

        public LocatedBlock addBlock(String src, String clientName) throws IOException {
            return this.addBlock(src, clientName, null);
        }

        public LocatedBlock addBlock(String src, String clientName, DatanodeInfo[] excludedNode) throws IOException {
            ++this.num_calls;
            if (this.num_calls > this.num_calls_allowed) {
                throw new IOException("addBlock called more times than dfs.client.block.write.locateFollowingBlock.retries allows.");
            }
            throw new RemoteException(NotReplicatedYetException.class.getName(), "Testing exception thrown fromTestDFSClientRetries::TestNameNode::addBlock");
        }

        public LocatedBlocks getBlockLocations(String src, long offset, long length) throws IOException {
            return null;
        }

        @Deprecated
        public void create(String src, FsPermission masked, String clientName, boolean overwrite, short replication, long blockSize) throws IOException {
        }

        public void create(String src, FsPermission masked, String clientName, boolean overwrite, boolean createparent, short replication, long blockSize) throws IOException {
        }

        public LocatedBlock append(String src, String clientName) throws IOException {
            return null;
        }

        public boolean setReplication(String src, short replication) throws IOException {
            return false;
        }

        public void setPermission(String src, FsPermission permission) throws IOException {
        }

        public void setOwner(String src, String username, String groupname) throws IOException {
        }

        public void abandonBlock(Block b, String src, String holder) throws IOException {
        }

        public boolean complete(String src, String clientName) throws IOException {
            return false;
        }

        public void reportBadBlocks(LocatedBlock[] blocks) throws IOException {
        }

        public boolean rename(String src, String dst) throws IOException {
            return false;
        }

        public boolean delete(String src) throws IOException {
            return false;
        }

        public boolean delete(String src, boolean recursive) throws IOException {
            return false;
        }

        public boolean mkdirs(String src, FsPermission masked) throws IOException {
            return false;
        }

        public HdfsFileStatus[] getListing(String src) throws IOException {
            return null;
        }

        public DirectoryListing getListing(String src, byte[] startName) throws IOException {
            return null;
        }

        public void renewLease(String clientName) throws IOException {
        }

        public long[] getStats() throws IOException {
            return null;
        }

        public DatanodeInfo[] getDatanodeReport(FSConstants.DatanodeReportType type) throws IOException {
            return null;
        }

        public long getPreferredBlockSize(String filename) throws IOException {
            return 0L;
        }

        public boolean setSafeMode(FSConstants.SafeModeAction action) throws IOException {
            return false;
        }

        public void saveNamespace() throws IOException {
        }

        public boolean restoreFailedStorage(String arg) throws AccessControlException {
            return false;
        }

        public void refreshNodes() throws IOException {
        }

        public void finalizeUpgrade() throws IOException {
        }

        public UpgradeStatusReport distributedUpgradeProgress(FSConstants.UpgradeAction action) throws IOException {
            return null;
        }

        public void metaSave(String filename) throws IOException {
        }

        public void setBalancerBandwidth(long bandwidth) throws IOException {
        }

        public HdfsFileStatus getFileInfo(String src) throws IOException {
            return null;
        }

        public ContentSummary getContentSummary(String path) throws IOException {
            return null;
        }

        public void setQuota(String path, long namespaceQuota, long diskspaceQuota) throws IOException {
        }

        public void fsync(String src, String client) throws IOException {
        }

        public void setTimes(String src, long mtime, long atime) throws IOException {
        }

        public boolean recoverLease(String src, String clientName) throws IOException {
            return true;
        }

        public Token<DelegationTokenIdentifier> getDelegationToken(Text renewer) throws IOException {
            return null;
        }

        public long renewDelegationToken(Token<DelegationTokenIdentifier> token) throws SecretManager.InvalidToken, IOException {
            return 0L;
        }

        public void cancelDelegationToken(Token<DelegationTokenIdentifier> token) throws IOException {
        }
    }

    private static class TestServer
    extends Server {
        private boolean sleep;
        private Class<? extends Writable> responseClass;

        public TestServer(int handlerCount, boolean sleep) throws IOException {
            this(handlerCount, sleep, LongWritable.class, null);
        }

        public TestServer(int handlerCount, boolean sleep, Class<? extends Writable> paramClass, Class<? extends Writable> responseClass) throws IOException {
            super(TestDFSClientRetries.ADDRESS, 0, paramClass, handlerCount, conf);
            this.sleep = sleep;
            this.responseClass = responseClass;
        }

        public Writable call(Class<?> protocol, Writable param, long receiveTime) throws IOException {
            if (this.sleep) {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            if (this.responseClass != null) {
                try {
                    return this.responseClass.newInstance();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            return param;
        }
    }
}

