/*
 * Decompiled with CFR 0.152.
 */
package testshell;

import java.io.IOException;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class ExternalMapReduce
extends Configured
implements Tool {
    public void configure(JobConf job) {
    }

    public void close() throws IOException {
    }

    public int run(String[] argv) throws IOException {
        if (argv.length < 2) {
            System.out.println("ExternalMapReduce <input> <output>");
            return -1;
        }
        Path outDir = new Path(argv[1]);
        Path input = new Path(argv[0]);
        JobConf testConf = new JobConf(this.getConf(), ExternalMapReduce.class);
        try {
            testConf.getClassByName("testjar.ClassWordCount");
        }
        catch (ClassNotFoundException e) {
            System.out.println("Could not find class from libjar");
            return -1;
        }
        testConf.setJobName("external job");
        FileInputFormat.setInputPaths((JobConf)testConf, (Path[])new Path[]{input});
        FileOutputFormat.setOutputPath((JobConf)testConf, (Path)outDir);
        testConf.setMapperClass(MapClass.class);
        testConf.setReducerClass(Reduce.class);
        testConf.setNumReduceTasks(1);
        JobClient.runJob((JobConf)testConf);
        return 0;
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)new Configuration(), (Tool)new ExternalMapReduce(), (String[])args);
        System.exit(res);
    }

    public static class Reduce
    extends MapReduceBase
    implements Reducer<WritableComparable, Writable, WritableComparable, IntWritable> {
        public void reduce(WritableComparable key, Iterator<Writable> values, OutputCollector<WritableComparable, IntWritable> output, Reporter reporter) throws IOException {
        }
    }

    public static class MapClass
    extends MapReduceBase
    implements Mapper<WritableComparable, Writable, WritableComparable, IntWritable> {
        public void map(WritableComparable key, Writable value, OutputCollector<WritableComparable, IntWritable> output, Reporter reporter) throws IOException {
            String classpath = System.getProperty("java.class.path");
            if (classpath.indexOf("testjob.jar") == -1) {
                throw new IOException("failed to find in the library " + classpath);
            }
            String[] argv = new String[]{"ls", "files_tmp"};
            Process p = Runtime.getRuntime().exec(argv);
            int ret = -1;
            try {
                ret = p.waitFor();
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            if (ret != 0) {
                throw new IOException("files_tmp does not exist");
            }
        }
    }
}

