/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import junit.framework.TestCase;
import org.apache.hadoop.util.StringUtils;

public class TestStringUtils
extends TestCase {
    private static final String NULL_STR = null;
    private static final String EMPTY_STR = "";
    private static final String STR_WO_SPECIAL_CHARS = "AB";
    private static final String STR_WITH_COMMA = "A,B";
    private static final String ESCAPED_STR_WITH_COMMA = "A\\,B";
    private static final String STR_WITH_ESCAPE = "AB\\";
    private static final String ESCAPED_STR_WITH_ESCAPE = "AB\\\\";
    private static final String STR_WITH_BOTH2 = ",A\\,,B\\\\,";
    private static final String ESCAPED_STR_WITH_BOTH2 = "\\,A\\\\\\,\\,B\\\\\\\\\\,";

    public void testEscapeString() throws Exception {
        TestStringUtils.assertEquals((String)NULL_STR, (String)StringUtils.escapeString((String)NULL_STR));
        TestStringUtils.assertEquals((String)EMPTY_STR, (String)StringUtils.escapeString((String)EMPTY_STR));
        TestStringUtils.assertEquals((String)STR_WO_SPECIAL_CHARS, (String)StringUtils.escapeString((String)STR_WO_SPECIAL_CHARS));
        TestStringUtils.assertEquals((String)ESCAPED_STR_WITH_COMMA, (String)StringUtils.escapeString((String)STR_WITH_COMMA));
        TestStringUtils.assertEquals((String)ESCAPED_STR_WITH_ESCAPE, (String)StringUtils.escapeString((String)STR_WITH_ESCAPE));
        TestStringUtils.assertEquals((String)ESCAPED_STR_WITH_BOTH2, (String)StringUtils.escapeString((String)STR_WITH_BOTH2));
    }

    public void testSplit() throws Exception {
        TestStringUtils.assertEquals((Object)NULL_STR, (Object)StringUtils.split((String)NULL_STR));
        String[] splits = StringUtils.split((String)EMPTY_STR);
        TestStringUtils.assertEquals((int)0, (int)splits.length);
        splits = StringUtils.split((String)",,");
        TestStringUtils.assertEquals((int)0, (int)splits.length);
        splits = StringUtils.split((String)STR_WO_SPECIAL_CHARS);
        TestStringUtils.assertEquals((int)1, (int)splits.length);
        TestStringUtils.assertEquals((String)STR_WO_SPECIAL_CHARS, (String)splits[0]);
        splits = StringUtils.split((String)STR_WITH_COMMA);
        TestStringUtils.assertEquals((int)2, (int)splits.length);
        TestStringUtils.assertEquals((String)"A", (String)splits[0]);
        TestStringUtils.assertEquals((String)"B", (String)splits[1]);
        splits = StringUtils.split((String)ESCAPED_STR_WITH_COMMA);
        TestStringUtils.assertEquals((int)1, (int)splits.length);
        TestStringUtils.assertEquals((String)ESCAPED_STR_WITH_COMMA, (String)splits[0]);
        splits = StringUtils.split((String)STR_WITH_ESCAPE);
        TestStringUtils.assertEquals((int)1, (int)splits.length);
        TestStringUtils.assertEquals((String)STR_WITH_ESCAPE, (String)splits[0]);
        splits = StringUtils.split((String)STR_WITH_BOTH2);
        TestStringUtils.assertEquals((int)3, (int)splits.length);
        TestStringUtils.assertEquals((String)EMPTY_STR, (String)splits[0]);
        TestStringUtils.assertEquals((String)"A\\,", (String)splits[1]);
        TestStringUtils.assertEquals((String)"B\\\\", (String)splits[2]);
        splits = StringUtils.split((String)ESCAPED_STR_WITH_BOTH2);
        TestStringUtils.assertEquals((int)1, (int)splits.length);
        TestStringUtils.assertEquals((String)ESCAPED_STR_WITH_BOTH2, (String)splits[0]);
    }

    public void testUnescapeString() throws Exception {
        TestStringUtils.assertEquals((String)NULL_STR, (String)StringUtils.unEscapeString((String)NULL_STR));
        TestStringUtils.assertEquals((String)EMPTY_STR, (String)StringUtils.unEscapeString((String)EMPTY_STR));
        TestStringUtils.assertEquals((String)STR_WO_SPECIAL_CHARS, (String)StringUtils.unEscapeString((String)STR_WO_SPECIAL_CHARS));
        try {
            StringUtils.unEscapeString((String)STR_WITH_COMMA);
            TestStringUtils.fail((String)"Should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        TestStringUtils.assertEquals((String)STR_WITH_COMMA, (String)StringUtils.unEscapeString((String)ESCAPED_STR_WITH_COMMA));
        try {
            StringUtils.unEscapeString((String)STR_WITH_ESCAPE);
            TestStringUtils.fail((String)"Should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        TestStringUtils.assertEquals((String)STR_WITH_ESCAPE, (String)StringUtils.unEscapeString((String)ESCAPED_STR_WITH_ESCAPE));
        try {
            StringUtils.unEscapeString((String)STR_WITH_BOTH2);
            TestStringUtils.fail((String)"Should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        TestStringUtils.assertEquals((String)STR_WITH_BOTH2, (String)StringUtils.unEscapeString((String)ESCAPED_STR_WITH_BOTH2));
    }

    public void testTraditionalBinaryPrefix() throws Exception {
        String[] symbol = new String[]{"k", "m", "g", "t", "p", "e"};
        long m = 1024L;
        for (String s : symbol) {
            TestStringUtils.assertEquals((long)0L, (long)StringUtils.TraditionalBinaryPrefix.string2long((String)(0 + s)));
            TestStringUtils.assertEquals((long)m, (long)StringUtils.TraditionalBinaryPrefix.string2long((String)(1 + s)));
            m *= 1024L;
        }
        TestStringUtils.assertEquals((long)0L, (long)StringUtils.TraditionalBinaryPrefix.string2long((String)"0"));
        TestStringUtils.assertEquals((long)-1259520L, (long)StringUtils.TraditionalBinaryPrefix.string2long((String)"-1230k"));
        TestStringUtils.assertEquals((long)956703965184L, (long)StringUtils.TraditionalBinaryPrefix.string2long((String)"891g"));
    }
}

