/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.io.BufferedReader;
import java.io.IOException;
import junit.framework.TestCase;
import org.apache.hadoop.util.Shell;

public class TestShell
extends TestCase {
    public void testInterval() throws IOException {
        this.testInterval(-153722867280912L);
        this.testInterval(0L);
        this.testInterval(10L);
        this.testInterval(System.currentTimeMillis() / 60000L + 60L);
    }

    private void assertInString(String string, String search) {
        TestShell.assertNotNull((String)"Empty String", (Object)string);
        if (!string.contains(search)) {
            TestShell.fail((String)("Did not find \"" + search + "\" in " + string));
        }
    }

    public void testShellCommandExecutorToString() throws Throwable {
        Shell.ShellCommandExecutor sce = new Shell.ShellCommandExecutor(new String[]{"ls", "..", "arg 2"});
        String command = sce.toString();
        this.assertInString(command, "ls");
        this.assertInString(command, " .. ");
        this.assertInString(command, "\"arg 2\"");
    }

    private void testInterval(long interval) throws IOException {
        Command command = new Command(interval);
        command.run();
        TestShell.assertEquals((int)1, (int)command.getRunCount());
        command.run();
        if (interval > 0L) {
            TestShell.assertEquals((int)1, (int)command.getRunCount());
        } else {
            TestShell.assertEquals((int)2, (int)command.getRunCount());
        }
    }

    private static class Command
    extends Shell {
        private int runCount = 0;

        private Command(long interval) {
            super(interval);
        }

        protected String[] getExecString() {
            return new String[]{"echo", "hello"};
        }

        protected void parseExecResult(BufferedReader lines) throws IOException {
            ++this.runCount;
        }

        public int getRunCount() {
            return this.runCount;
        }
    }
}

