/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.ProcfsBasedProcessTree;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.util.StringUtils;

public class TestProcfsBasedProcessTree
extends TestCase {
    private static final Log LOG = LogFactory.getLog(TestProcfsBasedProcessTree.class);
    private static String TEST_ROOT_DIR = new Path(System.getProperty("test.build.data", "/tmp")).toString().replace(' ', '+');
    private Shell.ShellCommandExecutor shexec = null;
    private String pidFile;
    private String shellScript;
    private static final int N = 10;
    private static final int memoryLimit = 0xF00000;
    private static final long PROCESSTREE_RECONSTRUCTION_INTERVAL = 5000L;

    private String getRogueTaskPID() {
        File f = new File(this.pidFile);
        while (!f.exists()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ie) {
                break;
            }
        }
        return ProcfsBasedProcessTree.getPidFromPidFile((String)this.pidFile);
    }

    public void testProcessTree() {
        try {
            if (!ProcfsBasedProcessTree.isAvailable()) {
                System.out.println("ProcfsBasedProcessTree is not available on this system. Not testing");
                return;
            }
        }
        catch (Exception e) {
            LOG.info((Object)StringUtils.stringifyException((Throwable)e));
            return;
        }
        Random rm = new Random();
        File tempFile = new File(this.getName() + "_shellScript_" + rm.nextInt() + ".sh");
        tempFile.deleteOnExit();
        this.shellScript = tempFile.getName();
        tempFile = new File(this.getName() + "_pidFile_" + rm.nextInt() + ".pid");
        tempFile.deleteOnExit();
        this.pidFile = tempFile.getName();
        try {
            FileWriter fWriter = new FileWriter(this.shellScript);
            fWriter.write("# rogue task\nsleep 10\necho hello\nif [ $1 -ne 0 ]\nthen\n sh " + this.shellScript + " $(($1-1))\n" + "fi");
            fWriter.close();
        }
        catch (IOException ioe) {
            LOG.info((Object)("Error: " + ioe));
            return;
        }
        RogueTaskThread t = new RogueTaskThread();
        t.start();
        String pid = this.getRogueTaskPID();
        LOG.info((Object)("Root process pid: " + pid));
        ProcfsBasedProcessTree p = new ProcfsBasedProcessTree(pid);
        p = p.getProcessTree();
        try {
            while (true) {
                LOG.info((Object)("ProcessTree: " + p.toString()));
                long mem = p.getCumulativeVmem();
                LOG.info((Object)("Memory usage: " + mem + "bytes."));
                if (mem > 0xF00000L) {
                    p.destroy();
                    break;
                }
                Thread.sleep(5000L);
                p = p.getProcessTree();
            }
        }
        catch (InterruptedException ie) {
            LOG.info((Object)"Interrupted.");
        }
        TestProcfsBasedProcessTree.assertFalse((String)"ProcessTree must have been gone", (boolean)p.isAlive());
        try {
            t.join(2000L);
            LOG.info((Object)"RogueTaskThread successfully joined.");
        }
        catch (InterruptedException ie) {
            LOG.info((Object)"Interrupted while joining RogueTaskThread.");
        }
        p = p.getProcessTree();
        TestProcfsBasedProcessTree.assertFalse((String)"ProcessTree must have been gone", (boolean)p.isAlive());
        TestProcfsBasedProcessTree.assertTrue((String)("Cumulative vmem for the gone-process is " + p.getCumulativeVmem() + " . It should be zero."), (p.getCumulativeVmem() == 0L ? 1 : 0) != 0);
        TestProcfsBasedProcessTree.assertTrue((boolean)p.toString().equals("[ ]"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testVirtualMemoryForProcessTree() throws IOException {
        String[] pids = new String[]{"100", "200", "300", "400"};
        File procfsRootDir = new File(TEST_ROOT_DIR, "proc");
        try {
            TestProcfsBasedProcessTree.setupProcfsRootDir(procfsRootDir);
            TestProcfsBasedProcessTree.setupPidDirs(procfsRootDir, pids);
            ProcessStatInfo[] procInfos = new ProcessStatInfo[]{new ProcessStatInfo(new String[]{"100", "proc1", "1", "100", "100", "100000"}), new ProcessStatInfo(new String[]{"200", "proc2", "100", "100", "100", "200000"}), new ProcessStatInfo(new String[]{"300", "proc3", "200", "100", "100", "300000"}), new ProcessStatInfo(new String[]{"400", "proc4", "1", "400", "400", "400000"})};
            TestProcfsBasedProcessTree.writeStatFiles(procfsRootDir, pids, procInfos);
            ProcfsBasedProcessTree processTree = new ProcfsBasedProcessTree("100", procfsRootDir.getAbsolutePath());
            processTree.getProcessTree();
            TestProcfsBasedProcessTree.assertEquals((String)"Cumulative memory does not match", (long)Long.parseLong("600000"), (long)processTree.getCumulativeVmem());
        }
        finally {
            FileUtil.fullyDelete((File)procfsRootDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testVMemForOlderProcesses() throws IOException {
        String[] pids = new String[]{"100", "200", "300", "400"};
        File procfsRootDir = new File(TEST_ROOT_DIR, "proc");
        try {
            TestProcfsBasedProcessTree.setupProcfsRootDir(procfsRootDir);
            TestProcfsBasedProcessTree.setupPidDirs(procfsRootDir, pids);
            ProcessStatInfo[] procInfos = new ProcessStatInfo[]{new ProcessStatInfo(new String[]{"100", "proc1", "1", "100", "100", "100000"}), new ProcessStatInfo(new String[]{"200", "proc2", "100", "100", "100", "200000"}), new ProcessStatInfo(new String[]{"300", "proc3", "1", "300", "300", "300000"}), new ProcessStatInfo(new String[]{"400", "proc4", "100", "100", "100", "400000"})};
            TestProcfsBasedProcessTree.writeStatFiles(procfsRootDir, pids, procInfos);
            ProcfsBasedProcessTree processTree = new ProcfsBasedProcessTree("100", procfsRootDir.getAbsolutePath());
            processTree.getProcessTree();
            TestProcfsBasedProcessTree.assertEquals((String)"Cumulative memory does not match", (long)Long.parseLong("700000"), (long)processTree.getCumulativeVmem());
            String[] newPids = new String[]{"500"};
            TestProcfsBasedProcessTree.setupPidDirs(procfsRootDir, newPids);
            ProcessStatInfo[] newProcInfos = new ProcessStatInfo[]{new ProcessStatInfo(new String[]{"500", "proc5", "100", "100", "100", "500000"})};
            TestProcfsBasedProcessTree.writeStatFiles(procfsRootDir, newPids, newProcInfos);
            processTree.getProcessTree();
            TestProcfsBasedProcessTree.assertEquals((String)"Cumulative memory does not include new process", (long)Long.parseLong("1200000"), (long)processTree.getCumulativeVmem());
            TestProcfsBasedProcessTree.assertEquals((String)"Cumulative memory shouldn't have included new process", (long)Long.parseLong("700000"), (long)processTree.getCumulativeVmem(1));
            newPids = new String[]{"600"};
            TestProcfsBasedProcessTree.setupPidDirs(procfsRootDir, newPids);
            newProcInfos = new ProcessStatInfo[]{new ProcessStatInfo(new String[]{"600", "proc6", "100", "100", "100", "600000"})};
            TestProcfsBasedProcessTree.writeStatFiles(procfsRootDir, newPids, newProcInfos);
            processTree.getProcessTree();
            TestProcfsBasedProcessTree.assertEquals((String)"Cumulative memory shouldn't have included new processes", (long)Long.parseLong("700000"), (long)processTree.getCumulativeVmem(2));
            TestProcfsBasedProcessTree.assertEquals((String)"Cumulative memory shouldn't have included new processes", (long)Long.parseLong("1200000"), (long)processTree.getCumulativeVmem(1));
            TestProcfsBasedProcessTree.assertEquals((String)"Getting non-zero vmem for processes older than 3 iterations", (long)0L, (long)processTree.getCumulativeVmem(3));
        }
        finally {
            FileUtil.fullyDelete((File)procfsRootDir);
        }
    }

    public static void setupProcfsRootDir(File procfsRootDir) throws IOException {
        if (procfsRootDir.exists()) {
            TestProcfsBasedProcessTree.assertTrue((boolean)FileUtil.fullyDelete((File)procfsRootDir));
        }
        TestProcfsBasedProcessTree.assertTrue((boolean)procfsRootDir.mkdirs());
    }

    public static void setupPidDirs(File procfsRootDir, String[] pids) throws IOException {
        for (String pid : pids) {
            File pidDir = new File(procfsRootDir, pid);
            pidDir.mkdir();
            if (!pidDir.exists()) {
                throw new IOException("couldn't make process directory under fake procfs");
            }
            LOG.info((Object)"created pid dir");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeStatFiles(File procfsRootDir, String[] pids, ProcessStatInfo[] procs) throws IOException {
        for (int i = 0; i < pids.length; ++i) {
            File statFile = new File(new File(procfsRootDir, pids[i]), "stat");
            BufferedWriter bw = null;
            try {
                FileWriter fw = new FileWriter(statFile);
                bw = new BufferedWriter(fw);
                bw.write(procs[i].getStatLine());
                LOG.info((Object)("wrote stat file for " + pids[i] + " with contents: " + procs[i].getStatLine()));
                continue;
            }
            finally {
                if (bw != null) {
                    bw.close();
                }
            }
        }
    }

    public static class ProcessStatInfo {
        String pid;
        String name;
        String ppid;
        String pgrpId;
        String session;
        String vmem;

        public ProcessStatInfo(String[] statEntries) {
            this.pid = statEntries[0];
            this.name = statEntries[1];
            this.ppid = statEntries[2];
            this.pgrpId = statEntries[3];
            this.session = statEntries[4];
            this.vmem = statEntries[5];
        }

        public String getStatLine() {
            return String.format("%s (%s) S %s %s %s 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 %s 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0", this.pid, this.name, this.ppid, this.pgrpId, this.session, this.vmem);
        }
    }

    private class RogueTaskThread
    extends Thread {
        private RogueTaskThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                String[] args = new String[]{"bash", "-c", "echo $$ > " + TestProcfsBasedProcessTree.this.pidFile + "; sh " + TestProcfsBasedProcessTree.this.shellScript + " " + 10 + ";"};
                TestProcfsBasedProcessTree.this.shexec = new Shell.ShellCommandExecutor(args);
                TestProcfsBasedProcessTree.this.shexec.execute();
            }
            catch (Shell.ExitCodeException ee) {
                LOG.info((Object)("Shell Command exit with a non-zero exit code. " + (Object)((Object)ee)));
            }
            catch (IOException ioe) {
                LOG.info((Object)("Error executing shell command " + ioe));
            }
            finally {
                LOG.info((Object)("Exit code: " + TestProcfsBasedProcessTree.this.shexec.getExitCode()));
            }
        }
    }
}

