/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileOutputCommitter;
import org.apache.hadoop.mapred.HadoopTestCase;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.TaskAttemptContext;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.UtilsForTests;

public class TestTaskCommit
extends HadoopTestCase {
    public TestTaskCommit() throws IOException {
        super(1, 4, 1, 1);
    }

    public void testCommitFail() throws IOException {
        Path rootDir = new Path(System.getProperty("test.build.data", "/tmp"), "test");
        Path inDir = new Path(rootDir, "input");
        Path outDir = new Path(rootDir, "output");
        JobConf jobConf = this.createJobConf();
        jobConf.setMaxMapAttempts(1);
        jobConf.setOutputCommitter(CommitterWithCommitFail.class);
        RunningJob rJob = UtilsForTests.runJob(jobConf, inDir, outDir, 1, 0);
        rJob.waitForCompletion();
        TestTaskCommit.assertEquals((int)3, (int)rJob.getJobState());
    }

    public static void main(String[] argv) throws Exception {
        TestTaskCommit td = new TestTaskCommit();
        td.testCommitFail();
    }

    static class CommitterWithCommitFail
    extends FileOutputCommitter {
        CommitterWithCommitFail() {
        }

        public void commitTask(TaskAttemptContext context) throws IOException {
            FileSystem fs;
            Path taskOutputPath = this.getTempTaskOutputPath(context);
            TaskAttemptID attemptId = context.getTaskAttemptID();
            JobConf job = context.getJobConf();
            if (taskOutputPath != null && (fs = taskOutputPath.getFileSystem((Configuration)job)).exists(taskOutputPath)) {
                throw new IOException();
            }
        }
    }
}

