/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.loadGenerator;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.loadGenerator.DataGenerator;
import org.apache.hadoop.fs.loadGenerator.LoadGenerator;
import org.apache.hadoop.fs.loadGenerator.StructureGenerator;
import org.apache.hadoop.hdfs.MiniDFSCluster;

public class TestLoadGenerator
extends TestCase {
    private static final Configuration CONF = new Configuration();
    private static final int DEFAULT_BLOCK_SIZE = 10;
    private static final String OUT_DIR = System.getProperty("test.build.data", "build/test/data");
    private static final File DIR_STRUCTURE_FILE = new File(OUT_DIR, "dirStructure");
    private static final File FILE_STRUCTURE_FILE = new File(OUT_DIR, "fileStructure");
    private static final String DIR_STRUCTURE_FIRST_LINE = "/dir0";
    private static final String DIR_STRUCTURE_SECOND_LINE = "/dir1";
    private static final String FILE_STRUCTURE_FIRST_LINE = "/dir0/_file_0 0.3754598635933768";
    private static final String FILE_STRUCTURE_SECOND_LINE = "/dir1/_file_1 1.4729310851145203";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStructureGenerator() throws Exception {
        StructureGenerator sg = new StructureGenerator();
        String[] args = new String[]{"-maxDepth", "2", "-minWidth", "1", "-maxWidth", "2", "-numOfFiles", "2", "-avgFileSize", "1", "-outDir", OUT_DIR, "-seed", "1"};
        boolean MAX_DEPTH = true;
        int MIN_WIDTH = 3;
        int MAX_WIDTH = 5;
        int NUM_OF_FILES = 7;
        int AVG_FILE_SIZE = 9;
        int SEED = 13;
        try {
            TestLoadGenerator.assertEquals((int)0, (int)sg.run(args));
            BufferedReader in = new BufferedReader(new FileReader(DIR_STRUCTURE_FILE));
            TestLoadGenerator.assertEquals((String)DIR_STRUCTURE_FIRST_LINE, (String)in.readLine());
            TestLoadGenerator.assertEquals((String)DIR_STRUCTURE_SECOND_LINE, (String)in.readLine());
            TestLoadGenerator.assertEquals(null, (String)in.readLine());
            in.close();
            in = new BufferedReader(new FileReader(FILE_STRUCTURE_FILE));
            TestLoadGenerator.assertEquals((String)FILE_STRUCTURE_FIRST_LINE, (String)in.readLine());
            TestLoadGenerator.assertEquals((String)FILE_STRUCTURE_SECOND_LINE, (String)in.readLine());
            TestLoadGenerator.assertEquals(null, (String)in.readLine());
            in.close();
            String oldArg = args[1];
            args[1] = "0";
            TestLoadGenerator.assertEquals((int)-1, (int)sg.run(args));
            args[1] = oldArg;
            oldArg = args[3];
            args[3] = "-1";
            TestLoadGenerator.assertEquals((int)-1, (int)sg.run(args));
            args[3] = oldArg;
            oldArg = args[5];
            args[5] = "-1";
            TestLoadGenerator.assertEquals((int)-1, (int)sg.run(args));
            args[5] = oldArg;
            oldArg = args[7];
            args[7] = "-1";
            TestLoadGenerator.assertEquals((int)-1, (int)sg.run(args));
            args[7] = oldArg;
            oldArg = args[7];
            args[7] = "-1";
            TestLoadGenerator.assertEquals((int)-1, (int)sg.run(args));
            args[7] = oldArg;
            oldArg = args[9];
            args[9] = "-1";
            TestLoadGenerator.assertEquals((int)-1, (int)sg.run(args));
            args[9] = oldArg;
            oldArg = args[13];
            args[13] = "34.d4";
            TestLoadGenerator.assertEquals((int)-1, (int)sg.run(args));
            args[13] = oldArg;
        }
        finally {
            DIR_STRUCTURE_FILE.delete();
            FILE_STRUCTURE_FILE.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLoadGenerator() throws Exception {
        String TEST_SPACE_ROOT = "/test";
        FileWriter writer = new FileWriter(DIR_STRUCTURE_FILE);
        writer.write("/dir0\n");
        writer.write("/dir1\n");
        writer.close();
        writer = new FileWriter(FILE_STRUCTURE_FILE);
        writer.write("/dir0/_file_0 0.3754598635933768\n");
        writer.write("/dir1/_file_1 1.4729310851145203\n");
        writer.close();
        MiniDFSCluster cluster = new MiniDFSCluster(CONF, 3, true, null);
        cluster.waitActive();
        try {
            DataGenerator dg = new DataGenerator();
            dg.setConf(CONF);
            String[] args = new String[]{"-inDir", OUT_DIR, "-root", "/test"};
            TestLoadGenerator.assertEquals((int)0, (int)dg.run(args));
            boolean READ_PROBABILITY = true;
            int WRITE_PROBABILITY = 3;
            int MAX_DELAY_BETWEEN_OPS = 7;
            int NUM_OF_THREADS = 9;
            int START_TIME = 11;
            int ELAPSED_TIME = 13;
            LoadGenerator lg = new LoadGenerator();
            lg.setConf(CONF);
            args = new String[]{"-readProbability", "0.3", "-writeProbability", "0.3", "-root", "/test", "-maxDelayBetweenOps", "0", "-numOfThreads", "1", "-startTime", Long.toString(System.currentTimeMillis()), "-elapsedTime", "10"};
            TestLoadGenerator.assertEquals((int)0, (int)lg.run(args));
            String oldArg = args[1];
            args[1] = "1.1";
            TestLoadGenerator.assertEquals((int)-1, (int)lg.run(args));
            args[1] = "-1.1";
            TestLoadGenerator.assertEquals((int)-1, (int)lg.run(args));
            args[1] = oldArg;
            oldArg = args[3];
            args[3] = "1.1";
            TestLoadGenerator.assertEquals((int)-1, (int)lg.run(args));
            args[3] = "-1.1";
            TestLoadGenerator.assertEquals((int)-1, (int)lg.run(args));
            args[3] = "0.9";
            TestLoadGenerator.assertEquals((int)-1, (int)lg.run(args));
            args[1] = oldArg;
            oldArg = args[7];
            args[7] = "1.x1";
            TestLoadGenerator.assertEquals((int)-1, (int)lg.run(args));
            args[7] = oldArg;
            oldArg = args[7];
            args[7] = "1.x1";
            TestLoadGenerator.assertEquals((int)-1, (int)lg.run(args));
            args[7] = oldArg;
            oldArg = args[9];
            args[9] = "-1";
            TestLoadGenerator.assertEquals((int)-1, (int)lg.run(args));
            args[9] = oldArg;
            oldArg = args[11];
            args[11] = "-1";
            TestLoadGenerator.assertEquals((int)-1, (int)lg.run(args));
            args[11] = oldArg;
            oldArg = args[13];
            args[13] = "-1";
            TestLoadGenerator.assertEquals((int)-1, (int)lg.run(args));
            args[13] = oldArg;
        }
        finally {
            cluster.shutdown();
            DIR_STRUCTURE_FILE.delete();
            FILE_STRUCTURE_FILE.delete();
        }
    }

    public static void main(String[] args) throws Exception {
        TestLoadGenerator loadGeneratorTest = new TestLoadGenerator();
        loadGeneratorTest.testStructureGenerator();
        loadGeneratorTest.testLoadGenerator();
    }

    static {
        CONF.setLong("dfs.block.size", 10L);
        CONF.setInt("io.bytes.per.checksum", 10);
        CONF.setLong("dfs.heartbeat.interval", 1L);
    }
}

