/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import junit.framework.TestCase;
import org.apache.hadoop.fs.Path;

public class TestPath
extends TestCase {
    public void testToString() {
        this.toStringTest("/");
        this.toStringTest("/foo");
        this.toStringTest("/foo/bar");
        this.toStringTest("foo");
        this.toStringTest("foo/bar");
        boolean emptyException = false;
        try {
            this.toStringTest("");
        }
        catch (IllegalArgumentException e) {
            emptyException = true;
        }
        TestPath.assertTrue((boolean)emptyException);
        if (Path.WINDOWS) {
            this.toStringTest("c:");
            this.toStringTest("c:/");
            this.toStringTest("c:foo");
            this.toStringTest("c:foo/bar");
            this.toStringTest("c:foo/bar");
            this.toStringTest("c:/foo/bar");
        }
    }

    private void toStringTest(String pathString) {
        TestPath.assertEquals((String)pathString, (String)new Path(pathString).toString());
    }

    public void testNormalize() {
        TestPath.assertEquals((String)"/", (String)new Path("//").toString());
        TestPath.assertEquals((String)"/foo", (String)new Path("/foo/").toString());
        TestPath.assertEquals((String)"/foo", (String)new Path("/foo/").toString());
        TestPath.assertEquals((String)"foo", (String)new Path("foo/").toString());
        TestPath.assertEquals((String)"foo", (String)new Path("foo//").toString());
        TestPath.assertEquals((String)"foo/bar", (String)new Path("foo//bar").toString());
        if (Path.WINDOWS) {
            TestPath.assertEquals((String)"c:/a/b", (String)new Path("c:\\a\\b").toString());
        }
    }

    public void testIsAbsolute() {
        TestPath.assertTrue((boolean)new Path("/").isAbsolute());
        TestPath.assertTrue((boolean)new Path("/foo").isAbsolute());
        TestPath.assertFalse((boolean)new Path("foo").isAbsolute());
        TestPath.assertFalse((boolean)new Path("foo/bar").isAbsolute());
        TestPath.assertFalse((boolean)new Path(".").isAbsolute());
        if (Path.WINDOWS) {
            TestPath.assertTrue((boolean)new Path("c:/a/b").isAbsolute());
            TestPath.assertFalse((boolean)new Path("c:a/b").isAbsolute());
        }
    }

    public void testParent() {
        TestPath.assertEquals((Object)new Path("/foo"), (Object)new Path("/foo/bar").getParent());
        TestPath.assertEquals((Object)new Path("foo"), (Object)new Path("foo/bar").getParent());
        TestPath.assertEquals((Object)new Path("/"), (Object)new Path("/foo").getParent());
        if (Path.WINDOWS) {
            TestPath.assertEquals((Object)new Path("c:/"), (Object)new Path("c:/foo").getParent());
        }
    }

    public void testChild() {
        TestPath.assertEquals((Object)new Path("."), (Object)new Path(".", "."));
        TestPath.assertEquals((Object)new Path("/"), (Object)new Path("/", "."));
        TestPath.assertEquals((Object)new Path("/"), (Object)new Path(".", "/"));
        TestPath.assertEquals((Object)new Path("/foo"), (Object)new Path("/", "foo"));
        TestPath.assertEquals((Object)new Path("/foo/bar"), (Object)new Path("/foo", "bar"));
        TestPath.assertEquals((Object)new Path("/foo/bar/baz"), (Object)new Path("/foo/bar", "baz"));
        TestPath.assertEquals((Object)new Path("/foo/bar/baz"), (Object)new Path("/foo", "bar/baz"));
        TestPath.assertEquals((Object)new Path("foo"), (Object)new Path(".", "foo"));
        TestPath.assertEquals((Object)new Path("foo/bar"), (Object)new Path("foo", "bar"));
        TestPath.assertEquals((Object)new Path("foo/bar/baz"), (Object)new Path("foo", "bar/baz"));
        TestPath.assertEquals((Object)new Path("foo/bar/baz"), (Object)new Path("foo/bar", "baz"));
        TestPath.assertEquals((Object)new Path("/foo"), (Object)new Path("/bar", "/foo"));
        if (Path.WINDOWS) {
            TestPath.assertEquals((Object)new Path("c:/foo"), (Object)new Path("/bar", "c:/foo"));
            TestPath.assertEquals((Object)new Path("c:/foo"), (Object)new Path("d:/bar", "c:/foo"));
        }
    }

    public void testEquals() {
        TestPath.assertFalse((boolean)new Path("/").equals((Object)new Path("/foo")));
    }

    public void testDots() {
        TestPath.assertEquals((String)new Path("/foo/bar/baz").toString(), (String)"/foo/bar/baz");
        TestPath.assertEquals((String)new Path("/foo/bar", ".").toString(), (String)"/foo/bar");
        TestPath.assertEquals((String)new Path("/foo/bar/../baz").toString(), (String)"/foo/baz");
        TestPath.assertEquals((String)new Path("/foo/bar/./baz").toString(), (String)"/foo/bar/baz");
        TestPath.assertEquals((String)new Path("/foo/bar/baz/../../fud").toString(), (String)"/foo/fud");
        TestPath.assertEquals((String)new Path("/foo/bar/baz/.././../fud").toString(), (String)"/foo/fud");
        TestPath.assertEquals((String)new Path("../../foo/bar").toString(), (String)"../../foo/bar");
        TestPath.assertEquals((String)new Path(".././../foo/bar").toString(), (String)"../../foo/bar");
        TestPath.assertEquals((String)new Path("./foo/bar/baz").toString(), (String)"foo/bar/baz");
        TestPath.assertEquals((String)new Path("/foo/bar/../../baz/boo").toString(), (String)"/baz/boo");
        TestPath.assertEquals((String)new Path("foo/bar/").toString(), (String)"foo/bar");
        TestPath.assertEquals((String)new Path("foo/bar/../baz").toString(), (String)"foo/baz");
        TestPath.assertEquals((String)new Path("foo/bar/../../baz/boo").toString(), (String)"baz/boo");
        TestPath.assertEquals((String)new Path("/foo/bar", "baz/boo").toString(), (String)"/foo/bar/baz/boo");
        TestPath.assertEquals((String)new Path("foo/bar/", "baz/bud").toString(), (String)"foo/bar/baz/bud");
        TestPath.assertEquals((String)new Path("/foo/bar", "../../boo/bud").toString(), (String)"/boo/bud");
        TestPath.assertEquals((String)new Path("foo/bar", "../../boo/bud").toString(), (String)"boo/bud");
        TestPath.assertEquals((String)new Path(".", "boo/bud").toString(), (String)"boo/bud");
        TestPath.assertEquals((String)new Path("/foo/bar/baz", "../../boo/bud").toString(), (String)"/foo/boo/bud");
        TestPath.assertEquals((String)new Path("foo/bar/baz", "../../boo/bud").toString(), (String)"foo/boo/bud");
        TestPath.assertEquals((String)new Path("../../", "../../boo/bud").toString(), (String)"../../../../boo/bud");
        TestPath.assertEquals((String)new Path("../../foo", "../../../boo/bud").toString(), (String)"../../../../boo/bud");
        TestPath.assertEquals((String)new Path("../../foo/bar", "../boo/bud").toString(), (String)"../../foo/boo/bud");
        TestPath.assertEquals((String)new Path("foo/bar/baz", "../../..").toString(), (String)"");
        TestPath.assertEquals((String)new Path("foo/bar/baz", "../../../../..").toString(), (String)"../..");
    }

    public void testScheme() throws IOException {
        TestPath.assertEquals((String)"foo:/bar", (String)new Path("foo:/", "/bar").toString());
        TestPath.assertEquals((String)"foo://bar/baz", (String)new Path("foo://bar/", "/baz").toString());
    }
}

