/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Random;
import java.util.StringTokenizer;
import junit.framework.TestCase;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.security.UnixUserGroupInformation;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.tools.DistCp;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Level;

public class TestCopyFiles
extends TestCase {
    static final URI LOCAL_FS = URI.create("file:///");
    private static final Random RAN = new Random();
    private static final int NFILES = 20;
    private static String TEST_ROOT_DIR = new Path(System.getProperty("test.build.data", "/tmp")).toString().replace(' ', '+');
    static final long now = System.currentTimeMillis();

    public TestCopyFiles() {
        ((Log4JLogger)LogFactory.getLog((String)"org.apache.hadoop.hdfs.StateChange")).getLogger().setLevel(Level.OFF);
        ((Log4JLogger)DataNode.LOG).getLogger().setLevel(Level.OFF);
        ((Log4JLogger)FSNamesystem.LOG).getLogger().setLevel(Level.OFF);
        ((Log4JLogger)DistCp.LOG).getLogger().setLevel(Level.ALL);
    }

    private static MyFile[] createFiles(URI fsname, String topdir) throws IOException {
        return TestCopyFiles.createFiles(FileSystem.get((URI)fsname, (Configuration)new Configuration()), topdir);
    }

    private static MyFile[] createFiles(FileSystem fs, String topdir) throws IOException {
        Path root = new Path(topdir);
        MyFile[] files = new MyFile[20];
        for (int i = 0; i < 20; ++i) {
            files[i] = TestCopyFiles.createFile(root, fs);
        }
        return files;
    }

    static MyFile createFile(Path root, FileSystem fs, int levels) throws IOException {
        MyFile f = levels < 0 ? new MyFile() : new MyFile(levels);
        Path p = new Path(root, f.getName());
        FSDataOutputStream out = fs.create(p);
        byte[] toWrite = new byte[f.getSize()];
        new Random(f.getSeed()).nextBytes(toWrite);
        out.write(toWrite);
        out.close();
        FileSystem.LOG.info((Object)("created: " + p + ", size=" + f.getSize()));
        return f;
    }

    static MyFile createFile(Path root, FileSystem fs) throws IOException {
        return TestCopyFiles.createFile(root, fs, -1);
    }

    private static boolean checkFiles(FileSystem fs, String topdir, MyFile[] files) throws IOException {
        return TestCopyFiles.checkFiles(fs, topdir, files, false);
    }

    private static boolean checkFiles(FileSystem fs, String topdir, MyFile[] files, boolean existingOnly) throws IOException {
        Path root = new Path(topdir);
        for (int idx = 0; idx < files.length; ++idx) {
            Path fPath = new Path(root, files[idx].getName());
            try {
                fs.getFileStatus(fPath);
                FSDataInputStream in = fs.open(fPath);
                byte[] toRead = new byte[files[idx].getSize()];
                byte[] toCompare = new byte[files[idx].getSize()];
                Random rb = new Random(files[idx].getSeed());
                rb.nextBytes(toCompare);
                TestCopyFiles.assertEquals((String)"Cannnot read file.", (int)toRead.length, (int)in.read(toRead));
                in.close();
                for (int i = 0; i < toRead.length; ++i) {
                    if (toRead[i] == toCompare[i]) continue;
                    return false;
                }
                toRead = null;
                toCompare = null;
                continue;
            }
            catch (FileNotFoundException fnfe) {
                if (existingOnly) continue;
                throw fnfe;
            }
        }
        return true;
    }

    private static void updateFiles(FileSystem fs, String topdir, MyFile[] files, int nupdate) throws IOException {
        assert (nupdate <= 20);
        Path root = new Path(topdir);
        for (int idx = 0; idx < nupdate; ++idx) {
            Path fPath = new Path(root, files[idx].getName());
            TestCopyFiles.assertTrue((String)(fPath.toString() + " does not exist"), (boolean)fs.exists(fPath));
            FSDataOutputStream out = fs.create(fPath);
            files[idx].reset();
            byte[] toWrite = new byte[files[idx].getSize()];
            Random rb = new Random(files[idx].getSeed());
            rb.nextBytes(toWrite);
            out.write(toWrite);
            out.close();
        }
    }

    private static FileStatus[] getFileStatus(FileSystem fs, String topdir, MyFile[] files) throws IOException {
        return TestCopyFiles.getFileStatus(fs, topdir, files, false);
    }

    private static FileStatus[] getFileStatus(FileSystem fs, String topdir, MyFile[] files, boolean existingOnly) throws IOException {
        Path root = new Path(topdir);
        ArrayList<FileStatus> statuses = new ArrayList<FileStatus>();
        for (int idx = 0; idx < 20; ++idx) {
            try {
                statuses.add(fs.getFileStatus(new Path(root, files[idx].getName())));
                continue;
            }
            catch (FileNotFoundException fnfe) {
                if (existingOnly) continue;
                throw fnfe;
            }
        }
        return statuses.toArray(new FileStatus[statuses.size()]);
    }

    private static boolean checkUpdate(FileSystem fs, FileStatus[] old, String topdir, MyFile[] upd, int nupdate) throws IOException {
        FileStatus stat;
        int idx;
        Path root = new Path(topdir);
        for (idx = 0; idx < nupdate; ++idx) {
            stat = fs.getFileStatus(new Path(root, upd[idx].getName()));
            if (stat.getModificationTime() > old[idx].getModificationTime()) continue;
            return false;
        }
        for (idx = nupdate; idx < 20; ++idx) {
            stat = fs.getFileStatus(new Path(root, upd[idx].getName()));
            if (stat.getModificationTime() == old[idx].getModificationTime()) continue;
            return false;
        }
        return true;
    }

    private static void deldir(FileSystem fs, String topdir) throws IOException {
        fs.delete(new Path(topdir), true);
    }

    public void testCopyFromLocalToLocal() throws Exception {
        Configuration conf = new Configuration();
        FileSystem localfs = FileSystem.get((URI)LOCAL_FS, (Configuration)conf);
        MyFile[] files = TestCopyFiles.createFiles(LOCAL_FS, TEST_ROOT_DIR + "/srcdat");
        ToolRunner.run((Tool)new DistCp(new Configuration()), (String[])new String[]{"file:///" + TEST_ROOT_DIR + "/srcdat", "file:///" + TEST_ROOT_DIR + "/destdat"});
        TestCopyFiles.assertTrue((String)"Source and destination directories do not match.", (boolean)TestCopyFiles.checkFiles(localfs, TEST_ROOT_DIR + "/destdat", files));
        TestCopyFiles.deldir(localfs, TEST_ROOT_DIR + "/destdat");
        TestCopyFiles.deldir(localfs, TEST_ROOT_DIR + "/srcdat");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCopyFromDfsToDfs() throws Exception {
        String namenode = null;
        MiniDFSCluster cluster = null;
        try {
            Configuration conf = new Configuration();
            cluster = new MiniDFSCluster(conf, 2, true, null);
            FileSystem hdfs = cluster.getFileSystem();
            namenode = FileSystem.getDefaultUri((Configuration)conf).toString();
            if (namenode.startsWith("hdfs://")) {
                MyFile[] files = TestCopyFiles.createFiles(URI.create(namenode), "/srcdat");
                ToolRunner.run((Tool)new DistCp(conf), (String[])new String[]{"-log", namenode + "/logs", namenode + "/srcdat", namenode + "/destdat"});
                TestCopyFiles.assertTrue((String)"Source and destination directories do not match.", (boolean)TestCopyFiles.checkFiles(hdfs, "/destdat", files));
                FileSystem fs = FileSystem.get((URI)URI.create(namenode + "/logs"), (Configuration)conf);
                TestCopyFiles.assertTrue((String)"Log directory does not exist.", (boolean)fs.exists(new Path(namenode + "/logs")));
                TestCopyFiles.deldir(hdfs, "/destdat");
                TestCopyFiles.deldir(hdfs, "/srcdat");
                TestCopyFiles.deldir(hdfs, "/logs");
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCopyFromLocalToDfs() throws Exception {
        MiniDFSCluster cluster = null;
        try {
            Configuration conf = new Configuration();
            cluster = new MiniDFSCluster(conf, 1, true, null);
            FileSystem hdfs = cluster.getFileSystem();
            String namenode = hdfs.getUri().toString();
            if (namenode.startsWith("hdfs://")) {
                MyFile[] files = TestCopyFiles.createFiles(LOCAL_FS, TEST_ROOT_DIR + "/srcdat");
                ToolRunner.run((Tool)new DistCp(conf), (String[])new String[]{"-log", namenode + "/logs", "file:///" + TEST_ROOT_DIR + "/srcdat", namenode + "/destdat"});
                TestCopyFiles.assertTrue((String)"Source and destination directories do not match.", (boolean)TestCopyFiles.checkFiles(cluster.getFileSystem(), "/destdat", files));
                TestCopyFiles.assertTrue((String)"Log directory does not exist.", (boolean)hdfs.exists(new Path(namenode + "/logs")));
                TestCopyFiles.deldir(hdfs, "/destdat");
                TestCopyFiles.deldir(hdfs, "/logs");
                TestCopyFiles.deldir(FileSystem.get((URI)LOCAL_FS, (Configuration)conf), TEST_ROOT_DIR + "/srcdat");
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCopyFromDfsToLocal() throws Exception {
        MiniDFSCluster cluster = null;
        try {
            Configuration conf = new Configuration();
            FileSystem localfs = FileSystem.get((URI)LOCAL_FS, (Configuration)conf);
            cluster = new MiniDFSCluster(conf, 1, true, null);
            FileSystem hdfs = cluster.getFileSystem();
            String namenode = FileSystem.getDefaultUri((Configuration)conf).toString();
            if (namenode.startsWith("hdfs://")) {
                MyFile[] files = TestCopyFiles.createFiles(URI.create(namenode), "/srcdat");
                ToolRunner.run((Tool)new DistCp(conf), (String[])new String[]{"-log", "/logs", namenode + "/srcdat", "file:///" + TEST_ROOT_DIR + "/destdat"});
                TestCopyFiles.assertTrue((String)"Source and destination directories do not match.", (boolean)TestCopyFiles.checkFiles(localfs, TEST_ROOT_DIR + "/destdat", files));
                TestCopyFiles.assertTrue((String)"Log directory does not exist.", (boolean)hdfs.exists(new Path("/logs")));
                TestCopyFiles.deldir(localfs, TEST_ROOT_DIR + "/destdat");
                TestCopyFiles.deldir(hdfs, "/logs");
                TestCopyFiles.deldir(hdfs, "/srcdat");
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCopyDfsToDfsUpdateOverwrite() throws Exception {
        MiniDFSCluster cluster = null;
        try {
            Configuration conf = new Configuration();
            cluster = new MiniDFSCluster(conf, 2, true, null);
            FileSystem hdfs = cluster.getFileSystem();
            String namenode = hdfs.getUri().toString();
            if (namenode.startsWith("hdfs://")) {
                MyFile[] files = TestCopyFiles.createFiles(URI.create(namenode), "/srcdat");
                ToolRunner.run((Tool)new DistCp(conf), (String[])new String[]{"-p", "-log", namenode + "/logs", namenode + "/srcdat", namenode + "/destdat"});
                TestCopyFiles.assertTrue((String)"Source and destination directories do not match.", (boolean)TestCopyFiles.checkFiles(hdfs, "/destdat", files));
                FileSystem fs = FileSystem.get((URI)URI.create(namenode + "/logs"), (Configuration)conf);
                TestCopyFiles.assertTrue((String)"Log directory does not exist.", (boolean)fs.exists(new Path(namenode + "/logs")));
                FileStatus[] dchkpoint = TestCopyFiles.getFileStatus(hdfs, "/destdat", files);
                int nupdate = 5;
                TestCopyFiles.updateFiles(cluster.getFileSystem(), "/srcdat", files, 5);
                TestCopyFiles.deldir(hdfs, "/logs");
                ToolRunner.run((Tool)new DistCp(conf), (String[])new String[]{"-p", "-update", "-log", namenode + "/logs", namenode + "/srcdat", namenode + "/destdat"});
                TestCopyFiles.assertTrue((String)"Source and destination directories do not match.", (boolean)TestCopyFiles.checkFiles(hdfs, "/destdat", files));
                TestCopyFiles.assertTrue((String)"Update failed to replicate all changes in src", (boolean)TestCopyFiles.checkUpdate(hdfs, dchkpoint, "/destdat", files, 5));
                TestCopyFiles.deldir(hdfs, "/logs");
                ToolRunner.run((Tool)new DistCp(conf), (String[])new String[]{"-p", "-overwrite", "-log", namenode + "/logs", namenode + "/srcdat", namenode + "/destdat"});
                TestCopyFiles.assertTrue((String)"Source and destination directories do not match.", (boolean)TestCopyFiles.checkFiles(hdfs, "/destdat", files));
                TestCopyFiles.assertTrue((String)"-overwrite didn't.", (boolean)TestCopyFiles.checkUpdate(hdfs, dchkpoint, "/destdat", files, 20));
                TestCopyFiles.deldir(hdfs, "/destdat");
                TestCopyFiles.deldir(hdfs, "/srcdat");
                TestCopyFiles.deldir(hdfs, "/logs");
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCopyDuplication() throws Exception {
        FileSystem localfs = FileSystem.get((URI)LOCAL_FS, (Configuration)new Configuration());
        try {
            MyFile[] files = TestCopyFiles.createFiles(localfs, TEST_ROOT_DIR + "/srcdat");
            ToolRunner.run((Tool)new DistCp(new Configuration()), (String[])new String[]{"file:///" + TEST_ROOT_DIR + "/srcdat", "file:///" + TEST_ROOT_DIR + "/src2/srcdat"});
            TestCopyFiles.assertTrue((String)"Source and destination directories do not match.", (boolean)TestCopyFiles.checkFiles(localfs, TEST_ROOT_DIR + "/src2/srcdat", files));
            TestCopyFiles.assertEquals((int)-2, (int)ToolRunner.run((Tool)new DistCp(new Configuration()), (String[])new String[]{"file:///" + TEST_ROOT_DIR + "/srcdat", "file:///" + TEST_ROOT_DIR + "/src2/srcdat", "file:///" + TEST_ROOT_DIR + "/destdat"}));
        }
        finally {
            TestCopyFiles.deldir(localfs, TEST_ROOT_DIR + "/destdat");
            TestCopyFiles.deldir(localfs, TEST_ROOT_DIR + "/srcdat");
            TestCopyFiles.deldir(localfs, TEST_ROOT_DIR + "/src2");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCopySingleFile() throws Exception {
        FileSystem fs = FileSystem.get((URI)LOCAL_FS, (Configuration)new Configuration());
        Path root = new Path(TEST_ROOT_DIR + "/srcdat");
        try {
            MyFile[] files = new MyFile[]{TestCopyFiles.createFile(root, fs)};
            ToolRunner.run((Tool)new DistCp(new Configuration()), (String[])new String[]{"file:///" + TEST_ROOT_DIR + "/srcdat", "file:///" + TEST_ROOT_DIR + "/destdat"});
            TestCopyFiles.assertTrue((String)"Source and destination directories do not match.", (boolean)TestCopyFiles.checkFiles(fs, TEST_ROOT_DIR + "/destdat", files));
            String fname = files[0].getName();
            Path p = new Path(root, fname);
            FileSystem.LOG.info((Object)("fname=" + fname + ", exists? " + fs.exists(p)));
            ToolRunner.run((Tool)new DistCp(new Configuration()), (String[])new String[]{"file:///" + TEST_ROOT_DIR + "/srcdat/" + fname, "file:///" + TEST_ROOT_DIR + "/dest2/" + fname});
            TestCopyFiles.assertTrue((String)"Source and destination directories do not match.", (boolean)TestCopyFiles.checkFiles(fs, TEST_ROOT_DIR + "/dest2", files));
            TestCopyFiles.deldir(fs, TEST_ROOT_DIR + "/dest2");
            fs.mkdirs(new Path(TEST_ROOT_DIR + "/dest2"));
            MyFile[] files2 = new MyFile[]{TestCopyFiles.createFile(root, fs, 0)};
            String sname = files2[0].getName();
            ToolRunner.run((Tool)new DistCp(new Configuration()), (String[])new String[]{"-update", "file:///" + TEST_ROOT_DIR + "/srcdat/" + sname, "file:///" + TEST_ROOT_DIR + "/dest2/"});
            TestCopyFiles.assertTrue((String)"Source and destination directories do not match.", (boolean)TestCopyFiles.checkFiles(fs, TEST_ROOT_DIR + "/dest2", files2));
            TestCopyFiles.updateFiles(fs, TEST_ROOT_DIR + "/srcdat", files2, 1);
            ToolRunner.run((Tool)new DistCp(new Configuration()), (String[])new String[]{"-update", "file:///" + TEST_ROOT_DIR + "/srcdat/" + sname, "file:///" + TEST_ROOT_DIR + "/dest2/"});
            TestCopyFiles.assertTrue((String)"Source and destination directories do not match.", (boolean)TestCopyFiles.checkFiles(fs, TEST_ROOT_DIR + "/dest2", files2));
        }
        finally {
            TestCopyFiles.deldir(fs, TEST_ROOT_DIR + "/destdat");
            TestCopyFiles.deldir(fs, TEST_ROOT_DIR + "/dest2");
            TestCopyFiles.deldir(fs, TEST_ROOT_DIR + "/srcdat");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPreserveOption() throws Exception {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = null;
        try {
            int i;
            cluster = new MiniDFSCluster(conf, 2, true, null);
            String nnUri = FileSystem.getDefaultUri((Configuration)conf).toString();
            FileSystem fs = FileSystem.get((URI)URI.create(nnUri), (Configuration)conf);
            MyFile[] files = TestCopyFiles.createFiles(URI.create(nnUri), "/srcdat");
            FileStatus[] srcstat = TestCopyFiles.getFileStatus(fs, "/srcdat", files);
            for (int i2 = 0; i2 < srcstat.length; ++i2) {
                fs.setOwner(srcstat[i2].getPath(), "u" + i2, null);
            }
            ToolRunner.run((Tool)new DistCp(conf), (String[])new String[]{"-pu", nnUri + "/srcdat", nnUri + "/destdat"});
            TestCopyFiles.assertTrue((String)"Source and destination directories do not match.", (boolean)TestCopyFiles.checkFiles(fs, "/destdat", files));
            FileStatus[] dststat = TestCopyFiles.getFileStatus(fs, "/destdat", files);
            for (i = 0; i < dststat.length; ++i) {
                TestCopyFiles.assertEquals((String)("i=" + i), (String)("u" + i), (String)dststat[i].getOwner());
            }
            TestCopyFiles.deldir(fs, "/destdat");
            TestCopyFiles.deldir(fs, "/srcdat");
            files = TestCopyFiles.createFiles(URI.create(nnUri), "/srcdat");
            srcstat = TestCopyFiles.getFileStatus(fs, "/srcdat", files);
            for (int i3 = 0; i3 < srcstat.length; ++i3) {
                fs.setOwner(srcstat[i3].getPath(), null, "g" + i3);
            }
            ToolRunner.run((Tool)new DistCp(conf), (String[])new String[]{"-pg", nnUri + "/srcdat", nnUri + "/destdat"});
            TestCopyFiles.assertTrue((String)"Source and destination directories do not match.", (boolean)TestCopyFiles.checkFiles(fs, "/destdat", files));
            dststat = TestCopyFiles.getFileStatus(fs, "/destdat", files);
            for (i = 0; i < dststat.length; ++i) {
                TestCopyFiles.assertEquals((String)("i=" + i), (String)("g" + i), (String)dststat[i].getGroup());
            }
            TestCopyFiles.deldir(fs, "/destdat");
            TestCopyFiles.deldir(fs, "/srcdat");
            files = TestCopyFiles.createFiles(URI.create(nnUri), "/srcdat");
            srcstat = TestCopyFiles.getFileStatus(fs, "/srcdat", files);
            FsPermission[] permissions = new FsPermission[srcstat.length];
            for (i = 0; i < srcstat.length; ++i) {
                permissions[i] = new FsPermission((short)(i & 0x1B6));
                fs.setPermission(srcstat[i].getPath(), permissions[i]);
            }
            ToolRunner.run((Tool)new DistCp(conf), (String[])new String[]{"-pp", nnUri + "/srcdat", nnUri + "/destdat"});
            TestCopyFiles.assertTrue((String)"Source and destination directories do not match.", (boolean)TestCopyFiles.checkFiles(fs, "/destdat", files));
            FileStatus[] dststat2 = TestCopyFiles.getFileStatus(fs, "/destdat", files);
            for (int i4 = 0; i4 < dststat2.length; ++i4) {
                TestCopyFiles.assertEquals((String)("i=" + i4), (Object)permissions[i4], (Object)dststat2[i4].getPermission());
            }
            TestCopyFiles.deldir(fs, "/destdat");
            TestCopyFiles.deldir(fs, "/srcdat");
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMapCount() throws Exception {
        String namenode = null;
        MiniDFSCluster dfs = null;
        MiniMRCluster mr = null;
        try {
            Configuration conf = new Configuration();
            dfs = new MiniDFSCluster(conf, 3, true, null);
            FileSystem fs = dfs.getFileSystem();
            FsShell shell = new FsShell(conf);
            namenode = fs.getUri().toString();
            mr = new MiniMRCluster(3, namenode, 1);
            MyFile[] files = TestCopyFiles.createFiles(fs.getUri(), "/srcdat");
            long totsize = 0L;
            for (MyFile f : files) {
                totsize += (long)f.getSize();
            }
            JobConf job = mr.createJobConf();
            job.setLong("distcp.bytes.per.map", totsize / 3L);
            ToolRunner.run((Tool)new DistCp((Configuration)job), (String[])new String[]{"-m", "100", "-log", namenode + "/logs", namenode + "/srcdat", namenode + "/destdat"});
            TestCopyFiles.assertTrue((String)"Source and destination directories do not match.", (boolean)TestCopyFiles.checkFiles(fs, "/destdat", files));
            String logdir = namenode + "/logs";
            System.out.println(TestCopyFiles.execCmd(shell, "-lsr", logdir));
            FileStatus[] logs = fs.listStatus(new Path(logdir));
            TestCopyFiles.assertTrue((String)("Unexpected map count, logs.length=" + logs.length), (logs.length == 5 || logs.length == 4 ? 1 : 0) != 0);
            TestCopyFiles.deldir(fs, "/destdat");
            TestCopyFiles.deldir(fs, "/logs");
            ToolRunner.run((Tool)new DistCp((Configuration)job), (String[])new String[]{"-m", "1", "-log", namenode + "/logs", namenode + "/srcdat", namenode + "/destdat"});
            System.out.println(TestCopyFiles.execCmd(shell, "-lsr", logdir));
            logs = fs.listStatus(new Path(namenode + "/logs"));
            TestCopyFiles.assertTrue((String)("Unexpected map count, logs.length=" + logs.length), (logs.length == 2 ? 1 : 0) != 0);
        }
        finally {
            if (dfs != null) {
                dfs.shutdown();
            }
            if (mr != null) {
                mr.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLimits() throws Exception {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster(conf, 2, true, null);
            String nnUri = FileSystem.getDefaultUri((Configuration)conf).toString();
            FileSystem fs = FileSystem.get((URI)URI.create(nnUri), (Configuration)conf);
            DistCp distcp = new DistCp(conf);
            FsShell shell = new FsShell(conf);
            String srcrootdir = "/src_root";
            Path srcrootpath = new Path("/src_root");
            String dstrootdir = "/dst_root";
            Path dstrootpath = new Path("/dst_root");
            MyFile[] files = TestCopyFiles.createFiles(URI.create(nnUri), "/src_root");
            int filelimit = files.length / 2;
            System.out.println("filelimit=" + filelimit);
            ToolRunner.run((Tool)distcp, (String[])new String[]{"-filelimit", "" + filelimit, nnUri + "/src_root", nnUri + "/dst_root"});
            String results = TestCopyFiles.execCmd(shell, "-lsr", "/dst_root");
            results = TestCopyFiles.removePrefix(results, "/dst_root");
            System.out.println("results=" + results);
            FileStatus[] dststat = TestCopyFiles.getFileStatus(fs, "/dst_root", files, true);
            TestCopyFiles.assertEquals((int)filelimit, (int)dststat.length);
            TestCopyFiles.deldir(fs, "/dst_root");
            TestCopyFiles.deldir(fs, "/src_root");
            TestCopyFiles.createFiles(URI.create(nnUri), "/src_root");
            long sizelimit = fs.getContentSummary(srcrootpath).getLength() / 2L;
            System.out.println("sizelimit=" + sizelimit);
            ToolRunner.run((Tool)distcp, (String[])new String[]{"-sizelimit", "" + sizelimit, nnUri + "/src_root", nnUri + "/dst_root"});
            ContentSummary summary = fs.getContentSummary(dstrootpath);
            System.out.println("summary=" + summary);
            TestCopyFiles.assertTrue((summary.getLength() <= sizelimit ? 1 : 0) != 0);
            TestCopyFiles.deldir(fs, "/dst_root");
            TestCopyFiles.deldir(fs, "/src_root");
            MyFile[] srcs = TestCopyFiles.createFiles(URI.create(nnUri), "/src_root");
            long totalsize = fs.getContentSummary(srcrootpath).getLength();
            System.out.println("src.length=" + srcs.length);
            System.out.println("totalsize =" + totalsize);
            fs.mkdirs(dstrootpath);
            int parts = RAN.nextInt(5) + 2;
            int filelimit2 = srcs.length / parts;
            long sizelimit2 = totalsize / (long)parts;
            System.out.println("filelimit=" + filelimit2);
            System.out.println("sizelimit=" + sizelimit2);
            System.out.println("parts    =" + parts);
            String[] args = new String[]{"-filelimit", "" + filelimit2, "-sizelimit", "" + sizelimit2, "-update", nnUri + "/src_root", nnUri + "/dst_root"};
            int dstfilecount = 0;
            long dstsize = 0L;
            for (int i = 0; i <= parts; ++i) {
                ToolRunner.run((Tool)distcp, (String[])args);
                FileStatus[] dststat2 = TestCopyFiles.getFileStatus(fs, "/dst_root", srcs, true);
                System.out.println(i + ") dststat.length=" + dststat2.length);
                TestCopyFiles.assertTrue((dststat2.length - dstfilecount <= filelimit2 ? 1 : 0) != 0);
                ContentSummary summary2 = fs.getContentSummary(dstrootpath);
                System.out.println(i + ") summary.getLength()=" + summary2.getLength());
                TestCopyFiles.assertTrue((summary2.getLength() - dstsize <= sizelimit2 ? 1 : 0) != 0);
                TestCopyFiles.assertTrue((boolean)TestCopyFiles.checkFiles(fs, "/dst_root", srcs, true));
                dstfilecount = dststat2.length;
                dstsize = summary2.getLength();
            }
            TestCopyFiles.deldir(fs, "/dst_root");
            TestCopyFiles.deldir(fs, "/src_root");
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    static UnixUserGroupInformation createUGI(String name, boolean issuper) {
        String username = name + now;
        String group = issuper ? "supergroup" : username;
        return UnixUserGroupInformation.createImmutable((String[])new String[]{username, group});
    }

    static Path createHomeDirectory(FileSystem fs, UserGroupInformation ugi) throws IOException {
        Path home = new Path("/user/" + ugi.getUserName());
        fs.mkdirs(home);
        fs.setOwner(home, ugi.getUserName(), ugi.getGroupNames()[0]);
        fs.setPermission(home, new FsPermission(448));
        return home;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testHftpAccessControl() throws Exception {
        MiniDFSCluster cluster = null;
        try {
            UnixUserGroupInformation DFS_UGI = TestCopyFiles.createUGI("dfs", true);
            UnixUserGroupInformation USER_UGI = TestCopyFiles.createUGI("user", false);
            Configuration dfsConf = new Configuration();
            UnixUserGroupInformation.saveToConf((Configuration)dfsConf, (String)"hadoop.job.ugi", (UnixUserGroupInformation)DFS_UGI);
            cluster = new MiniDFSCluster(dfsConf, 2, true, null);
            cluster.waitActive();
            String httpAdd = dfsConf.get("dfs.http.address");
            URI nnURI = FileSystem.getDefaultUri((Configuration)dfsConf);
            String nnUri = nnURI.toString();
            Path home = TestCopyFiles.createHomeDirectory(FileSystem.get((URI)nnURI, (Configuration)dfsConf), (UserGroupInformation)USER_UGI);
            Configuration userConf = new Configuration();
            UnixUserGroupInformation.saveToConf((Configuration)userConf, (String)"hadoop.job.ugi", (UnixUserGroupInformation)USER_UGI);
            FileSystem fs = FileSystem.get((URI)nnURI, (Configuration)userConf);
            Path srcrootpath = new Path(home, "src_root");
            String srcrootdir = srcrootpath.toString();
            Path dstrootpath = new Path(home, "dst_root");
            String dstrootdir = dstrootpath.toString();
            DistCp distcp = new DistCp(userConf);
            FileSystem.mkdirs((FileSystem)fs, (Path)srcrootpath, (FsPermission)new FsPermission(448));
            String[] args = new String[]{"hftp://" + httpAdd + srcrootdir, nnUri + dstrootdir};
            fs.setPermission(srcrootpath, new FsPermission(0));
            TestCopyFiles.assertEquals((int)-3, (int)ToolRunner.run((Tool)distcp, (String[])args));
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDelete() throws Exception {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster(conf, 2, true, null);
            URI nnURI = FileSystem.getDefaultUri((Configuration)conf);
            String nnUri = nnURI.toString();
            FileSystem fs = FileSystem.get((URI)URI.create(nnUri), (Configuration)conf);
            DistCp distcp = new DistCp(conf);
            FsShell shell = new FsShell(conf);
            String srcrootdir = "/src_root";
            String dstrootdir = "/dst_root";
            TestCopyFiles.createFiles(nnURI, "/src_root");
            String srcresults = TestCopyFiles.execCmd(shell, "-lsr", "/src_root");
            srcresults = TestCopyFiles.removePrefix(srcresults, "/src_root");
            System.out.println("srcresults=" + srcresults);
            TestCopyFiles.createFiles(nnURI, "/dst_root");
            System.out.println("dstrootdir=/dst_root");
            shell.run(new String[]{"-lsr", "/dst_root"});
            ToolRunner.run((Tool)distcp, (String[])new String[]{"-delete", "-update", "-log", "/log", nnUri + "/src_root", nnUri + "/dst_root"});
            String dstresults = TestCopyFiles.execCmd(shell, "-lsr", "/dst_root");
            dstresults = TestCopyFiles.removePrefix(dstresults, "/dst_root");
            System.out.println("first dstresults=" + dstresults);
            TestCopyFiles.assertEquals((String)srcresults, (String)dstresults);
            TestCopyFiles.create(fs, new Path("/dst_root", "foo"));
            TestCopyFiles.create(fs, new Path("/dst_root", "foobar"));
            ToolRunner.run((Tool)distcp, (String[])new String[]{"-delete", "-update", "-log", "/log2", nnUri + "/src_root", nnUri + "/dst_root"});
            dstresults = TestCopyFiles.execCmd(shell, "-lsr", "/dst_root");
            dstresults = TestCopyFiles.removePrefix(dstresults, "/dst_root");
            System.out.println("second dstresults=" + dstresults);
            TestCopyFiles.assertEquals((String)srcresults, (String)dstresults);
            TestCopyFiles.deldir(fs, "/dst_root");
            TestCopyFiles.deldir(fs, "/src_root");
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void create(FileSystem fs, Path f) throws IOException {
        FSDataOutputStream out = fs.create(f);
        try {
            byte[] b = new byte[1024 + RAN.nextInt(1024)];
            RAN.nextBytes(b);
            out.write(b);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    static String execCmd(FsShell shell, String ... args) throws Exception {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(baout, true);
        PrintStream old = System.out;
        System.setOut(out);
        shell.run(args);
        out.close();
        System.setOut(old);
        return baout.toString();
    }

    private static String removePrefix(String lines, String prefix) {
        int prefixlen = prefix.length();
        StringTokenizer t = new StringTokenizer(lines, "\n");
        StringBuffer results = new StringBuffer();
        while (t.hasMoreTokens()) {
            String s = t.nextToken();
            results.append(s.substring(s.indexOf(prefix) + prefixlen) + "\n");
        }
        return results.toString();
    }

    private static class MyFile {
        private static Random gen = new Random();
        private static final int MAX_LEVELS = 3;
        private static final int MAX_SIZE = 8192;
        private static String[] dirNames = new String[]{"zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine"};
        private final String name;
        private int size = 0;
        private long seed = 0L;

        MyFile() {
            this(gen.nextInt(3));
        }

        MyFile(int nLevels) {
            String xname = "";
            if (nLevels != 0) {
                int[] levels = new int[nLevels];
                for (int idx = 0; idx < nLevels; ++idx) {
                    levels[idx] = gen.nextInt(10);
                }
                StringBuffer sb = new StringBuffer();
                for (int idx = 0; idx < nLevels; ++idx) {
                    sb.append(dirNames[levels[idx]]);
                    sb.append("/");
                }
                xname = sb.toString();
            }
            long fidx = gen.nextLong() & Long.MAX_VALUE;
            this.name = xname + Long.toString(fidx);
            this.reset();
        }

        void reset() {
            int oldsize = this.size;
            do {
                this.size = gen.nextInt(8192);
            } while (oldsize == this.size);
            long oldseed = this.seed;
            do {
                this.seed = gen.nextLong() & Long.MAX_VALUE;
            } while (oldseed == this.seed);
        }

        String getName() {
            return this.name;
        }

        int getSize() {
            return this.size;
        }

        long getSeed() {
            return this.seed;
        }
    }
}

