/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.serializer.Deserializer;
import org.apache.hadoop.io.serializer.SerializationFactory;
import org.apache.hadoop.io.serializer.Serializer;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.util.GenericsUtil;

public class TestWritableJobConf
extends TestCase {
    private static final Configuration CONF = new Configuration();

    private <K> K serDeser(K conf) throws Exception {
        SerializationFactory factory = new SerializationFactory(CONF);
        Serializer serializer = factory.getSerializer(GenericsUtil.getClass(conf));
        Deserializer deserializer = factory.getDeserializer(GenericsUtil.getClass(conf));
        DataOutputBuffer out = new DataOutputBuffer();
        serializer.open((OutputStream)out);
        serializer.serialize(conf);
        serializer.close();
        DataInputBuffer in = new DataInputBuffer();
        in.reset(out.getData(), out.getLength());
        deserializer.open((InputStream)in);
        Object after = deserializer.deserialize(null);
        deserializer.close();
        return (K)after;
    }

    private void assertEquals(Configuration conf1, Configuration conf2) {
        Iterator iterator1 = conf1.iterator();
        HashMap map1 = new HashMap();
        while (iterator1.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator1.next();
            if (Configuration.isDeprecated((String)((String)entry.getKey()))) continue;
            map1.put(entry.getKey(), entry.getValue());
        }
        Iterator iterator2 = conf2.iterator();
        HashMap map2 = new HashMap();
        while (iterator2.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator2.next();
            if (Configuration.isDeprecated((String)((String)entry.getKey()))) continue;
            map2.put(entry.getKey(), entry.getValue());
        }
        TestWritableJobConf.assertEquals(map1, map2);
    }

    public void testEmptyConfiguration() throws Exception {
        JobConf conf = new JobConf();
        Configuration deser = (Configuration)this.serDeser(conf);
        this.assertEquals((Configuration)conf, deser);
    }

    public void testNonEmptyConfiguration() throws Exception {
        JobConf conf = new JobConf();
        conf.set("a", "A");
        conf.set("b", "B");
        Configuration deser = (Configuration)this.serDeser(conf);
        this.assertEquals((Configuration)conf, deser);
    }

    public void testConfigurationWithDefaults() throws Exception {
        JobConf conf = new JobConf(false);
        conf.set("a", "A");
        conf.set("b", "B");
        Configuration deser = (Configuration)this.serDeser(conf);
        this.assertEquals((Configuration)conf, deser);
    }
}

