/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2;

import java.io.File;
import java.io.IOException;
import java.util.List;
import junit.framework.Assert;
import org.apache.avro.AvroRemoteException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.SleepJob;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.v2.MiniMRYarnCluster;
import org.apache.hadoop.mapreduce.v2.TestMRJobs;
import org.apache.hadoop.mapreduce.v2.api.MRClientProtocol;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetJobReportRequest;
import org.apache.hadoop.mapreduce.v2.api.records.AMInfo;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.JobReport;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.util.BuilderUtils;
import org.apache.hadoop.yarn.util.Records;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestMRJobsWithHistoryService {
    private static final Log LOG = LogFactory.getLog(TestMRJobsWithHistoryService.class);
    private static MiniMRYarnCluster mrCluster;
    private static Configuration conf;
    private static FileSystem localFs;
    private static Path TEST_ROOT_DIR;
    static Path APP_JAR;

    @Before
    public void setup() throws InterruptedException, IOException {
        if (!new File(MiniMRYarnCluster.APPJAR).exists()) {
            LOG.info((Object)("MRAppJar " + MiniMRYarnCluster.APPJAR + " not found. Not running test."));
            return;
        }
        if (mrCluster == null) {
            mrCluster = new MiniMRYarnCluster(this.getClass().getName());
            mrCluster.init(new Configuration());
            mrCluster.start();
        }
        localFs.copyFromLocalFile(new Path(MiniMRYarnCluster.APPJAR), APP_JAR);
        localFs.setPermission(APP_JAR, new FsPermission("700"));
    }

    @After
    public void tearDown() {
        if (!new File(MiniMRYarnCluster.APPJAR).exists()) {
            LOG.info((Object)("MRAppJar " + MiniMRYarnCluster.APPJAR + " not found. Not running test."));
            return;
        }
        if (mrCluster != null) {
            mrCluster.stop();
        }
    }

    @Test
    public void testJobHistoryData() throws IOException, InterruptedException, AvroRemoteException, ClassNotFoundException {
        if (!new File(MiniMRYarnCluster.APPJAR).exists()) {
            LOG.info((Object)("MRAppJar " + MiniMRYarnCluster.APPJAR + " not found. Not running test."));
            return;
        }
        SleepJob sleepJob = new SleepJob();
        sleepJob.setConf(mrCluster.getConfig());
        Job job = sleepJob.createJob(3, 2, 1000L, 1, 500L, 1);
        job.setJarByClass(SleepJob.class);
        job.addFileToClassPath(APP_JAR);
        job.waitForCompletion(true);
        Counters counterMR = job.getCounters();
        JobId jobId = TypeConverter.toYarn((JobID)job.getJobID());
        ApplicationId appID = jobId.getAppId();
        do {
            Thread.sleep(1000L);
        } while (!((RMApp)mrCluster.getResourceManager().getRMContext().getRMApps().get(appID)).getState().equals((Object)RMAppState.FINISHED));
        Counters counterHS = job.getCounters();
        LOG.info((Object)("CounterHS " + counterHS));
        LOG.info((Object)("CounterMR " + counterMR));
        Assert.assertEquals((Object)counterHS, (Object)counterMR);
        MRClientProtocol historyClient = this.instantiateHistoryProxy();
        GetJobReportRequest gjReq = (GetJobReportRequest)Records.newRecord(GetJobReportRequest.class);
        gjReq.setJobId(jobId);
        JobReport jobReport = historyClient.getJobReport(gjReq).getJobReport();
        this.verifyJobReport(jobReport, jobId);
    }

    private void verifyJobReport(JobReport jobReport, JobId jobId) {
        List amInfos = jobReport.getAMInfos();
        Assert.assertEquals((int)1, (int)amInfos.size());
        AMInfo amInfo = (AMInfo)amInfos.get(0);
        ApplicationAttemptId appAttemptId = BuilderUtils.newApplicationAttemptId((ApplicationId)jobId.getAppId(), (int)1);
        ContainerId amContainerId = BuilderUtils.newContainerId((ApplicationAttemptId)appAttemptId, (int)1);
        Assert.assertEquals((Object)appAttemptId, (Object)amInfo.getAppAttemptId());
        Assert.assertEquals((Object)amContainerId, (Object)amInfo.getContainerId());
        Assert.assertTrue((jobReport.getSubmitTime() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((jobReport.getStartTime() > 0L && jobReport.getStartTime() >= jobReport.getSubmitTime() ? 1 : 0) != 0);
        Assert.assertTrue((jobReport.getFinishTime() > 0L && jobReport.getFinishTime() >= jobReport.getStartTime() ? 1 : 0) != 0);
    }

    private MRClientProtocol instantiateHistoryProxy() {
        String serviceAddr = mrCluster.getConfig().get("mapreduce.jobhistory.address");
        YarnRPC rpc = YarnRPC.create((Configuration)conf);
        MRClientProtocol historyClient = (MRClientProtocol)rpc.getProxy(MRClientProtocol.class, NetUtils.createSocketAddr((String)serviceAddr), mrCluster.getConfig());
        return historyClient;
    }

    static {
        conf = new Configuration();
        try {
            localFs = FileSystem.getLocal((Configuration)conf);
        }
        catch (IOException io) {
            throw new RuntimeException("problem getting local fs", io);
        }
        TEST_ROOT_DIR = new Path("target", TestMRJobs.class.getName() + "-tmpDir").makeQualified(localFs);
        APP_JAR = new Path(TEST_ROOT_DIR, "MRAppJar.jar");
    }
}

