/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.LocalContainerLauncher;
import org.apache.hadoop.mapred.ShuffleHandler;
import org.apache.hadoop.mapreduce.v2.hs.JobHistoryServer;
import org.apache.hadoop.mapreduce.v2.jobhistory.JHAdminConfig;
import org.apache.hadoop.mapreduce.v2.jobhistory.JobHistoryUtils;
import org.apache.hadoop.util.JarFinder;
import org.apache.hadoop.yarn.YarnException;
import org.apache.hadoop.yarn.server.MiniYARNCluster;
import org.apache.hadoop.yarn.server.nodemanager.ContainerExecutor;
import org.apache.hadoop.yarn.server.nodemanager.DefaultContainerExecutor;
import org.apache.hadoop.yarn.service.AbstractService;
import org.apache.hadoop.yarn.service.Service;

public class MiniMRYarnCluster
extends MiniYARNCluster {
    public static final String APPJAR = JarFinder.getJar(LocalContainerLauncher.class);
    private static final Log LOG = LogFactory.getLog(MiniMRYarnCluster.class);
    private JobHistoryServer historyServer;
    private JobHistoryServerWrapper historyServerWrapper = new JobHistoryServerWrapper();

    public MiniMRYarnCluster(String testName) {
        this(testName, 1);
    }

    public MiniMRYarnCluster(String testName, int noOfNMs) {
        super(testName, noOfNMs, 4, 4);
        this.addService((Service)this.historyServerWrapper);
    }

    public void init(Configuration conf) {
        conf.set("mapreduce.framework.name", "yarn");
        if (conf.get("yarn.app.mapreduce.am.staging-dir") == null) {
            conf.set("yarn.app.mapreduce.am.staging-dir", new File(this.getTestWorkDir(), "apps_staging_dir/").getAbsolutePath());
        }
        conf.set("fs.permissions.umask-mode", "000");
        try {
            Path stagingPath = FileContext.getFileContext((Configuration)conf).makeQualified(new Path(conf.get("yarn.app.mapreduce.am.staging-dir")));
            FileContext fc = FileContext.getFileContext((URI)stagingPath.toUri(), (Configuration)conf);
            if (fc.util().exists(stagingPath)) {
                LOG.info((Object)(stagingPath + " exists! deleting..."));
                fc.delete(stagingPath, true);
            }
            LOG.info((Object)("mkdir: " + stagingPath));
            fc.mkdir(stagingPath, null, true);
            String doneDir = JobHistoryUtils.getConfiguredHistoryServerDoneDirPrefix((Configuration)conf);
            Path doneDirPath = fc.makeQualified(new Path(doneDir));
            fc.mkdir(doneDirPath, null, true);
        }
        catch (IOException e) {
            throw new YarnException("Could not create staging directory. ", (Throwable)e);
        }
        conf.set("mapreduce.jobtracker.address", "test");
        conf.setStrings("yarn.nodemanager.aux-services", new String[]{"mapreduce.shuffle"});
        conf.setClass(String.format("yarn.nodemanager.aux-services.%s.class", "mapreduce.shuffle"), ShuffleHandler.class, Service.class);
        conf.setInt("mapreduce.shuffle.port", 0);
        conf.setClass("yarn.nodemanager.container-executor.class", DefaultContainerExecutor.class, ContainerExecutor.class);
        conf.setBoolean("mapreduce.job.ubertask.enable", false);
        super.init(conf);
    }

    public JobHistoryServer getHistoryServer() {
        return this.historyServer;
    }

    private class JobHistoryServerWrapper
    extends AbstractService {
        public JobHistoryServerWrapper() {
            super(JobHistoryServerWrapper.class.getName());
        }

        public synchronized void start() {
            try {
                if (!this.getConfig().getBoolean("mapreduce.jobhistory.minicluster.fixed.ports", JHAdminConfig.DEFAULT_MR_HISTORY_MINICLUSTER_FIXED_PORTS)) {
                    this.getConfig().set("mapreduce.jobhistory.address", MiniYARNCluster.getHostname() + ":0");
                    this.getConfig().set("mapreduce.jobhistory.webapp.address", MiniYARNCluster.getHostname() + ":0");
                }
                MiniMRYarnCluster.this.historyServer = new JobHistoryServer();
                MiniMRYarnCluster.this.historyServer.init(this.getConfig());
                new Thread(){

                    @Override
                    public void run() {
                        MiniMRYarnCluster.this.historyServer.start();
                    }
                }.start();
                while (MiniMRYarnCluster.this.historyServer.getServiceState() == Service.STATE.INITED) {
                    LOG.info((Object)"Waiting for HistoryServer to start...");
                    Thread.sleep(1500L);
                }
                if (MiniMRYarnCluster.this.historyServer.getServiceState() != Service.STATE.STARTED) {
                    throw new IOException("HistoryServer failed to start");
                }
                super.start();
            }
            catch (Throwable t) {
                throw new YarnException(t);
            }
            this.getConfig().set("mapreduce.jobhistory.address", MiniMRYarnCluster.this.historyServer.getConfig().get("mapreduce.jobhistory.address"));
            this.getConfig().set("mapreduce.jobhistory.webapp.address", MiniMRYarnCluster.this.historyServer.getConfig().get("mapreduce.jobhistory.webapp.address"));
            LOG.info((Object)("MiniMRYARN ResourceManager address: " + this.getConfig().get("yarn.resourcemanager.address")));
            LOG.info((Object)("MiniMRYARN ResourceManager web address: " + this.getConfig().get("yarn.resourcemanager.webapp.address")));
            LOG.info((Object)("MiniMRYARN HistoryServer address: " + this.getConfig().get("mapreduce.jobhistory.address")));
            LOG.info((Object)("MiniMRYARN HistoryServer web address: " + this.getConfig().get("mapreduce.jobhistory.webapp.address")));
        }

        public synchronized void stop() {
            if (MiniMRYarnCluster.this.historyServer != null) {
                MiniMRYarnCluster.this.historyServer.stop();
            }
            super.stop();
        }
    }
}

