/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.security;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.v2.api.HSClientProtocol;
import org.apache.hadoop.mapreduce.v2.api.MRClientProtocol;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetDelegationTokenRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetJobReportRequest;
import org.apache.hadoop.mapreduce.v2.hs.JobHistoryServer;
import org.apache.hadoop.mapreduce.v2.util.MRBuilderUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.DelegationToken;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnRemoteException;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.util.ProtoUtils;
import org.apache.hadoop.yarn.util.Records;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.junit.Test;

public class TestJHSSecurity {
    @Test
    public void testDelegationToken() throws IOException, InterruptedException {
        Logger rootLogger = LogManager.getRootLogger();
        rootLogger.setLevel(Level.DEBUG);
        final YarnConfiguration conf = new YarnConfiguration((Configuration)new JobConf());
        conf.set("mapreduce.jobhistory.principal", "RandomOrc/localhost@apache.org");
        conf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)conf);
        final JobHistoryServer jobHistoryServer = new JobHistoryServer(){

            protected void doSecureLogin(Configuration conf) throws IOException {
            }
        };
        jobHistoryServer.init((Configuration)conf);
        jobHistoryServer.start();
        UserGroupInformation loggedInUser = UserGroupInformation.getCurrentUser();
        loggedInUser.setAuthenticationMethod(UserGroupInformation.AuthenticationMethod.KERBEROS);
        DelegationToken token = (DelegationToken)loggedInUser.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<DelegationToken>(){

            @Override
            public DelegationToken run() throws YarnRemoteException {
                GetDelegationTokenRequest request = (GetDelegationTokenRequest)Records.newRecord(GetDelegationTokenRequest.class);
                request.setRenewer("OneRenewerToRuleThemAll");
                return jobHistoryServer.getClientService().getClientHandler().getDelegationToken(request).getDelegationToken();
            }
        });
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)"TheDarkLord");
        ugi.addToken(ProtoUtils.convertFromProtoFormat((DelegationToken)token, (InetSocketAddress)jobHistoryServer.getClientService().getBindAddress()));
        final YarnRPC rpc = YarnRPC.create((Configuration)conf);
        MRClientProtocol userUsingDT = (MRClientProtocol)ugi.doAs((PrivilegedAction)new PrivilegedAction<MRClientProtocol>(){

            @Override
            public MRClientProtocol run() {
                return (MRClientProtocol)rpc.getProxy(HSClientProtocol.class, jobHistoryServer.getClientService().getBindAddress(), (Configuration)conf);
            }
        });
        GetJobReportRequest jobReportRequest = (GetJobReportRequest)Records.newRecord(GetJobReportRequest.class);
        jobReportRequest.setJobId(MRBuilderUtils.newJobId((long)123456L, (int)1, (int)1));
        try {
            userUsingDT.getJobReport(jobReportRequest);
        }
        catch (YarnRemoteException e) {
            Assert.assertEquals((String)"Unknown job job_123456_0001", (String)e.getMessage());
        }
    }
}

