/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.lib;

import java.io.IOException;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.KeyValueTextInputFormat;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapred.lib.DelegatingInputFormat;
import org.apache.hadoop.mapred.lib.MultipleInputs;
import org.apache.hadoop.mapred.lib.TaggedInputSplit;

public class TestDelegatingInputFormat
extends TestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSplitting() throws Exception {
        JobConf conf = new JobConf();
        MiniDFSCluster dfs = null;
        try {
            dfs = new MiniDFSCluster((Configuration)conf, 4, true, new String[]{"/rack0", "/rack0", "/rack1", "/rack1"}, new String[]{"host0", "host1", "host2", "host3"});
            FileSystem fs = dfs.getFileSystem();
            Path path = TestDelegatingInputFormat.getPath("/foo/bar", fs);
            Path path2 = TestDelegatingInputFormat.getPath("/foo/baz", fs);
            Path path3 = TestDelegatingInputFormat.getPath("/bar/bar", fs);
            Path path4 = TestDelegatingInputFormat.getPath("/bar/baz", fs);
            int numSplits = 100;
            MultipleInputs.addInputPath((JobConf)conf, (Path)path, TextInputFormat.class, MapClass.class);
            MultipleInputs.addInputPath((JobConf)conf, (Path)path2, TextInputFormat.class, MapClass2.class);
            MultipleInputs.addInputPath((JobConf)conf, (Path)path3, KeyValueTextInputFormat.class, MapClass.class);
            MultipleInputs.addInputPath((JobConf)conf, (Path)path4, TextInputFormat.class, MapClass2.class);
            DelegatingInputFormat inFormat = new DelegatingInputFormat();
            InputSplit[] splits = inFormat.getSplits(conf, 100);
            int[] bins = new int[3];
            for (InputSplit split : splits) {
                TestDelegatingInputFormat.assertTrue((boolean)(split instanceof TaggedInputSplit));
                TaggedInputSplit tis = (TaggedInputSplit)split;
                int index = -1;
                index = tis.getInputFormatClass().equals(KeyValueTextInputFormat.class) ? 0 : (tis.getMapperClass().equals(MapClass.class) ? 1 : 2);
                int n = index;
                bins[n] = bins[n] + 1;
            }
            for (int count : bins) {
                TestDelegatingInputFormat.assertEquals((int)100, (int)count);
            }
            TestDelegatingInputFormat.assertTrue((boolean)true);
        }
        finally {
            if (dfs != null) {
                dfs.shutdown();
            }
        }
    }

    static Path getPath(String location, FileSystem fs) throws IOException {
        Path path = new Path(location);
        FSDataOutputStream out = fs.create(path, true, 4096, (short)2, 512L, null);
        for (int i = 0; i < 1000; ++i) {
            out.writeChars("Hello\n");
        }
        out.close();
        return path;
    }

    static class MapClass2
    extends MapClass {
        MapClass2() {
        }
    }

    static class MapClass
    implements Mapper<String, String, String, String> {
        MapClass() {
        }

        public void map(String key, String value, OutputCollector<String, String> output, Reporter reporter) throws IOException {
        }

        public void configure(JobConf job) {
        }

        public void close() throws IOException {
        }
    }
}

