/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobStatus;
import org.apache.hadoop.mapreduce.v2.MiniMRYarnCluster;
import org.junit.Assert;
import org.junit.Test;

public class TestSocketFactory {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSocketFactory() throws IOException {
        Configuration sconf = new Configuration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(sconf).numDataNodes(1).build();
        int nameNodePort = cluster.getNameNodePort();
        FileSystem fs = cluster.getFileSystem();
        Assert.assertTrue((boolean)(fs instanceof DistributedFileSystem));
        DistributedFileSystem directDfs = (DistributedFileSystem)fs;
        Configuration cconf = this.getCustomSocketConfigs(nameNodePort);
        fs = FileSystem.get((Configuration)cconf);
        Assert.assertTrue((boolean)(fs instanceof DistributedFileSystem));
        DistributedFileSystem dfs = (DistributedFileSystem)fs;
        JobClient client = null;
        MiniMRYarnCluster miniMRYarnCluster = null;
        try {
            Path filePath = new Path("/dir");
            Assert.assertFalse((boolean)directDfs.exists(filePath));
            Assert.assertFalse((boolean)dfs.exists(filePath));
            directDfs.mkdirs(filePath);
            Assert.assertTrue((boolean)directDfs.exists(filePath));
            Assert.assertTrue((boolean)dfs.exists(filePath));
            fs = FileSystem.get((Configuration)sconf);
            JobConf jobConf = new JobConf();
            FileSystem.setDefaultUri((Configuration)jobConf, (String)fs.getUri().toString());
            miniMRYarnCluster = this.initAndStartMiniMRYarnCluster(jobConf);
            JobConf jconf = new JobConf(miniMRYarnCluster.getConfig());
            jconf.set("hadoop.rpc.socket.factory.class.default", "org.apache.hadoop.ipc.DummySocketFactory");
            jconf.set("mapreduce.framework.name", "yarn");
            String rmAddress = jconf.get("yarn.resourcemanager.address");
            String[] split = rmAddress.split(":");
            jconf.set("yarn.resourcemanager.address", split[0] + ':' + (Integer.parseInt(split[1]) + 10));
            client = new JobClient(jconf);
            JobStatus[] jobs = client.jobsToComplete();
            Assert.assertTrue((jobs.length == 0 ? 1 : 0) != 0);
            this.closeClient(client);
            this.closeDfs(dfs);
            this.closeDfs(directDfs);
            this.stopMiniMRYarnCluster(miniMRYarnCluster);
            this.shutdownDFSCluster(cluster);
        }
        catch (Throwable throwable) {
            this.closeClient(client);
            this.closeDfs(dfs);
            this.closeDfs(directDfs);
            this.stopMiniMRYarnCluster(miniMRYarnCluster);
            this.shutdownDFSCluster(cluster);
            throw throwable;
        }
    }

    private MiniMRYarnCluster initAndStartMiniMRYarnCluster(JobConf jobConf) {
        MiniMRYarnCluster miniMRYarnCluster = new MiniMRYarnCluster(this.getClass().getName(), 1);
        miniMRYarnCluster.init((Configuration)jobConf);
        miniMRYarnCluster.start();
        return miniMRYarnCluster;
    }

    private Configuration getCustomSocketConfigs(int nameNodePort) {
        Configuration cconf = new Configuration();
        FileSystem.setDefaultUri((Configuration)cconf, (String)String.format("hdfs://localhost:%s/", nameNodePort + 10));
        cconf.set("hadoop.rpc.socket.factory.class.default", "org.apache.hadoop.ipc.DummySocketFactory");
        cconf.set("hadoop.rpc.socket.factory.class.ClientProtocol", "org.apache.hadoop.ipc.DummySocketFactory");
        cconf.set("hadoop.rpc.socket.factory.class.JobSubmissionProtocol", "org.apache.hadoop.ipc.DummySocketFactory");
        return cconf;
    }

    private void shutdownDFSCluster(MiniDFSCluster cluster) {
        try {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
        catch (Exception ignored) {
            ignored.printStackTrace();
        }
    }

    private void stopMiniMRYarnCluster(MiniMRYarnCluster miniMRYarnCluster) {
        try {
            if (miniMRYarnCluster != null) {
                miniMRYarnCluster.stop();
            }
        }
        catch (Exception ignored) {
            ignored.printStackTrace();
        }
    }

    private void closeDfs(DistributedFileSystem dfs) {
        try {
            if (dfs != null) {
                dfs.close();
            }
        }
        catch (Exception ignored) {
            ignored.printStackTrace();
        }
    }

    private void closeClient(JobClient client) {
        try {
            if (client != null) {
                client.close();
            }
        }
        catch (Exception ignored) {
            ignored.printStackTrace();
        }
    }
}

