/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.ha;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.namenode.ha.HATestUtil;
import org.apache.hadoop.util.ThreadUtil;
import org.junit.Assert;
import org.junit.Test;

public class TestPendingCorruptDnMessages {
    private static final Path filePath = new Path("/foo.txt");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testChangedStorageId() throws IOException, URISyntaxException, InterruptedException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.ha.tail-edits.period", 1);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).nnTopology(MiniDFSNNTopology.simpleHATopology()).build();
        try {
            cluster.transitionToActive(0);
            FileSystem fs = HATestUtil.configureFailoverFs(cluster, (Configuration)conf);
            FSDataOutputStream out = fs.create(filePath);
            out.write("foo bar baz".getBytes());
            out.close();
            HATestUtil.waitForStandbyToCatchUp(cluster.getNameNode(0), cluster.getNameNode(1));
            ExtendedBlock block = DFSTestUtil.getFirstBlock(fs, filePath);
            Assert.assertTrue((boolean)MiniDFSCluster.changeGenStampOfBlock(0, block, 900L));
            MiniDFSCluster.DataNodeProperties dnProps = cluster.stopDataNode(0);
            cluster.restartNameNode(1, false, new String[0]);
            Assert.assertTrue((boolean)cluster.restartDataNode(dnProps, true));
            while (cluster.getNamesystem(1).getBlockManager().getPendingDataNodeMessageCount() < 1) {
                ThreadUtil.sleepAtLeastIgnoreInterrupts((long)1000L);
            }
            Assert.assertEquals((long)1L, (long)cluster.getNamesystem(1).getBlockManager().getPendingDataNodeMessageCount());
            String oldStorageId = TestPendingCorruptDnMessages.getRegisteredDatanodeUid(cluster, 1);
            Assert.assertTrue((boolean)TestPendingCorruptDnMessages.wipeAndRestartDn(cluster, 0));
            String newStorageId = "";
            do {
                ThreadUtil.sleepAtLeastIgnoreInterrupts((long)1000L);
                newStorageId = TestPendingCorruptDnMessages.getRegisteredDatanodeUid(cluster, 1);
                System.out.println("====> oldStorageId: " + oldStorageId + " newStorageId: " + newStorageId);
            } while (newStorageId.equals(oldStorageId));
            Assert.assertEquals((long)0L, (long)cluster.getNamesystem(1).getBlockManager().getPendingDataNodeMessageCount());
            cluster.transitionToStandby(0);
            cluster.transitionToActive(1);
        }
        finally {
            cluster.shutdown();
        }
    }

    private static String getRegisteredDatanodeUid(MiniDFSCluster cluster, int nnIndex) {
        List registeredDatanodes = cluster.getNamesystem(nnIndex).getBlockManager().getDatanodeManager().getDatanodeListForReport(HdfsConstants.DatanodeReportType.ALL);
        Assert.assertEquals((long)1L, (long)registeredDatanodes.size());
        return ((DatanodeDescriptor)registeredDatanodes.get(0)).getDatanodeUuid();
    }

    private static boolean wipeAndRestartDn(MiniDFSCluster cluster, int dnIndex) throws IOException {
        MiniDFSCluster.DataNodeProperties dnProps = cluster.stopDataNode(dnIndex);
        cluster.formatDataNodeDirs();
        return cluster.restartDataNode(dnProps, true);
    }
}

