/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.FileNotFoundException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodesInPath;
import org.apache.hadoop.hdfs.server.namenode.snapshot.Snapshot;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestSnapshotPathINodes {
    private static final long seed = 0L;
    private static final short REPLICATION = 3;
    private static final Path dir = new Path("/TestSnapshot");
    private static final Path sub1 = new Path(dir, "sub1");
    private static final Path file1 = new Path(sub1, "file1");
    private static final Path file2 = new Path(sub1, "file2");
    private static Configuration conf;
    private static MiniDFSCluster cluster;
    private static FSNamesystem fsn;
    private static FSDirectory fsdir;
    private static DistributedFileSystem hdfs;
    private static Snapshot s4;

    @BeforeClass
    public static void setUp() throws Exception {
        conf = new Configuration();
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(3).build();
        cluster.waitActive();
        fsn = cluster.getNamesystem();
        fsdir = fsn.getFSDirectory();
        hdfs = cluster.getFileSystem();
    }

    @Before
    public void reset() throws Exception {
        DFSTestUtil.createFile((FileSystem)hdfs, file1, 1024L, (short)3, 0L);
        DFSTestUtil.createFile((FileSystem)hdfs, file2, 1024L, (short)3, 0L);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    @Test(timeout=15000L)
    public void testAllowSnapshot() throws Exception {
        String pathStr = sub1.toString();
        INode before = fsdir.getINode(pathStr);
        Assert.assertFalse((boolean)before.asDirectory().isSnapshottable());
        Path path = new Path(pathStr);
        hdfs.allowSnapshot(path);
        INode after = fsdir.getINode(pathStr);
        Assert.assertTrue((boolean)after.asDirectory().isSnapshottable());
        hdfs.disallowSnapshot(path);
        after = fsdir.getINode(pathStr);
        Assert.assertFalse((boolean)after.asDirectory().isSnapshottable());
    }

    static Snapshot getSnapshot(INodesInPath inodesInPath, String name) {
        if (name == null) {
            return null;
        }
        int i = inodesInPath.getSnapshotRootIndex() - 1;
        INode inode = inodesInPath.getINodes()[i];
        return inode.asDirectory().getSnapshot(DFSUtil.string2Bytes((String)name));
    }

    static void assertSnapshot(INodesInPath inodesInPath, boolean isSnapshot, Snapshot snapshot, int index) {
        Assert.assertEquals((Object)isSnapshot, (Object)inodesInPath.isSnapshot());
        Assert.assertEquals((long)index, (long)inodesInPath.getSnapshotRootIndex());
        Assert.assertEquals((long)Snapshot.getSnapshotId((Snapshot)(isSnapshot ? snapshot : null)), (long)inodesInPath.getPathSnapshotId());
        if (!isSnapshot) {
            Assert.assertEquals((long)Snapshot.getSnapshotId((Snapshot)snapshot), (long)inodesInPath.getLatestSnapshotId());
        }
        if (isSnapshot && index >= 0) {
            Assert.assertEquals(Snapshot.Root.class, inodesInPath.getINodes()[index].getClass());
        }
    }

    static void assertINodeFile(INode inode, Path path) {
        Assert.assertEquals((Object)path.getName(), (Object)inode.getLocalName());
        Assert.assertEquals(INodeFile.class, inode.getClass());
    }

    @Test(timeout=15000L)
    public void testNonSnapshotPathINodes() throws Exception {
        String[] names = INode.getPathNames((String)file1.toString());
        byte[][] components = INode.getPathComponents((String[])names);
        INodesInPath nodesInPath = INodesInPath.resolve((INodeDirectory)TestSnapshotPathINodes.fsdir.rootDir, (byte[][])components);
        INode[] inodes = nodesInPath.getINodes();
        Assert.assertEquals((long)inodes.length, (long)components.length);
        TestSnapshotPathINodes.assertSnapshot(nodesInPath, false, null, -1);
        Assert.assertTrue((String)("file1=" + file1 + ", nodesInPath=" + nodesInPath), (inodes[components.length - 1] != null ? 1 : 0) != 0);
        Assert.assertEquals((Object)inodes[components.length - 1].getFullPathName(), (Object)file1.toString());
        Assert.assertEquals((Object)inodes[components.length - 2].getFullPathName(), (Object)sub1.toString());
        Assert.assertEquals((Object)inodes[components.length - 3].getFullPathName(), (Object)dir.toString());
        nodesInPath = INodesInPath.resolve((INodeDirectory)TestSnapshotPathINodes.fsdir.rootDir, (byte[][])components, (int)1, (boolean)false);
        inodes = nodesInPath.getINodes();
        Assert.assertEquals((long)inodes.length, (long)1L);
        TestSnapshotPathINodes.assertSnapshot(nodesInPath, false, null, -1);
        Assert.assertEquals((Object)inodes[0].getFullPathName(), (Object)file1.toString());
        nodesInPath = INodesInPath.resolve((INodeDirectory)TestSnapshotPathINodes.fsdir.rootDir, (byte[][])components, (int)2, (boolean)false);
        inodes = nodesInPath.getINodes();
        Assert.assertEquals((long)inodes.length, (long)2L);
        TestSnapshotPathINodes.assertSnapshot(nodesInPath, false, null, -1);
        Assert.assertEquals((Object)inodes[1].getFullPathName(), (Object)file1.toString());
        Assert.assertEquals((Object)inodes[0].getFullPathName(), (Object)sub1.toString());
    }

    @Test(timeout=15000L)
    public void testSnapshotPathINodes() throws Exception {
        hdfs.allowSnapshot(sub1);
        hdfs.createSnapshot(sub1, "s1");
        String snapshotPath = sub1.toString() + "/.snapshot/s1/file1";
        String[] names = INode.getPathNames((String)snapshotPath);
        byte[][] components = INode.getPathComponents((String[])names);
        INodesInPath nodesInPath = INodesInPath.resolve((INodeDirectory)TestSnapshotPathINodes.fsdir.rootDir, (byte[][])components);
        INode[] inodes = nodesInPath.getINodes();
        Assert.assertEquals((long)inodes.length, (long)(components.length - 1));
        Snapshot snapshot = TestSnapshotPathINodes.getSnapshot(nodesInPath, "s1");
        TestSnapshotPathINodes.assertSnapshot(nodesInPath, true, snapshot, 3);
        INode snapshotFileNode = inodes[inodes.length - 1];
        TestSnapshotPathINodes.assertINodeFile(snapshotFileNode, file1);
        Assert.assertTrue((boolean)snapshotFileNode.getParent().isWithSnapshot());
        nodesInPath = INodesInPath.resolve((INodeDirectory)TestSnapshotPathINodes.fsdir.rootDir, (byte[][])components, (int)1, (boolean)false);
        inodes = nodesInPath.getINodes();
        Assert.assertEquals((long)inodes.length, (long)1L);
        TestSnapshotPathINodes.assertSnapshot(nodesInPath, true, snapshot, -1);
        TestSnapshotPathINodes.assertINodeFile(inodes[inodes.length - 1], file1);
        nodesInPath = INodesInPath.resolve((INodeDirectory)TestSnapshotPathINodes.fsdir.rootDir, (byte[][])components, (int)2, (boolean)false);
        inodes = nodesInPath.getINodes();
        Assert.assertEquals((long)inodes.length, (long)2L);
        TestSnapshotPathINodes.assertSnapshot(nodesInPath, true, snapshot, 0);
        TestSnapshotPathINodes.assertINodeFile(inodes[inodes.length - 1], file1);
        String dotSnapshotPath = sub1.toString() + "/.snapshot";
        names = INode.getPathNames((String)dotSnapshotPath);
        components = INode.getPathComponents((String[])names);
        nodesInPath = INodesInPath.resolve((INodeDirectory)TestSnapshotPathINodes.fsdir.rootDir, (byte[][])components);
        inodes = nodesInPath.getINodes();
        Assert.assertEquals((long)inodes.length, (long)(components.length - 1));
        TestSnapshotPathINodes.assertSnapshot(nodesInPath, true, snapshot, -1);
        INode last = inodes[inodes.length - 1];
        Assert.assertEquals((Object)last.getFullPathName(), (Object)sub1.toString());
        Assert.assertFalse((boolean)(last instanceof INodeFile));
        String[] invalidPathComponent = new String[]{"invalidDir", "foo", ".snapshot", "bar"};
        Path invalidPath = new Path(invalidPathComponent[0]);
        for (int i = 1; i < invalidPathComponent.length; ++i) {
            invalidPath = new Path(invalidPath, invalidPathComponent[i]);
            try {
                hdfs.getFileStatus(invalidPath);
                Assert.fail();
                continue;
            }
            catch (FileNotFoundException fnfe) {
                System.out.println("The exception is expected: " + fnfe);
            }
        }
        hdfs.deleteSnapshot(sub1, "s1");
        hdfs.disallowSnapshot(sub1);
    }

    @Test(timeout=15000L)
    public void testSnapshotPathINodesAfterDeletion() throws Exception {
        hdfs.allowSnapshot(sub1);
        hdfs.createSnapshot(sub1, "s2");
        hdfs.delete(file1, false);
        String snapshotPath = sub1.toString() + "/.snapshot/s2/file1";
        String[] names = INode.getPathNames((String)snapshotPath);
        byte[][] components = INode.getPathComponents((String[])names);
        INodesInPath nodesInPath = INodesInPath.resolve((INodeDirectory)TestSnapshotPathINodes.fsdir.rootDir, (byte[][])components);
        INode[] inodes = nodesInPath.getINodes();
        Assert.assertEquals((long)inodes.length, (long)(components.length - 1));
        Snapshot snapshot = TestSnapshotPathINodes.getSnapshot(nodesInPath, "s2");
        TestSnapshotPathINodes.assertSnapshot(nodesInPath, true, snapshot, 3);
        INode inode = inodes[inodes.length - 1];
        Assert.assertEquals((Object)file1.getName(), (Object)inode.getLocalName());
        Assert.assertTrue((boolean)inode.asFile().isWithSnapshot());
        String[] names2 = INode.getPathNames((String)file1.toString());
        byte[][] components2 = INode.getPathComponents((String[])names2);
        INodesInPath nodesInPath2 = INodesInPath.resolve((INodeDirectory)TestSnapshotPathINodes.fsdir.rootDir, (byte[][])components2);
        INode[] inodes2 = nodesInPath2.getINodes();
        Assert.assertEquals((long)inodes2.length, (long)components2.length);
        Assert.assertEquals((long)nodesInPath2.getNumNonNull(), (long)(components2.length - 1));
        TestSnapshotPathINodes.assertSnapshot(nodesInPath2, false, snapshot, -1);
        Assert.assertNull((Object)inodes2[components2.length - 1]);
        Assert.assertEquals((Object)inodes2[components2.length - 2].getFullPathName(), (Object)sub1.toString());
        Assert.assertEquals((Object)inodes2[components2.length - 3].getFullPathName(), (Object)dir.toString());
        hdfs.deleteSnapshot(sub1, "s2");
        hdfs.disallowSnapshot(sub1);
    }

    @Test(timeout=15000L)
    public void testSnapshotPathINodesWithAddedFile() throws Exception {
        hdfs.allowSnapshot(sub1);
        hdfs.createSnapshot(sub1, "s4");
        Path file3 = new Path(sub1, "file3");
        DFSTestUtil.createFile((FileSystem)hdfs, file3, 1024L, (short)3, 0L);
        String snapshotPath = sub1.toString() + "/.snapshot/s4/file3";
        String[] names = INode.getPathNames((String)snapshotPath);
        byte[][] components = INode.getPathComponents((String[])names);
        INodesInPath nodesInPath = INodesInPath.resolve((INodeDirectory)TestSnapshotPathINodes.fsdir.rootDir, (byte[][])components);
        INode[] inodes = nodesInPath.getINodes();
        Assert.assertEquals((long)inodes.length, (long)(components.length - 1));
        Assert.assertEquals((long)nodesInPath.getNumNonNull(), (long)(components.length - 2));
        s4 = TestSnapshotPathINodes.getSnapshot(nodesInPath, "s4");
        TestSnapshotPathINodes.assertSnapshot(nodesInPath, true, s4, 3);
        Assert.assertNull((Object)inodes[inodes.length - 1]);
        String[] names2 = INode.getPathNames((String)file3.toString());
        byte[][] components2 = INode.getPathComponents((String[])names2);
        INodesInPath nodesInPath2 = INodesInPath.resolve((INodeDirectory)TestSnapshotPathINodes.fsdir.rootDir, (byte[][])components2);
        INode[] inodes2 = nodesInPath2.getINodes();
        Assert.assertEquals((long)inodes2.length, (long)components2.length);
        TestSnapshotPathINodes.assertSnapshot(nodesInPath2, false, s4, -1);
        Assert.assertEquals((Object)inodes2[components2.length - 1].getFullPathName(), (Object)file3.toString());
        Assert.assertEquals((Object)inodes2[components2.length - 2].getFullPathName(), (Object)sub1.toString());
        Assert.assertEquals((Object)inodes2[components2.length - 3].getFullPathName(), (Object)dir.toString());
        hdfs.deleteSnapshot(sub1, "s4");
        hdfs.disallowSnapshot(sub1);
    }

    @Test(timeout=15000L)
    public void testSnapshotPathINodesAfterModification() throws Exception {
        String[] names = INode.getPathNames((String)file1.toString());
        byte[][] components = INode.getPathComponents((String[])names);
        INodesInPath nodesInPath = INodesInPath.resolve((INodeDirectory)TestSnapshotPathINodes.fsdir.rootDir, (byte[][])components);
        INode[] inodes = nodesInPath.getINodes();
        Assert.assertEquals((long)inodes.length, (long)components.length);
        Assert.assertEquals((Object)inodes[components.length - 1].getFullPathName(), (Object)file1.toString());
        long modTime = inodes[inodes.length - 1].getModificationTime();
        hdfs.allowSnapshot(sub1);
        hdfs.createSnapshot(sub1, "s3");
        DFSTestUtil.appendFile((FileSystem)hdfs, file1, "the content for appending");
        String snapshotPath = sub1.toString() + "/.snapshot/s3/file1";
        names = INode.getPathNames((String)snapshotPath);
        components = INode.getPathComponents((String[])names);
        INodesInPath ssNodesInPath = INodesInPath.resolve((INodeDirectory)TestSnapshotPathINodes.fsdir.rootDir, (byte[][])components);
        INode[] ssInodes = ssNodesInPath.getINodes();
        Assert.assertEquals((long)ssInodes.length, (long)(components.length - 1));
        Snapshot s3 = TestSnapshotPathINodes.getSnapshot(ssNodesInPath, "s3");
        TestSnapshotPathINodes.assertSnapshot(ssNodesInPath, true, s3, 3);
        INode snapshotFileNode = ssInodes[ssInodes.length - 1];
        Assert.assertEquals((Object)snapshotFileNode.getLocalName(), (Object)file1.getName());
        Assert.assertTrue((boolean)snapshotFileNode.asFile().isWithSnapshot());
        Assert.assertEquals((long)modTime, (long)snapshotFileNode.getModificationTime(ssNodesInPath.getPathSnapshotId()));
        names = INode.getPathNames((String)file1.toString());
        components = INode.getPathComponents((String[])names);
        INodesInPath newNodesInPath = INodesInPath.resolve((INodeDirectory)TestSnapshotPathINodes.fsdir.rootDir, (byte[][])components);
        TestSnapshotPathINodes.assertSnapshot(newNodesInPath, false, s3, -1);
        INode[] newInodes = newNodesInPath.getINodes();
        Assert.assertEquals((long)newInodes.length, (long)components.length);
        int last = components.length - 1;
        Assert.assertEquals((Object)newInodes[last].getFullPathName(), (Object)file1.toString());
        Assert.assertFalse((modTime == newInodes[last].getModificationTime() ? 1 : 0) != 0);
        hdfs.deleteSnapshot(sub1, "s3");
        hdfs.disallowSnapshot(sub1);
    }
}

