/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.util.EnumSet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.XAttr;
import org.apache.hadoop.fs.XAttrSetFlag;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSInotifyEventInputStream;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.inotify.Event;
import org.apache.hadoop.hdfs.inotify.MissingEventsException;
import org.apache.hadoop.hdfs.qjournal.MiniQJMHACluster;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogOpCodes;
import org.apache.hadoop.hdfs.server.namenode.ha.HATestUtil;
import org.apache.hadoop.util.ExitUtil;
import org.junit.Assert;
import org.junit.Test;

public class TestDFSInotifyEventInputStream {
    private static final int BLOCK_SIZE = 1024;
    private static final Log LOG = LogFactory.getLog(TestDFSInotifyEventInputStream.class);

    private static Event waitForNextEvent(DFSInotifyEventInputStream eis) throws IOException, MissingEventsException {
        Event next = null;
        while ((next = eis.poll()) == null) {
        }
        return next;
    }

    @Test
    public void testOpcodeCount() {
        Assert.assertTrue((FSEditLogOpCodes.values().length == 47 ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=120000L)
    public void testBasic() throws IOException, URISyntaxException, InterruptedException, MissingEventsException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setLong("dfs.blocksize", 1024L);
        conf.setBoolean("dfs.namenode.acls.enabled", true);
        conf.setLong("dfs.namenode.accesstime.precision", 1L);
        MiniQJMHACluster.Builder builder = new MiniQJMHACluster.Builder((Configuration)conf);
        builder.getDfsBuilder().numDataNodes(2);
        MiniQJMHACluster cluster = builder.build();
        try {
            cluster.getDfsCluster().waitActive();
            cluster.getDfsCluster().transitionToActive(0);
            DFSClient client = new DFSClient(cluster.getDfsCluster().getNameNode(0).getNameNodeAddress(), (Configuration)conf);
            DistributedFileSystem fs = cluster.getDfsCluster().getFileSystem(0);
            DFSTestUtil.createFile((FileSystem)fs, new Path("/file"), 1024L, (short)1, 0L);
            DFSTestUtil.createFile((FileSystem)fs, new Path("/file3"), 1024L, (short)1, 0L);
            DFSTestUtil.createFile((FileSystem)fs, new Path("/file5"), 1024L, (short)1, 0L);
            DFSInotifyEventInputStream eis = client.getInotifyEventStream();
            client.rename("/file", "/file4", null);
            client.rename("/file4", "/file2");
            OutputStream os = client.create("/file2", true, (short)2, 1024L);
            os.write(new byte[1024]);
            os.close();
            os = client.append("/file2", 1024, null, null);
            os.write(new byte[1024]);
            os.close();
            Thread.sleep(10L);
            client.open("/file2").read(new byte[1]);
            client.setReplication("/file2", (short)1);
            client.concat("/file2", new String[]{"/file3"});
            client.delete("/file2", false);
            client.mkdirs("/dir", null, false);
            client.setPermission("/dir", FsPermission.valueOf((String)"-rw-rw-rw-"));
            client.setOwner("/dir", "username", "groupname");
            client.createSymlink("/dir", "/dir2", false);
            client.setXAttr("/file5", "user.field", "value".getBytes(), EnumSet.of(XAttrSetFlag.CREATE));
            client.removeXAttr("/file5", "user.field");
            client.setAcl("/file5", AclEntry.parseAclSpec((String)"user::rwx,user:foo:rw-,group::r--,other::---", (boolean)true));
            client.removeAcl("/file5");
            Event next = null;
            next = TestDFSInotifyEventInputStream.waitForNextEvent(eis);
            Assert.assertTrue((next.getEventType() == Event.EventType.RENAME ? 1 : 0) != 0);
            Event.RenameEvent re = (Event.RenameEvent)next;
            Assert.assertTrue((boolean)re.getDstPath().equals("/file4"));
            Assert.assertTrue((boolean)re.getSrcPath().equals("/file"));
            Assert.assertTrue((re.getTimestamp() > 0L ? 1 : 0) != 0);
            long eventsBehind = eis.getEventsBehindEstimate();
            next = TestDFSInotifyEventInputStream.waitForNextEvent(eis);
            Assert.assertTrue((next.getEventType() == Event.EventType.RENAME ? 1 : 0) != 0);
            Event.RenameEvent re2 = (Event.RenameEvent)next;
            Assert.assertTrue((boolean)re2.getDstPath().equals("/file2"));
            Assert.assertTrue((boolean)re2.getSrcPath().equals("/file4"));
            Assert.assertTrue((re.getTimestamp() > 0L ? 1 : 0) != 0);
            next = TestDFSInotifyEventInputStream.waitForNextEvent(eis);
            Assert.assertTrue((next.getEventType() == Event.EventType.CREATE ? 1 : 0) != 0);
            Event.CreateEvent ce = (Event.CreateEvent)next;
            Assert.assertTrue((ce.getiNodeType() == Event.CreateEvent.INodeType.FILE ? 1 : 0) != 0);
            Assert.assertTrue((boolean)ce.getPath().equals("/file2"));
            Assert.assertTrue((ce.getCtime() > 0L ? 1 : 0) != 0);
            Assert.assertTrue((ce.getReplication() > 0 ? 1 : 0) != 0);
            Assert.assertTrue((ce.getSymlinkTarget() == null ? 1 : 0) != 0);
            Assert.assertTrue((boolean)ce.getOverwrite());
            next = TestDFSInotifyEventInputStream.waitForNextEvent(eis);
            Assert.assertTrue((next.getEventType() == Event.EventType.CLOSE ? 1 : 0) != 0);
            Event.CloseEvent ce2 = (Event.CloseEvent)next;
            Assert.assertTrue((boolean)ce2.getPath().equals("/file2"));
            Assert.assertTrue((ce2.getFileSize() > 0L ? 1 : 0) != 0);
            Assert.assertTrue((ce2.getTimestamp() > 0L ? 1 : 0) != 0);
            next = TestDFSInotifyEventInputStream.waitForNextEvent(eis);
            Assert.assertTrue((next.getEventType() == Event.EventType.APPEND ? 1 : 0) != 0);
            Assert.assertTrue((boolean)((Event.AppendEvent)next).getPath().equals("/file2"));
            next = TestDFSInotifyEventInputStream.waitForNextEvent(eis);
            Assert.assertTrue((next.getEventType() == Event.EventType.CLOSE ? 1 : 0) != 0);
            Assert.assertTrue((boolean)((Event.CloseEvent)next).getPath().equals("/file2"));
            next = TestDFSInotifyEventInputStream.waitForNextEvent(eis);
            Assert.assertTrue((next.getEventType() == Event.EventType.METADATA ? 1 : 0) != 0);
            Event.MetadataUpdateEvent mue = (Event.MetadataUpdateEvent)next;
            Assert.assertTrue((boolean)mue.getPath().equals("/file2"));
            Assert.assertTrue((mue.getMetadataType() == Event.MetadataUpdateEvent.MetadataType.TIMES ? 1 : 0) != 0);
            next = TestDFSInotifyEventInputStream.waitForNextEvent(eis);
            Assert.assertTrue((next.getEventType() == Event.EventType.METADATA ? 1 : 0) != 0);
            Event.MetadataUpdateEvent mue2 = (Event.MetadataUpdateEvent)next;
            Assert.assertTrue((boolean)mue2.getPath().equals("/file2"));
            Assert.assertTrue((mue2.getMetadataType() == Event.MetadataUpdateEvent.MetadataType.REPLICATION ? 1 : 0) != 0);
            Assert.assertTrue((mue2.getReplication() == 1 ? 1 : 0) != 0);
            next = TestDFSInotifyEventInputStream.waitForNextEvent(eis);
            Assert.assertTrue((next.getEventType() == Event.EventType.APPEND ? 1 : 0) != 0);
            Assert.assertTrue((boolean)((Event.AppendEvent)next).getPath().equals("/file2"));
            next = TestDFSInotifyEventInputStream.waitForNextEvent(eis);
            Assert.assertTrue((next.getEventType() == Event.EventType.UNLINK ? 1 : 0) != 0);
            Event.UnlinkEvent ue2 = (Event.UnlinkEvent)next;
            Assert.assertTrue((boolean)ue2.getPath().equals("/file3"));
            Assert.assertTrue((ue2.getTimestamp() > 0L ? 1 : 0) != 0);
            next = TestDFSInotifyEventInputStream.waitForNextEvent(eis);
            Assert.assertTrue((next.getEventType() == Event.EventType.CLOSE ? 1 : 0) != 0);
            Event.CloseEvent ce3 = (Event.CloseEvent)next;
            Assert.assertTrue((boolean)ce3.getPath().equals("/file2"));
            Assert.assertTrue((ce3.getTimestamp() > 0L ? 1 : 0) != 0);
            next = TestDFSInotifyEventInputStream.waitForNextEvent(eis);
            Assert.assertTrue((next.getEventType() == Event.EventType.UNLINK ? 1 : 0) != 0);
            Event.UnlinkEvent ue = (Event.UnlinkEvent)next;
            Assert.assertTrue((boolean)ue.getPath().equals("/file2"));
            Assert.assertTrue((ue.getTimestamp() > 0L ? 1 : 0) != 0);
            next = TestDFSInotifyEventInputStream.waitForNextEvent(eis);
            Assert.assertTrue((next.getEventType() == Event.EventType.CREATE ? 1 : 0) != 0);
            Event.CreateEvent ce4 = (Event.CreateEvent)next;
            Assert.assertTrue((ce4.getiNodeType() == Event.CreateEvent.INodeType.DIRECTORY ? 1 : 0) != 0);
            Assert.assertTrue((boolean)ce4.getPath().equals("/dir"));
            Assert.assertTrue((ce4.getCtime() > 0L ? 1 : 0) != 0);
            Assert.assertTrue((ce4.getReplication() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((ce4.getSymlinkTarget() == null ? 1 : 0) != 0);
            next = TestDFSInotifyEventInputStream.waitForNextEvent(eis);
            Assert.assertTrue((next.getEventType() == Event.EventType.METADATA ? 1 : 0) != 0);
            Event.MetadataUpdateEvent mue3 = (Event.MetadataUpdateEvent)next;
            Assert.assertTrue((boolean)mue3.getPath().equals("/dir"));
            Assert.assertTrue((mue3.getMetadataType() == Event.MetadataUpdateEvent.MetadataType.PERMS ? 1 : 0) != 0);
            Assert.assertTrue((boolean)mue3.getPerms().toString().contains("rw-rw-rw-"));
            next = TestDFSInotifyEventInputStream.waitForNextEvent(eis);
            Assert.assertTrue((next.getEventType() == Event.EventType.METADATA ? 1 : 0) != 0);
            Event.MetadataUpdateEvent mue4 = (Event.MetadataUpdateEvent)next;
            Assert.assertTrue((boolean)mue4.getPath().equals("/dir"));
            Assert.assertTrue((mue4.getMetadataType() == Event.MetadataUpdateEvent.MetadataType.OWNER ? 1 : 0) != 0);
            Assert.assertTrue((boolean)mue4.getOwnerName().equals("username"));
            Assert.assertTrue((boolean)mue4.getGroupName().equals("groupname"));
            next = TestDFSInotifyEventInputStream.waitForNextEvent(eis);
            Assert.assertTrue((next.getEventType() == Event.EventType.CREATE ? 1 : 0) != 0);
            Event.CreateEvent ce5 = (Event.CreateEvent)next;
            Assert.assertTrue((ce5.getiNodeType() == Event.CreateEvent.INodeType.SYMLINK ? 1 : 0) != 0);
            Assert.assertTrue((boolean)ce5.getPath().equals("/dir2"));
            Assert.assertTrue((ce5.getCtime() > 0L ? 1 : 0) != 0);
            Assert.assertTrue((ce5.getReplication() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)ce5.getSymlinkTarget().equals("/dir"));
            next = TestDFSInotifyEventInputStream.waitForNextEvent(eis);
            Assert.assertTrue((next.getEventType() == Event.EventType.METADATA ? 1 : 0) != 0);
            Event.MetadataUpdateEvent mue5 = (Event.MetadataUpdateEvent)next;
            Assert.assertTrue((boolean)mue5.getPath().equals("/file5"));
            Assert.assertTrue((mue5.getMetadataType() == Event.MetadataUpdateEvent.MetadataType.XATTRS ? 1 : 0) != 0);
            Assert.assertTrue((mue5.getxAttrs().size() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)((XAttr)mue5.getxAttrs().get(0)).getName().contains("field"));
            Assert.assertTrue((!mue5.isxAttrsRemoved() ? 1 : 0) != 0);
            next = TestDFSInotifyEventInputStream.waitForNextEvent(eis);
            Assert.assertTrue((next.getEventType() == Event.EventType.METADATA ? 1 : 0) != 0);
            Event.MetadataUpdateEvent mue6 = (Event.MetadataUpdateEvent)next;
            Assert.assertTrue((boolean)mue6.getPath().equals("/file5"));
            Assert.assertTrue((mue6.getMetadataType() == Event.MetadataUpdateEvent.MetadataType.XATTRS ? 1 : 0) != 0);
            Assert.assertTrue((mue6.getxAttrs().size() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)((XAttr)mue6.getxAttrs().get(0)).getName().contains("field"));
            Assert.assertTrue((boolean)mue6.isxAttrsRemoved());
            next = TestDFSInotifyEventInputStream.waitForNextEvent(eis);
            Assert.assertTrue((next.getEventType() == Event.EventType.METADATA ? 1 : 0) != 0);
            Event.MetadataUpdateEvent mue7 = (Event.MetadataUpdateEvent)next;
            Assert.assertTrue((boolean)mue7.getPath().equals("/file5"));
            Assert.assertTrue((mue7.getMetadataType() == Event.MetadataUpdateEvent.MetadataType.ACLS ? 1 : 0) != 0);
            Assert.assertTrue((boolean)mue7.getAcls().contains(AclEntry.parseAclEntry((String)"user::rwx", (boolean)true)));
            next = TestDFSInotifyEventInputStream.waitForNextEvent(eis);
            Assert.assertTrue((next.getEventType() == Event.EventType.METADATA ? 1 : 0) != 0);
            Event.MetadataUpdateEvent mue8 = (Event.MetadataUpdateEvent)next;
            Assert.assertTrue((boolean)mue8.getPath().equals("/file5"));
            Assert.assertTrue((mue8.getMetadataType() == Event.MetadataUpdateEvent.MetadataType.ACLS ? 1 : 0) != 0);
            Assert.assertTrue((mue8.getAcls() == null ? 1 : 0) != 0);
            Assert.assertTrue((eis.poll() == null ? 1 : 0) != 0);
            Assert.assertTrue((eis.getEventsBehindEstimate() == eventsBehind ? 1 : 0) != 0);
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=120000L)
    public void testNNFailover() throws IOException, URISyntaxException, MissingEventsException {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniQJMHACluster cluster = new MiniQJMHACluster.Builder((Configuration)conf).build();
        try {
            cluster.getDfsCluster().waitActive();
            cluster.getDfsCluster().transitionToActive(0);
            DFSClient client = ((DistributedFileSystem)HATestUtil.configureFailoverFs((MiniDFSCluster)cluster.getDfsCluster(), (Configuration)conf)).dfs;
            DFSInotifyEventInputStream eis = client.getInotifyEventStream();
            for (int i = 0; i < 10; ++i) {
                client.mkdirs("/dir" + i, null, false);
            }
            cluster.getDfsCluster().shutdownNameNode(0);
            cluster.getDfsCluster().transitionToActive(1);
            Event next = null;
            for (int i = 0; i < 10; ++i) {
                next = TestDFSInotifyEventInputStream.waitForNextEvent(eis);
                Assert.assertTrue((next.getEventType() == Event.EventType.CREATE ? 1 : 0) != 0);
                Assert.assertTrue((boolean)((Event.CreateEvent)next).getPath().equals("/dir" + i));
            }
            Assert.assertTrue((eis.poll() == null ? 1 : 0) != 0);
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=120000L)
    public void testTwoActiveNNs() throws IOException, MissingEventsException {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniQJMHACluster cluster = new MiniQJMHACluster.Builder((Configuration)conf).build();
        try {
            int i;
            cluster.getDfsCluster().waitActive();
            cluster.getDfsCluster().transitionToActive(0);
            DFSClient client0 = new DFSClient(cluster.getDfsCluster().getNameNode(0).getNameNodeAddress(), (Configuration)conf);
            DFSClient client1 = new DFSClient(cluster.getDfsCluster().getNameNode(1).getNameNodeAddress(), (Configuration)conf);
            DFSInotifyEventInputStream eis = client0.getInotifyEventStream();
            for (i = 0; i < 10; ++i) {
                client0.mkdirs("/dir" + i, null, false);
            }
            cluster.getDfsCluster().transitionToActive(1);
            for (i = 10; i < 20; ++i) {
                client1.mkdirs("/dir" + i, null, false);
            }
            Event next = null;
            for (int i2 = 0; i2 < 10; ++i2) {
                next = TestDFSInotifyEventInputStream.waitForNextEvent(eis);
                Assert.assertTrue((next.getEventType() == Event.EventType.CREATE ? 1 : 0) != 0);
                Assert.assertTrue((boolean)((Event.CreateEvent)next).getPath().equals("/dir" + i2));
            }
            Assert.assertTrue((eis.poll() == null ? 1 : 0) != 0);
        }
        finally {
            try {
                cluster.shutdown();
            }
            catch (ExitUtil.ExitException exitException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=120000L)
    public void testReadEventsWithTimeout() throws IOException, InterruptedException, MissingEventsException {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniQJMHACluster cluster = new MiniQJMHACluster.Builder((Configuration)conf).build();
        try {
            cluster.getDfsCluster().waitActive();
            cluster.getDfsCluster().transitionToActive(0);
            final DFSClient client = new DFSClient(cluster.getDfsCluster().getNameNode(0).getNameNodeAddress(), (Configuration)conf);
            DFSInotifyEventInputStream eis = client.getInotifyEventStream();
            ScheduledExecutorService ex = Executors.newSingleThreadScheduledExecutor();
            ex.schedule(new Runnable(){

                @Override
                public void run() {
                    try {
                        client.mkdirs("/dir", null, false);
                    }
                    catch (IOException e) {
                        LOG.error((Object)"Unable to create /dir", (Throwable)e);
                    }
                }
            }, 1L, TimeUnit.SECONDS);
            Event next = eis.poll(5L, TimeUnit.SECONDS);
            Assert.assertTrue((next != null ? 1 : 0) != 0);
            Assert.assertTrue((next.getEventType() == Event.EventType.CREATE ? 1 : 0) != 0);
            Assert.assertTrue((boolean)((Event.CreateEvent)next).getPath().equals("/dir"));
        }
        finally {
            cluster.shutdown();
        }
    }
}

