/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.File;
import java.io.IOException;
import java.net.BindException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.After;
import org.junit.Test;

public class TestValidateConfigurationSettings {
    @After
    public void cleanUp() {
        FileUtil.fullyDeleteContents((File)new File(MiniDFSCluster.getBaseDirectory()));
    }

    @Test(expected=BindException.class)
    public void testThatMatchingRPCandHttpPortsThrowException() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        File nameDir = new File(MiniDFSCluster.getBaseDirectory(), "name");
        conf.set("dfs.namenode.name.dir", nameDir.getAbsolutePath());
        FileSystem.setDefaultUri((Configuration)conf, (String)"hdfs://localhost:9000");
        conf.set("dfs.namenode.http-address", "127.0.0.1:9000");
        DFSTestUtil.formatNameNode((Configuration)conf);
        new NameNode((Configuration)conf);
    }

    @Test
    public void testThatDifferentRPCandHttpPortsAreOK() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        File nameDir = new File(MiniDFSCluster.getBaseDirectory(), "name");
        conf.set("dfs.namenode.name.dir", nameDir.getAbsolutePath());
        FileSystem.setDefaultUri((Configuration)conf, (String)"hdfs://localhost:8000");
        conf.set("dfs.namenode.http-address", "127.0.0.1:9000");
        DFSTestUtil.formatNameNode((Configuration)conf);
        NameNode nameNode = new NameNode((Configuration)conf);
        nameNode.stop();
    }

    @Test
    public void testGenericKeysForNameNodeFormat() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.namenode.rpc-address", "127.0.0.1:0");
        conf.set("dfs.namenode.http-address", "127.0.0.1:0");
        conf.set("dfs.nameservices", "ns1");
        File dir = new File(MiniDFSCluster.getBaseDirectory(), "testGenericKeysForNameNodeFormat");
        if (dir.exists()) {
            FileUtil.fullyDelete((File)dir);
        }
        conf.set("dfs.namenode.name.dir.ns1", dir.getAbsolutePath());
        DFSTestUtil.formatNameNode((Configuration)conf);
        GenericTestUtils.assertExists((File)dir);
        NameNode nameNode = new NameNode((Configuration)conf);
        nameNode.stop();
    }
}

