/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.datatransfer.Sender;
import org.apache.hadoop.hdfs.protocol.proto.DataTransferProtos;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenSecretManager;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.util.DataTransferThrottler;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.util.Time;
import org.junit.Assert;
import org.junit.Test;

public class TestBlockReplacement {
    private static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.hdfs.TestBlockReplacement");
    MiniDFSCluster cluster;

    @Test
    public void testThrottler() throws IOException {
        long TOTAL_BYTES;
        HdfsConfiguration conf = new HdfsConfiguration();
        FileSystem.setDefaultUri((Configuration)conf, (String)"hdfs://localhost:0");
        long bandwidthPerSec = 0x100000L;
        long bytesToSend = TOTAL_BYTES = 6L * bandwidthPerSec;
        long start = Time.now();
        DataTransferThrottler throttler = new DataTransferThrottler(bandwidthPerSec);
        long totalBytes = 0L;
        long bytesSent = 524288L;
        throttler.throttle(bytesSent);
        bytesToSend -= bytesSent;
        bytesSent = 786432L;
        throttler.throttle(bytesSent);
        bytesToSend -= bytesSent;
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ignored) {
            // empty catch block
        }
        throttler.throttle(bytesToSend);
        long end = Time.now();
        Assert.assertTrue((totalBytes * 1000L / (end - start) <= bandwidthPerSec ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBlockReplacement() throws Exception {
        HdfsConfiguration CONF = new HdfsConfiguration();
        String[] INITIAL_RACKS = new String[]{"/RACK0", "/RACK1", "/RACK2"};
        String[] NEW_RACKS = new String[]{"/RACK2"};
        int REPLICATION_FACTOR = 3;
        int DEFAULT_BLOCK_SIZE = 1024;
        Random r = new Random();
        CONF.setLong("dfs.blocksize", 1024L);
        CONF.setInt("dfs.bytes-per-checksum", 512);
        CONF.setLong("dfs.blockreport.intervalMsec", 500L);
        this.cluster = new MiniDFSCluster.Builder((Configuration)CONF).numDataNodes(3).racks(INITIAL_RACKS).build();
        try {
            this.cluster.waitActive();
            DistributedFileSystem fs = this.cluster.getFileSystem();
            Path fileName = new Path("/tmp.txt");
            DFSTestUtil.createFile((FileSystem)fs, fileName, 1024L, (short)3, r.nextLong());
            DFSTestUtil.waitReplication((FileSystem)fs, fileName, (short)3);
            InetSocketAddress addr = new InetSocketAddress("localhost", this.cluster.getNameNodePort());
            DFSClient client = new DFSClient(addr, (Configuration)CONF);
            List locatedBlocks = client.getNamenode().getBlockLocations("/tmp.txt", 0L, 1024L).getLocatedBlocks();
            Assert.assertEquals((long)1L, (long)locatedBlocks.size());
            LocatedBlock block = (LocatedBlock)locatedBlocks.get(0);
            DatanodeInfo[] oldNodes = block.getLocations();
            Assert.assertEquals((long)oldNodes.length, (long)3L);
            ExtendedBlock b = block.getBlock();
            this.cluster.startDataNodes((Configuration)CONF, 1, true, null, NEW_RACKS);
            this.cluster.waitActive();
            DatanodeInfo[] datanodes = client.datanodeReport(HdfsConstants.DatanodeReportType.ALL);
            DatanodeInfo newNode = null;
            for (DatanodeInfo node : datanodes) {
                Boolean isNewNode = true;
                for (DatanodeInfo oldNode : oldNodes) {
                    if (!node.equals((Object)oldNode)) continue;
                    isNewNode = false;
                    break;
                }
                if (!isNewNode.booleanValue()) continue;
                newNode = node;
                break;
            }
            Assert.assertTrue((newNode != null ? 1 : 0) != 0);
            DatanodeInfo source = null;
            ArrayList<DatanodeInfo> proxies = new ArrayList<DatanodeInfo>(2);
            for (DatanodeInfo node : datanodes) {
                if (node == newNode) continue;
                if (node.getNetworkLocation().equals(newNode.getNetworkLocation())) {
                    source = node;
                    continue;
                }
                proxies.add(node);
            }
            Assert.assertTrue((source != null && proxies.size() == 2 ? 1 : 0) != 0);
            LOG.info((Object)("Testcase 1: Proxy " + newNode + " does not contain the block " + b));
            Assert.assertFalse((boolean)this.replaceBlock(b, source, newNode, (DatanodeInfo)proxies.get(0)));
            LOG.info((Object)("Testcase 2: Destination " + proxies.get(1) + " contains the block " + b));
            Assert.assertFalse((boolean)this.replaceBlock(b, source, (DatanodeInfo)proxies.get(0), (DatanodeInfo)proxies.get(1)));
            LOG.info((Object)("Testcase 3: Source=" + source + " Proxy=" + proxies.get(0) + " Destination=" + newNode));
            Assert.assertTrue((boolean)this.replaceBlock(b, source, (DatanodeInfo)proxies.get(0), newNode));
            this.checkBlocks(new DatanodeInfo[]{newNode, (DatanodeInfo)proxies.get(0), (DatanodeInfo)proxies.get(1)}, fileName.toString(), 1024L, (short)3, client);
            LOG.info((Object)("Testcase 4: invalid del hint " + proxies.get(0)));
            Assert.assertTrue((boolean)this.replaceBlock(b, (DatanodeInfo)proxies.get(0), (DatanodeInfo)proxies.get(1), source));
            this.checkBlocks(proxies.toArray(new DatanodeInfo[proxies.size()]), fileName.toString(), 1024L, (short)3, client);
        }
        finally {
            this.cluster.shutdown();
        }
    }

    private void checkBlocks(DatanodeInfo[] includeNodes, String fileName, long fileLen, short replFactor, DFSClient client) throws IOException, TimeoutException {
        boolean notDone;
        long TIMEOUT = 20000L;
        long starttime = Time.now();
        long failtime = starttime + 20000L;
        do {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            List blocks = client.getNamenode().getBlockLocations(fileName, 0L, fileLen).getLocatedBlocks();
            Assert.assertEquals((long)1L, (long)blocks.size());
            DatanodeInfo[] nodes = ((LocatedBlock)blocks.get(0)).getLocations();
            boolean bl = notDone = nodes.length != replFactor;
            if (notDone) {
                LOG.info((Object)("Expected replication factor is " + replFactor + " but the real replication factor is " + nodes.length));
            } else {
                List<DatanodeInfo> nodeLocations = Arrays.asList(nodes);
                for (DatanodeInfo node : includeNodes) {
                    if (nodeLocations.contains(node)) continue;
                    notDone = true;
                    LOG.info((Object)("Block is not located at " + node));
                    break;
                }
            }
            if (Time.now() <= failtime) continue;
            String expectedNodesList = "";
            String currentNodesList = "";
            for (DatanodeInfo dn : includeNodes) {
                expectedNodesList = expectedNodesList + dn + ", ";
            }
            for (DatanodeInfo dn : nodes) {
                currentNodesList = currentNodesList + dn + ", ";
            }
            LOG.info((Object)("Expected replica nodes are: " + expectedNodesList));
            LOG.info((Object)("Current actual replica nodes are: " + currentNodesList));
            throw new TimeoutException("Did not achieve expected replication to expected nodes after more than 20000 msec.  See logs for details.");
        } while (notDone);
        LOG.info((Object)("Achieved expected replication values in " + (Time.now() - starttime) + " msec."));
    }

    private boolean replaceBlock(ExtendedBlock block, DatanodeInfo source, DatanodeInfo sourceProxy, DatanodeInfo destination) throws IOException {
        Socket sock = new Socket();
        sock.connect(NetUtils.createSocketAddr((String)destination.getXferAddr()), HdfsServerConstants.READ_TIMEOUT);
        sock.setKeepAlive(true);
        DataOutputStream out = new DataOutputStream(sock.getOutputStream());
        new Sender(out).replaceBlock(block, BlockTokenSecretManager.DUMMY_TOKEN, source.getDatanodeUuid(), sourceProxy);
        out.flush();
        DataInputStream reply = new DataInputStream(sock.getInputStream());
        DataTransferProtos.BlockOpResponseProto proto = DataTransferProtos.BlockOpResponseProto.parseDelimitedFrom((InputStream)reply);
        return proto.getStatus() == DataTransferProtos.Status.SUCCESS;
    }

    public static void main(String[] args) throws Exception {
        new TestBlockReplacement().testBlockReplacement();
    }
}

