/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools.offlineEditsViewer;

import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogOpCodes;
import org.apache.hadoop.hdfs.tools.offlineEditsViewer.EditsElement;
import org.apache.hadoop.hdfs.tools.offlineEditsViewer.EditsVisitor;
import org.apache.hadoop.hdfs.tools.offlineEditsViewer.Tokenizer;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class StatisticsEditsVisitor
extends EditsVisitor {
    private boolean printToScreen = false;
    private boolean okToWrite = false;
    private final FileWriter fw;
    public final Map<FSEditLogOpCodes, Long> opCodeCount = new HashMap<FSEditLogOpCodes, Long>();

    public StatisticsEditsVisitor(String filename, Tokenizer tokenizer) throws IOException {
        this(filename, tokenizer, false);
    }

    public StatisticsEditsVisitor(String filename, Tokenizer tokenizer, boolean printToScreen) throws IOException {
        super(tokenizer);
        this.printToScreen = printToScreen;
        this.fw = new FileWriter(filename);
        this.okToWrite = true;
    }

    @Override
    void start() throws IOException {
    }

    @Override
    void finish() throws IOException {
        this.write(this.getStatisticsString());
        this.close();
    }

    @Override
    void finishAbnormally() throws IOException {
        this.close();
    }

    private void close() throws IOException {
        this.fw.close();
        this.okToWrite = false;
    }

    @Override
    void visitEnclosingElement(Tokenizer.Token value) throws IOException {
    }

    @Override
    void leaveEnclosingElement() throws IOException {
    }

    @Override
    Tokenizer.Token visit(Tokenizer.Token value) throws IOException {
        if (value.getEditsElement() == EditsElement.OPCODE) {
            if (value instanceof Tokenizer.ByteToken) {
                this.incrementOpCodeCount(FSEditLogOpCodes.fromByte(((Tokenizer.ByteToken)value).value));
            } else {
                throw new IOException("Token for EditsElement.OPCODE should be of type Tokenizer.ByteToken, not " + value.getClass());
            }
        }
        return value;
    }

    protected void write(String toWrite) throws IOException {
        if (!this.okToWrite) {
            throw new IOException("file not open for writing.");
        }
        if (this.printToScreen) {
            System.out.print(toWrite);
        }
        try {
            this.fw.write(toWrite);
        }
        catch (IOException e) {
            this.okToWrite = false;
            throw e;
        }
    }

    private void incrementOpCodeCount(FSEditLogOpCodes opCode) {
        if (!this.opCodeCount.containsKey((Object)opCode)) {
            this.opCodeCount.put(opCode, 0L);
        }
        Long newValue = this.opCodeCount.get((Object)opCode) + 1L;
        this.opCodeCount.put(opCode, newValue);
    }

    public Map<FSEditLogOpCodes, Long> getStatistics() {
        return this.opCodeCount;
    }

    public String getStatisticsString() {
        StringBuffer sb = new StringBuffer();
        for (FSEditLogOpCodes opCode : FSEditLogOpCodes.values()) {
            sb.append(String.format("    %-30.30s (%3d): %d%n", new Object[]{opCode, opCode.getOpCode(), this.opCodeCount.get((Object)opCode)}));
        }
        return sb.toString();
    }
}

