/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools.offlineEditsViewer;

import java.io.EOFException;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.protocol.LayoutVersion;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogOpCodes;
import org.apache.hadoop.hdfs.tools.offlineEditsViewer.EditsElement;
import org.apache.hadoop.hdfs.tools.offlineEditsViewer.EditsLoader;
import org.apache.hadoop.hdfs.tools.offlineEditsViewer.EditsVisitor;
import org.apache.hadoop.hdfs.tools.offlineEditsViewer.Tokenizer;

@InterfaceAudience.Private
@InterfaceStability.Unstable
class EditsLoaderCurrent
implements EditsLoader {
    private static int[] supportedVersions = new int[]{-18, -19, -20, -21, -22, -23, -24, -25, -26, -27, -28, -30, -31, -32, -33, -34, -35, -36, -37, -38, -39};
    private EditsVisitor v;
    private int editsVersion = 0;

    public EditsLoaderCurrent(EditsVisitor visitor) {
        this.v = visitor;
    }

    @Override
    public boolean canLoadVersion(int version) {
        for (int v : supportedVersions) {
            if (v != version) continue;
            return true;
        }
        return false;
    }

    private void visitTxId() throws IOException {
        if (LayoutVersion.supports(LayoutVersion.Feature.STORED_TXIDS, this.editsVersion)) {
            this.v.visitLong(EditsElement.TRANSACTION_ID);
        }
    }

    private void visit_OP_INVALID() throws IOException {
    }

    private void visit_OP_ADD() throws IOException {
        this.visit_OP_ADD_or_OP_CLOSE(FSEditLogOpCodes.OP_ADD);
    }

    private void visit_OP_CLOSE() throws IOException {
        this.visit_OP_ADD_or_OP_CLOSE(FSEditLogOpCodes.OP_CLOSE);
    }

    private void visit_OP_ADD_or_OP_CLOSE(FSEditLogOpCodes editsOpCode) throws IOException {
        this.visitTxId();
        if (!LayoutVersion.supports(LayoutVersion.Feature.EDITLOG_OP_OPTIMIZATION, this.editsVersion)) {
            Tokenizer.IntToken opAddLength = this.v.visitInt(EditsElement.LENGTH);
            if (opAddLength.value == 0) {
                throw new IOException("OpCode " + (Object)((Object)editsOpCode) + " has zero length (corrupted edits)");
            }
        }
        this.v.visitStringUTF8(EditsElement.PATH);
        if (LayoutVersion.supports(LayoutVersion.Feature.EDITLOG_OP_OPTIMIZATION, this.editsVersion)) {
            this.v.visitShort(EditsElement.REPLICATION);
            this.v.visitLong(EditsElement.MTIME);
            this.v.visitLong(EditsElement.ATIME);
            this.v.visitLong(EditsElement.BLOCKSIZE);
        } else {
            this.v.visitStringUTF8(EditsElement.REPLICATION);
            this.v.visitStringUTF8(EditsElement.MTIME);
            this.v.visitStringUTF8(EditsElement.ATIME);
            this.v.visitStringUTF8(EditsElement.BLOCKSIZE);
        }
        Tokenizer.IntToken numBlocksToken = this.v.visitInt(EditsElement.NUMBLOCKS);
        for (int i = 0; i < numBlocksToken.value; ++i) {
            this.v.visitEnclosingElement(EditsElement.BLOCK);
            this.v.visitLong(EditsElement.BLOCK_ID);
            this.v.visitLong(EditsElement.BLOCK_NUM_BYTES);
            this.v.visitLong(EditsElement.BLOCK_GENERATION_STAMP);
            this.v.leaveEnclosingElement();
        }
        this.v.visitEnclosingElement(EditsElement.PERMISSION_STATUS);
        this.v.visitStringText(EditsElement.USERNAME);
        this.v.visitStringText(EditsElement.GROUPNAME);
        this.v.visitShort(EditsElement.FS_PERMISSIONS);
        this.v.leaveEnclosingElement();
        if (editsOpCode == FSEditLogOpCodes.OP_ADD) {
            this.v.visitStringUTF8(EditsElement.CLIENT_NAME);
            this.v.visitStringUTF8(EditsElement.CLIENT_MACHINE);
        }
    }

    private void visit_OP_RENAME_OLD() throws IOException {
        this.visitTxId();
        if (!LayoutVersion.supports(LayoutVersion.Feature.EDITLOG_OP_OPTIMIZATION, this.editsVersion)) {
            this.v.visitInt(EditsElement.LENGTH);
        }
        this.v.visitStringUTF8(EditsElement.SOURCE);
        this.v.visitStringUTF8(EditsElement.DESTINATION);
        if (LayoutVersion.supports(LayoutVersion.Feature.EDITLOG_OP_OPTIMIZATION, this.editsVersion)) {
            this.v.visitLong(EditsElement.TIMESTAMP);
        } else {
            this.v.visitStringUTF8(EditsElement.TIMESTAMP);
        }
    }

    private void visit_OP_DELETE() throws IOException {
        this.visitTxId();
        if (!LayoutVersion.supports(LayoutVersion.Feature.EDITLOG_OP_OPTIMIZATION, this.editsVersion)) {
            this.v.visitInt(EditsElement.LENGTH);
        }
        this.v.visitStringUTF8(EditsElement.PATH);
        if (LayoutVersion.supports(LayoutVersion.Feature.EDITLOG_OP_OPTIMIZATION, this.editsVersion)) {
            this.v.visitLong(EditsElement.TIMESTAMP);
        } else {
            this.v.visitStringUTF8(EditsElement.TIMESTAMP);
        }
    }

    private void visit_OP_MKDIR() throws IOException {
        this.visitTxId();
        if (!LayoutVersion.supports(LayoutVersion.Feature.EDITLOG_OP_OPTIMIZATION, this.editsVersion)) {
            this.v.visitInt(EditsElement.LENGTH);
        }
        this.v.visitStringUTF8(EditsElement.PATH);
        if (LayoutVersion.supports(LayoutVersion.Feature.EDITLOG_OP_OPTIMIZATION, this.editsVersion)) {
            this.v.visitLong(EditsElement.TIMESTAMP);
            this.v.visitLong(EditsElement.ATIME);
        } else {
            this.v.visitStringUTF8(EditsElement.TIMESTAMP);
            this.v.visitStringUTF8(EditsElement.ATIME);
        }
        this.v.visitEnclosingElement(EditsElement.PERMISSION_STATUS);
        this.v.visitStringText(EditsElement.USERNAME);
        this.v.visitStringText(EditsElement.GROUPNAME);
        this.v.visitShort(EditsElement.FS_PERMISSIONS);
        this.v.leaveEnclosingElement();
    }

    private void visit_OP_SET_REPLICATION() throws IOException {
        this.visitTxId();
        this.v.visitStringUTF8(EditsElement.PATH);
        if (LayoutVersion.supports(LayoutVersion.Feature.EDITLOG_OP_OPTIMIZATION, this.editsVersion)) {
            this.v.visitShort(EditsElement.REPLICATION);
        } else {
            this.v.visitStringUTF8(EditsElement.REPLICATION);
        }
    }

    private void visit_OP_SET_PERMISSIONS() throws IOException {
        this.visitTxId();
        this.v.visitStringUTF8(EditsElement.PATH);
        this.v.visitShort(EditsElement.FS_PERMISSIONS);
    }

    private void visit_OP_SET_OWNER() throws IOException {
        this.visitTxId();
        this.v.visitStringUTF8(EditsElement.PATH);
        this.v.visitStringUTF8(EditsElement.USERNAME);
        this.v.visitStringUTF8(EditsElement.GROUPNAME);
    }

    private void visit_OP_SET_GENSTAMP() throws IOException {
        this.visitTxId();
        this.v.visitLong(EditsElement.GENERATION_STAMP);
    }

    private void visit_OP_TIMES() throws IOException {
        this.visitTxId();
        if (!LayoutVersion.supports(LayoutVersion.Feature.EDITLOG_OP_OPTIMIZATION, this.editsVersion)) {
            this.v.visitInt(EditsElement.LENGTH);
        }
        this.v.visitStringUTF8(EditsElement.PATH);
        if (LayoutVersion.supports(LayoutVersion.Feature.EDITLOG_OP_OPTIMIZATION, this.editsVersion)) {
            this.v.visitLong(EditsElement.MTIME);
            this.v.visitLong(EditsElement.ATIME);
        } else {
            this.v.visitStringUTF8(EditsElement.MTIME);
            this.v.visitStringUTF8(EditsElement.ATIME);
        }
    }

    private void visit_OP_SET_QUOTA() throws IOException {
        this.visitTxId();
        this.v.visitStringUTF8(EditsElement.PATH);
        this.v.visitLong(EditsElement.NS_QUOTA);
        this.v.visitLong(EditsElement.DS_QUOTA);
    }

    private void visit_OP_RENAME() throws IOException {
        this.visitTxId();
        if (!LayoutVersion.supports(LayoutVersion.Feature.EDITLOG_OP_OPTIMIZATION, this.editsVersion)) {
            this.v.visitInt(EditsElement.LENGTH);
        }
        this.v.visitStringUTF8(EditsElement.SOURCE);
        this.v.visitStringUTF8(EditsElement.DESTINATION);
        if (LayoutVersion.supports(LayoutVersion.Feature.EDITLOG_OP_OPTIMIZATION, this.editsVersion)) {
            this.v.visitLong(EditsElement.TIMESTAMP);
        } else {
            this.v.visitStringUTF8(EditsElement.TIMESTAMP);
        }
        this.v.visitBytesWritable(EditsElement.RENAME_OPTIONS);
    }

    private void visit_OP_CONCAT_DELETE() throws IOException {
        Tokenizer.IntToken lengthToken;
        this.visitTxId();
        int sourceCount = 0;
        if (!LayoutVersion.supports(LayoutVersion.Feature.EDITLOG_OP_OPTIMIZATION, this.editsVersion)) {
            lengthToken = this.v.visitInt(EditsElement.LENGTH);
            sourceCount = lengthToken.value - 2;
        }
        this.v.visitStringUTF8(EditsElement.CONCAT_TARGET);
        if (LayoutVersion.supports(LayoutVersion.Feature.EDITLOG_OP_OPTIMIZATION, this.editsVersion)) {
            lengthToken = this.v.visitInt(EditsElement.LENGTH);
            sourceCount = lengthToken.value;
        }
        for (int i = 0; i < sourceCount; ++i) {
            this.v.visitStringUTF8(EditsElement.CONCAT_SOURCE);
        }
        if (LayoutVersion.supports(LayoutVersion.Feature.EDITLOG_OP_OPTIMIZATION, this.editsVersion)) {
            this.v.visitLong(EditsElement.TIMESTAMP);
        } else {
            this.v.visitStringUTF8(EditsElement.TIMESTAMP);
        }
    }

    private void visit_OP_SYMLINK() throws IOException {
        this.visitTxId();
        if (!LayoutVersion.supports(LayoutVersion.Feature.EDITLOG_OP_OPTIMIZATION, this.editsVersion)) {
            this.v.visitInt(EditsElement.LENGTH);
        }
        this.v.visitStringUTF8(EditsElement.SOURCE);
        this.v.visitStringUTF8(EditsElement.DESTINATION);
        if (LayoutVersion.supports(LayoutVersion.Feature.EDITLOG_OP_OPTIMIZATION, this.editsVersion)) {
            this.v.visitLong(EditsElement.MTIME);
            this.v.visitLong(EditsElement.ATIME);
        } else {
            this.v.visitStringUTF8(EditsElement.MTIME);
            this.v.visitStringUTF8(EditsElement.ATIME);
        }
        this.v.visitEnclosingElement(EditsElement.PERMISSION_STATUS);
        this.v.visitStringText(EditsElement.USERNAME);
        this.v.visitStringText(EditsElement.GROUPNAME);
        this.v.visitShort(EditsElement.FS_PERMISSIONS);
        this.v.leaveEnclosingElement();
    }

    private void visit_OP_GET_DELEGATION_TOKEN() throws IOException {
        this.visitTxId();
        this.v.visitByte(EditsElement.T_VERSION);
        this.v.visitStringText(EditsElement.T_OWNER);
        this.v.visitStringText(EditsElement.T_RENEWER);
        this.v.visitStringText(EditsElement.T_REAL_USER);
        this.v.visitVLong(EditsElement.T_ISSUE_DATE);
        this.v.visitVLong(EditsElement.T_MAX_DATE);
        this.v.visitVInt(EditsElement.T_SEQUENCE_NUMBER);
        this.v.visitVInt(EditsElement.T_MASTER_KEY_ID);
        if (LayoutVersion.supports(LayoutVersion.Feature.EDITLOG_OP_OPTIMIZATION, this.editsVersion)) {
            this.v.visitLong(EditsElement.T_EXPIRY_TIME);
        } else {
            this.v.visitStringUTF8(EditsElement.T_EXPIRY_TIME);
        }
    }

    private void visit_OP_RENEW_DELEGATION_TOKEN() throws IOException {
        this.visitTxId();
        this.v.visitByte(EditsElement.T_VERSION);
        this.v.visitStringText(EditsElement.T_OWNER);
        this.v.visitStringText(EditsElement.T_RENEWER);
        this.v.visitStringText(EditsElement.T_REAL_USER);
        this.v.visitVLong(EditsElement.T_ISSUE_DATE);
        this.v.visitVLong(EditsElement.T_MAX_DATE);
        this.v.visitVInt(EditsElement.T_SEQUENCE_NUMBER);
        this.v.visitVInt(EditsElement.T_MASTER_KEY_ID);
        if (LayoutVersion.supports(LayoutVersion.Feature.EDITLOG_OP_OPTIMIZATION, this.editsVersion)) {
            this.v.visitLong(EditsElement.T_EXPIRY_TIME);
        } else {
            this.v.visitStringUTF8(EditsElement.T_EXPIRY_TIME);
        }
    }

    private void visit_OP_CANCEL_DELEGATION_TOKEN() throws IOException {
        this.visitTxId();
        this.v.visitByte(EditsElement.T_VERSION);
        this.v.visitStringText(EditsElement.T_OWNER);
        this.v.visitStringText(EditsElement.T_RENEWER);
        this.v.visitStringText(EditsElement.T_REAL_USER);
        this.v.visitVLong(EditsElement.T_ISSUE_DATE);
        this.v.visitVLong(EditsElement.T_MAX_DATE);
        this.v.visitVInt(EditsElement.T_SEQUENCE_NUMBER);
        this.v.visitVInt(EditsElement.T_MASTER_KEY_ID);
    }

    private void visit_OP_UPDATE_MASTER_KEY() throws IOException {
        this.visitTxId();
        this.v.visitVInt(EditsElement.KEY_ID);
        this.v.visitVLong(EditsElement.KEY_EXPIRY_DATE);
        Tokenizer.VIntToken blobLengthToken = this.v.visitVInt(EditsElement.KEY_LENGTH);
        this.v.visitBlob(EditsElement.KEY_BLOB, blobLengthToken.value);
    }

    private void visit_OP_REASSIGN_LEASE() throws IOException {
        this.visitTxId();
        this.v.visitStringUTF8(EditsElement.CLIENT_NAME);
        this.v.visitStringUTF8(EditsElement.PATH);
        this.v.visitStringUTF8(EditsElement.CLIENT_NAME);
    }

    private void visit_OP_BEGIN_LOG_SEGMENT() throws IOException {
        this.visitTxId();
    }

    private void visit_OP_END_LOG_SEGMENT() throws IOException {
        this.visitTxId();
    }

    private void visitOpCode(FSEditLogOpCodes editsOpCode) throws IOException {
        switch (editsOpCode) {
            case OP_INVALID: {
                this.visit_OP_INVALID();
                break;
            }
            case OP_ADD: {
                this.visit_OP_ADD();
                break;
            }
            case OP_CLOSE: {
                this.visit_OP_CLOSE();
                break;
            }
            case OP_RENAME_OLD: {
                this.visit_OP_RENAME_OLD();
                break;
            }
            case OP_DELETE: {
                this.visit_OP_DELETE();
                break;
            }
            case OP_MKDIR: {
                this.visit_OP_MKDIR();
                break;
            }
            case OP_SET_REPLICATION: {
                this.visit_OP_SET_REPLICATION();
                break;
            }
            case OP_SET_PERMISSIONS: {
                this.visit_OP_SET_PERMISSIONS();
                break;
            }
            case OP_SET_OWNER: {
                this.visit_OP_SET_OWNER();
                break;
            }
            case OP_SET_GENSTAMP: {
                this.visit_OP_SET_GENSTAMP();
                break;
            }
            case OP_TIMES: {
                this.visit_OP_TIMES();
                break;
            }
            case OP_SET_QUOTA: {
                this.visit_OP_SET_QUOTA();
                break;
            }
            case OP_RENAME: {
                this.visit_OP_RENAME();
                break;
            }
            case OP_CONCAT_DELETE: {
                this.visit_OP_CONCAT_DELETE();
                break;
            }
            case OP_SYMLINK: {
                this.visit_OP_SYMLINK();
                break;
            }
            case OP_GET_DELEGATION_TOKEN: {
                this.visit_OP_GET_DELEGATION_TOKEN();
                break;
            }
            case OP_RENEW_DELEGATION_TOKEN: {
                this.visit_OP_RENEW_DELEGATION_TOKEN();
                break;
            }
            case OP_CANCEL_DELEGATION_TOKEN: {
                this.visit_OP_CANCEL_DELEGATION_TOKEN();
                break;
            }
            case OP_UPDATE_MASTER_KEY: {
                this.visit_OP_UPDATE_MASTER_KEY();
                break;
            }
            case OP_REASSIGN_LEASE: {
                this.visit_OP_REASSIGN_LEASE();
                break;
            }
            case OP_END_LOG_SEGMENT: {
                this.visit_OP_END_LOG_SEGMENT();
                break;
            }
            case OP_START_LOG_SEGMENT: {
                this.visit_OP_BEGIN_LOG_SEGMENT();
                break;
            }
            default: {
                throw new IOException("Unknown op code " + (Object)((Object)editsOpCode));
            }
        }
    }

    @Override
    public void loadEdits() throws IOException {
        try {
            FSEditLogOpCodes editsOpCode;
            this.v.start();
            this.v.visitEnclosingElement(EditsElement.EDITS);
            Tokenizer.IntToken editsVersionToken = this.v.visitInt(EditsElement.EDITS_VERSION);
            this.editsVersion = editsVersionToken.value;
            if (!this.canLoadVersion(this.editsVersion)) {
                throw new IOException("Cannot process editLog version " + editsVersionToken.value);
            }
            do {
                Tokenizer.ByteToken opCodeToken;
                this.v.visitEnclosingElement(EditsElement.RECORD);
                try {
                    opCodeToken = this.v.visitByte(EditsElement.OPCODE);
                }
                catch (EOFException eof) {
                    opCodeToken = new Tokenizer.ByteToken(EditsElement.OPCODE);
                    opCodeToken.fromByte(FSEditLogOpCodes.OP_INVALID.getOpCode());
                    this.v.visit(opCodeToken);
                }
                editsOpCode = FSEditLogOpCodes.fromByte(opCodeToken.value);
                this.v.visitEnclosingElement(EditsElement.DATA);
                this.visitOpCode(editsOpCode);
                this.v.leaveEnclosingElement();
                if (editsOpCode != FSEditLogOpCodes.OP_INVALID && LayoutVersion.supports(LayoutVersion.Feature.EDITS_CHESKUM, this.editsVersion)) {
                    this.v.visitInt(EditsElement.CHECKSUM);
                }
                this.v.leaveEnclosingElement();
            } while (editsOpCode != FSEditLogOpCodes.OP_INVALID);
            this.v.leaveEnclosingElement();
            this.v.finish();
        }
        catch (IOException e) {
            this.v.finishAbnormally();
            throw e;
        }
    }
}

