/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.protocol;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.DeprecatedUTF8;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.common.StorageInfo;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableFactories;
import org.apache.hadoop.io.WritableFactory;
import org.apache.hadoop.io.WritableUtils;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class NamespaceInfo
extends StorageInfo {
    String buildVersion;
    int distributedUpgradeVersion;
    String blockPoolID = "";

    public NamespaceInfo() {
        this.buildVersion = null;
    }

    public NamespaceInfo(int nsID, String clusterID, String bpID, long cT, int duVersion) {
        super(HdfsConstants.LAYOUT_VERSION, nsID, clusterID, cT);
        this.blockPoolID = bpID;
        this.buildVersion = Storage.getBuildVersion();
        this.distributedUpgradeVersion = duVersion;
    }

    public String getBuildVersion() {
        return this.buildVersion;
    }

    public int getDistributedUpgradeVersion() {
        return this.distributedUpgradeVersion;
    }

    public String getBlockPoolID() {
        return this.blockPoolID;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        DeprecatedUTF8.writeString(out, this.getBuildVersion());
        super.write(out);
        out.writeInt(this.getDistributedUpgradeVersion());
        WritableUtils.writeString((DataOutput)out, (String)this.blockPoolID);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.buildVersion = DeprecatedUTF8.readString(in);
        super.readFields(in);
        this.distributedUpgradeVersion = in.readInt();
        this.blockPoolID = WritableUtils.readString((DataInput)in);
    }

    @Override
    public String toString() {
        return super.toString() + ";bpid=" + this.blockPoolID;
    }

    public void validateStorage(NNStorage storage) throws IOException {
        if (this.layoutVersion != storage.getLayoutVersion() || this.namespaceID != storage.getNamespaceID() || this.cTime != storage.cTime || !this.clusterID.equals(storage.getClusterID()) || !this.blockPoolID.equals(storage.getBlockPoolID())) {
            throw new IOException("Inconsistent namespace information:\nNamespaceInfo has:\nLV=" + this.layoutVersion + ";" + "NS=" + this.namespaceID + ";" + "cTime=" + this.cTime + ";" + "CID=" + this.clusterID + ";" + "BPID=" + this.blockPoolID + ".\nStorage has:\n" + "LV=" + storage.getLayoutVersion() + ";" + "NS=" + storage.getNamespaceID() + ";" + "cTime=" + storage.getCTime() + ";" + "CID=" + storage.getClusterID() + ";" + "BPID=" + storage.getBlockPoolID() + ".");
        }
    }

    static {
        WritableFactories.setFactory(NamespaceInfo.class, (WritableFactory)new WritableFactory(){

            public Writable newInstance() {
                return new NamespaceInfo();
            }
        });
    }
}

