/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.DF;
import org.apache.hadoop.hdfs.server.common.Util;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;

public class NameNodeResourceChecker {
    private static final Log LOG = LogFactory.getLog((String)NameNodeResourceChecker.class.getName());
    private long duReserved;
    private final Configuration conf;
    private Map<String, DF> volumes;

    public NameNodeResourceChecker(Configuration conf) throws IOException {
        this.conf = conf;
        this.volumes = new HashMap<String, DF>();
        this.duReserved = conf.getLong("dfs.namenode.resource.du.reserved", 0x6400000L);
        Collection<URI> extraCheckedVolumes = Util.stringCollectionAsURIs(conf.getTrimmedStringCollection("dfs.namenode.resource.checked.volumes"));
        this.addDirsToCheck(FSNamesystem.getNamespaceDirs(conf));
        this.addDirsToCheck(FSNamesystem.getNamespaceEditsDirs(conf));
        this.addDirsToCheck(extraCheckedVolumes);
    }

    private void addDirsToCheck(Collection<URI> directoriesToCheck) throws IOException {
        for (URI directoryUri : directoriesToCheck) {
            File dir = new File(directoryUri.getPath());
            if (!dir.exists()) {
                throw new IOException("Missing directory " + dir.getAbsolutePath());
            }
            DF df = new DF(dir, this.conf);
            this.volumes.put(df.getFilesystem(), df);
        }
    }

    boolean hasAvailableDiskSpace() throws IOException {
        return this.getVolumesLowOnSpace().size() < this.volumes.size();
    }

    Collection<String> getVolumesLowOnSpace() throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Going to check the following volumes disk space: " + this.volumes));
        }
        ArrayList<String> lowVolumes = new ArrayList<String>();
        for (DF volume : this.volumes.values()) {
            long availableSpace = volume.getAvailable();
            String fileSystem = volume.getFilesystem();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Space available on volume '" + fileSystem + "' is " + availableSpace));
            }
            if (availableSpace >= this.duReserved) continue;
            LOG.warn((Object)("Space available on volume '" + fileSystem + "' is " + availableSpace + ", which is below the configured reserved amount " + this.duReserved));
            lowVolumes.add(volume.getFilesystem());
        }
        return lowVolumes;
    }

    @VisibleForTesting
    void setVolumes(Map<String, DF> volumes) {
        this.volumes = volumes;
    }
}

