/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.namenode.FSImageStorageInspector;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;

@InterfaceAudience.Private
@InterfaceStability.Unstable
class FSImagePreTransactionalStorageInspector
extends FSImageStorageInspector {
    private static final Log LOG = LogFactory.getLog(FSImagePreTransactionalStorageInspector.class);
    private boolean hasOutOfDateStorageDirs = false;
    private boolean isUpgradeFinalized = true;
    private long latestNameCheckpointTime = Long.MIN_VALUE;
    private long latestEditsCheckpointTime = Long.MIN_VALUE;
    private Storage.StorageDirectory latestNameSD = null;
    private Storage.StorageDirectory latestEditsSD = null;
    Set<Long> checkpointTimes = new HashSet<Long>();
    private List<String> imageDirs = new ArrayList<String>();
    private List<String> editsDirs = new ArrayList<String>();

    FSImagePreTransactionalStorageInspector() {
    }

    @Override
    void inspectDirectory(Storage.StorageDirectory sd) throws IOException {
        if (!sd.getVersionFile().exists()) {
            this.hasOutOfDateStorageDirs = true;
            return;
        }
        boolean imageExists = false;
        boolean editsExists = false;
        if (sd.getStorageDirType().isOfType(NNStorage.NameNodeDirType.IMAGE)) {
            imageExists = NNStorage.getStorageFile(sd, NNStorage.NameNodeFile.IMAGE).exists();
            this.imageDirs.add(sd.getRoot().getCanonicalPath());
        }
        if (sd.getStorageDirType().isOfType(NNStorage.NameNodeDirType.EDITS)) {
            editsExists = NNStorage.getStorageFile(sd, NNStorage.NameNodeFile.EDITS).exists();
            this.editsDirs.add(sd.getRoot().getCanonicalPath());
        }
        long checkpointTime = FSImagePreTransactionalStorageInspector.readCheckpointTime(sd);
        this.checkpointTimes.add(checkpointTime);
        if (sd.getStorageDirType().isOfType(NNStorage.NameNodeDirType.IMAGE) && this.latestNameCheckpointTime < checkpointTime && imageExists) {
            this.latestNameCheckpointTime = checkpointTime;
            this.latestNameSD = sd;
        }
        if (sd.getStorageDirType().isOfType(NNStorage.NameNodeDirType.EDITS) && this.latestEditsCheckpointTime < checkpointTime && editsExists) {
            this.latestEditsCheckpointTime = checkpointTime;
            this.latestEditsSD = sd;
        }
        if (checkpointTime <= 0L) {
            this.hasOutOfDateStorageDirs = true;
        }
        this.isUpgradeFinalized = this.isUpgradeFinalized && !sd.getPreviousDir().exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long readCheckpointTime(Storage.StorageDirectory sd) throws IOException {
        File timeFile = NNStorage.getStorageFile(sd, NNStorage.NameNodeFile.TIME);
        long timeStamp = 0L;
        if (timeFile.exists() && timeFile.canRead()) {
            DataInputStream in = new DataInputStream(new FileInputStream(timeFile));
            try {
                timeStamp = in.readLong();
            }
            finally {
                in.close();
            }
        }
        return timeStamp;
    }

    @Override
    boolean isUpgradeFinalized() {
        return this.isUpgradeFinalized;
    }

    @Override
    FSImageStorageInspector.LoadPlan createLoadPlan() throws IOException {
        if (this.latestNameSD == null) {
            throw new IOException("Image file is not found in " + this.imageDirs);
        }
        if (this.latestEditsSD == null) {
            throw new IOException("Edits file is not found in " + this.editsDirs);
        }
        if (this.latestNameCheckpointTime > this.latestEditsCheckpointTime && this.latestNameSD != this.latestEditsSD && this.latestNameSD.getStorageDirType() == NNStorage.NameNodeDirType.IMAGE && this.latestEditsSD.getStorageDirType() == NNStorage.NameNodeDirType.EDITS) {
            LOG.error((Object)"This is a rare failure scenario!!!");
            LOG.error((Object)("Image checkpoint time " + this.latestNameCheckpointTime + " > edits checkpoint time " + this.latestEditsCheckpointTime));
            LOG.error((Object)"Name-node will treat the image as the latest state of the namespace. Old edits will be discarded.");
        } else if (this.latestNameCheckpointTime != this.latestEditsCheckpointTime) {
            throw new IOException("Inconsistent storage detected, image and edits checkpoint times do not match. image checkpoint time = " + this.latestNameCheckpointTime + "edits checkpoint time = " + this.latestEditsCheckpointTime);
        }
        return new PreTransactionalLoadPlan();
    }

    @Override
    boolean needToSave() {
        return this.hasOutOfDateStorageDirs || this.checkpointTimes.size() != 1 || this.latestNameCheckpointTime > this.latestEditsCheckpointTime;
    }

    static List<File> getEditsInStorageDir(Storage.StorageDirectory sd) {
        ArrayList<File> files = new ArrayList<File>();
        File edits = NNStorage.getStorageFile(sd, NNStorage.NameNodeFile.EDITS);
        assert (edits.exists()) : "Expected edits file at " + edits;
        files.add(edits);
        File editsNew = NNStorage.getStorageFile(sd, NNStorage.NameNodeFile.EDITS_NEW);
        if (editsNew.exists()) {
            files.add(editsNew);
        }
        return files;
    }

    private class PreTransactionalLoadPlan
    extends FSImageStorageInspector.LoadPlan {
        private PreTransactionalLoadPlan() {
        }

        @Override
        boolean doRecovery() throws IOException {
            LOG.debug((Object)("Performing recovery in " + FSImagePreTransactionalStorageInspector.this.latestNameSD + " and " + FSImagePreTransactionalStorageInspector.this.latestEditsSD));
            boolean needToSave = false;
            File curFile = NNStorage.getStorageFile(FSImagePreTransactionalStorageInspector.this.latestNameSD, NNStorage.NameNodeFile.IMAGE);
            File ckptFile = NNStorage.getStorageFile(FSImagePreTransactionalStorageInspector.this.latestNameSD, NNStorage.NameNodeFile.IMAGE_NEW);
            if (ckptFile.exists()) {
                needToSave = true;
                if (NNStorage.getStorageFile(FSImagePreTransactionalStorageInspector.this.latestEditsSD, NNStorage.NameNodeFile.EDITS_NEW).exists()) {
                    if (!ckptFile.delete()) {
                        throw new IOException("Unable to delete " + ckptFile);
                    }
                } else if (!ckptFile.renameTo(curFile)) {
                    if (!curFile.delete()) {
                        LOG.warn((Object)("Unable to delete dir " + curFile + " before rename"));
                    }
                    if (!ckptFile.renameTo(curFile)) {
                        throw new IOException("Unable to rename " + ckptFile + " to " + curFile);
                    }
                }
            }
            return needToSave;
        }

        @Override
        File getImageFile() {
            return NNStorage.getStorageFile(FSImagePreTransactionalStorageInspector.this.latestNameSD, NNStorage.NameNodeFile.IMAGE);
        }

        @Override
        List<File> getEditsFiles() {
            if (FSImagePreTransactionalStorageInspector.this.latestNameCheckpointTime > FSImagePreTransactionalStorageInspector.this.latestEditsCheckpointTime) {
                LOG.debug((Object)"Name checkpoint time is newer than edits, not loading edits.");
                return Collections.emptyList();
            }
            return FSImagePreTransactionalStorageInspector.getEditsInStorageDir(FSImagePreTransactionalStorageInspector.this.latestEditsSD);
        }

        @Override
        Storage.StorageDirectory getStorageDirectoryForProperties() {
            return FSImagePreTransactionalStorageInspector.this.latestNameSD;
        }
    }
}

