/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.common;

import com.google.common.base.Joiner;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;

@InterfaceAudience.Private
public class StorageInfo
implements Writable {
    public int layoutVersion;
    public int namespaceID;
    public String clusterID;
    public long cTime;

    public StorageInfo() {
        this(0, 0, "", 0L);
    }

    public StorageInfo(int layoutV, int nsID, String cid, long cT) {
        this.layoutVersion = layoutV;
        this.clusterID = cid;
        this.namespaceID = nsID;
        this.cTime = cT;
    }

    public StorageInfo(StorageInfo from) {
        this.setStorageInfo(from);
    }

    public int getLayoutVersion() {
        return this.layoutVersion;
    }

    public int getNamespaceID() {
        return this.namespaceID;
    }

    public String getClusterID() {
        return this.clusterID;
    }

    public long getCTime() {
        return this.cTime;
    }

    public void setStorageInfo(StorageInfo from) {
        this.layoutVersion = from.layoutVersion;
        this.clusterID = from.clusterID;
        this.namespaceID = from.namespaceID;
        this.cTime = from.cTime;
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.getLayoutVersion());
        out.writeInt(this.getNamespaceID());
        WritableUtils.writeString((DataOutput)out, (String)this.clusterID);
        out.writeLong(this.getCTime());
    }

    public void readFields(DataInput in) throws IOException {
        this.layoutVersion = in.readInt();
        this.namespaceID = in.readInt();
        this.clusterID = WritableUtils.readString((DataInput)in);
        this.cTime = in.readLong();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("lv=").append(this.layoutVersion).append(";cid=").append(this.clusterID).append(";nsid=").append(this.namespaceID).append(";c=").append(this.cTime);
        return sb.toString();
    }

    public String toColonSeparatedString() {
        return Joiner.on((String)":").join((Object)this.layoutVersion, (Object)this.namespaceID, new Object[]{this.cTime, this.clusterID});
    }
}

