/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableSet;
import java.util.TreeSet;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.namenode.NameNode;

class UnderReplicatedBlocks
implements Iterable<Block> {
    static final int LEVEL = 5;
    static final int QUEUE_HIGHEST_PRIORITY = 0;
    static final int QUEUE_VERY_UNDER_REPLICATED = 1;
    static final int QUEUE_UNDER_REPLICATED = 2;
    static final int QUEUE_REPLICAS_BADLY_DISTRIBUTED = 3;
    static final int QUEUE_WITH_CORRUPT_BLOCKS = 4;
    private final List<NavigableSet<Block>> priorityQueues = new ArrayList<NavigableSet<Block>>(5);

    UnderReplicatedBlocks() {
        for (int i = 0; i < 5; ++i) {
            this.priorityQueues.add(new TreeSet());
        }
    }

    void clear() {
        for (int i = 0; i < 5; ++i) {
            this.priorityQueues.get(i).clear();
        }
    }

    synchronized int size() {
        int size = 0;
        for (int i = 0; i < 5; ++i) {
            size += this.priorityQueues.get(i).size();
        }
        return size;
    }

    synchronized int getUnderReplicatedBlockCount() {
        int size = 0;
        for (int i = 0; i < 5; ++i) {
            if (i == 4) continue;
            size += this.priorityQueues.get(i).size();
        }
        return size;
    }

    synchronized int getCorruptBlockSize() {
        return this.priorityQueues.get(4).size();
    }

    synchronized boolean contains(Block block) {
        for (NavigableSet<Block> set : this.priorityQueues) {
            if (!set.contains(block)) continue;
            return true;
        }
        return false;
    }

    private int getPriority(Block block, int curReplicas, int decommissionedReplicas, int expectedReplicas) {
        assert (curReplicas >= 0) : "Negative replicas!";
        if (curReplicas >= expectedReplicas) {
            return 3;
        }
        if (curReplicas == 0) {
            if (decommissionedReplicas > 0) {
                return 0;
            }
            return 4;
        }
        if (curReplicas == 1) {
            return 0;
        }
        if (curReplicas * 3 < expectedReplicas) {
            return 1;
        }
        return 2;
    }

    synchronized boolean add(Block block, int curReplicas, int decomissionedReplicas, int expectedReplicas) {
        assert (curReplicas >= 0) : "Negative replicas!";
        int priLevel = this.getPriority(block, curReplicas, decomissionedReplicas, expectedReplicas);
        if (priLevel != 5 && this.priorityQueues.get(priLevel).add(block)) {
            if (NameNode.blockStateChangeLog.isDebugEnabled()) {
                NameNode.blockStateChangeLog.debug((Object)("BLOCK* NameSystem.UnderReplicationBlock.add:" + block + " has only " + curReplicas + " replicas and need " + expectedReplicas + " replicas so is added to neededReplications" + " at priority level " + priLevel));
            }
            return true;
        }
        return false;
    }

    synchronized boolean remove(Block block, int oldReplicas, int decommissionedReplicas, int oldExpectedReplicas) {
        int priLevel = this.getPriority(block, oldReplicas, decommissionedReplicas, oldExpectedReplicas);
        return this.remove(block, priLevel);
    }

    boolean remove(Block block, int priLevel) {
        if (priLevel >= 0 && priLevel < 5 && this.priorityQueues.get(priLevel).remove(block)) {
            if (NameNode.blockStateChangeLog.isDebugEnabled()) {
                NameNode.blockStateChangeLog.debug((Object)("BLOCK* NameSystem.UnderReplicationBlock.remove: Removing block " + block + " from priority queue " + priLevel));
            }
            return true;
        }
        for (int i = 0; i < 5; ++i) {
            if (!this.priorityQueues.get(i).remove(block)) continue;
            if (NameNode.blockStateChangeLog.isDebugEnabled()) {
                NameNode.blockStateChangeLog.debug((Object)("BLOCK* NameSystem.UnderReplicationBlock.remove: Removing block " + block + " from priority queue " + i));
            }
            return true;
        }
        return false;
    }

    synchronized void update(Block block, int curReplicas, int decommissionedReplicas, int curExpectedReplicas, int curReplicasDelta, int expectedReplicasDelta) {
        int oldReplicas = curReplicas - curReplicasDelta;
        int oldExpectedReplicas = curExpectedReplicas - expectedReplicasDelta;
        int curPri = this.getPriority(block, curReplicas, decommissionedReplicas, curExpectedReplicas);
        int oldPri = this.getPriority(block, oldReplicas, decommissionedReplicas, oldExpectedReplicas);
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug((Object)("UnderReplicationBlocks.update " + block + " curReplicas " + curReplicas + " curExpectedReplicas " + curExpectedReplicas + " oldReplicas " + oldReplicas + " oldExpectedReplicas  " + oldExpectedReplicas + " curPri  " + curPri + " oldPri  " + oldPri));
        }
        if (oldPri != 5 && oldPri != curPri) {
            this.remove(block, oldPri);
        }
        if (curPri != 5 && this.priorityQueues.get(curPri).add(block) && NameNode.blockStateChangeLog.isDebugEnabled()) {
            NameNode.blockStateChangeLog.debug((Object)("BLOCK* NameSystem.UnderReplicationBlock.update:" + block + " has only " + curReplicas + " replicas and needs " + curExpectedReplicas + " replicas so is added to neededReplications" + " at priority level " + curPri));
        }
    }

    synchronized BlockIterator iterator(int level) {
        return new BlockIterator(level);
    }

    public synchronized BlockIterator iterator() {
        return new BlockIterator();
    }

    class BlockIterator
    implements Iterator<Block> {
        private int level;
        private boolean isIteratorForLevel = false;
        private List<Iterator<Block>> iterators = new ArrayList<Iterator<Block>>();

        private BlockIterator() {
            this.level = 0;
            for (int i = 0; i < 5; ++i) {
                this.iterators.add(((NavigableSet)UnderReplicatedBlocks.this.priorityQueues.get(i)).iterator());
            }
        }

        private BlockIterator(int l) {
            this.level = l;
            this.isIteratorForLevel = true;
            this.iterators.add(((NavigableSet)UnderReplicatedBlocks.this.priorityQueues.get(this.level)).iterator());
        }

        private void update() {
            if (this.isIteratorForLevel) {
                return;
            }
            while (this.level < 4 && !this.iterators.get(this.level).hasNext()) {
                ++this.level;
            }
        }

        @Override
        public Block next() {
            if (this.isIteratorForLevel) {
                return this.iterators.get(0).next();
            }
            this.update();
            return this.iterators.get(this.level).next();
        }

        @Override
        public boolean hasNext() {
            if (this.isIteratorForLevel) {
                return this.iterators.get(0).hasNext();
            }
            this.update();
            return this.iterators.get(this.level).hasNext();
        }

        @Override
        public void remove() {
            if (this.isIteratorForLevel) {
                this.iterators.get(0).remove();
            } else {
                this.iterators.get(this.level).remove();
            }
        }

        int getPriority() {
            return this.level;
        }
    }
}

