/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.DeprecatedUTF8;
import org.apache.hadoop.io.WritableComparable;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class DatanodeID
implements WritableComparable<DatanodeID> {
    public static final DatanodeID[] EMPTY_ARRAY = new DatanodeID[0];
    public String name;
    private String peerHostName;
    public String storageID;
    protected int infoPort;
    public int ipcPort;

    public DatanodeID() {
        this("");
    }

    public DatanodeID(String nodeName) {
        this(nodeName, "", -1, -1);
    }

    public DatanodeID(DatanodeID from) {
        this(from.getName(), from.getStorageID(), from.getInfoPort(), from.getIpcPort());
        this.peerHostName = from.getPeerHostName();
    }

    public DatanodeID(String nodeName, String storageID, int infoPort, int ipcPort) {
        this.name = nodeName;
        this.storageID = storageID;
        this.infoPort = infoPort;
        this.ipcPort = ipcPort;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setInfoPort(int infoPort) {
        this.infoPort = infoPort;
    }

    public void setPeerHostName(String peerHostName) {
        this.peerHostName = peerHostName;
    }

    public void setIpcPort(int ipcPort) {
        this.ipcPort = ipcPort;
    }

    public String getName() {
        return this.name;
    }

    public String getStorageID() {
        return this.storageID;
    }

    public String getPeerHostName() {
        return this.peerHostName;
    }

    public int getInfoPort() {
        return this.infoPort;
    }

    public int getIpcPort() {
        return this.ipcPort;
    }

    public void setStorageID(String storageID) {
        this.storageID = storageID;
    }

    public String getHost() {
        int colon = this.name.indexOf(":");
        if (colon < 0) {
            return this.name;
        }
        return this.name.substring(0, colon);
    }

    public int getPort() {
        int colon = this.name.indexOf(":");
        if (colon < 0) {
            return 50010;
        }
        return Integer.parseInt(this.name.substring(colon + 1));
    }

    public boolean equals(Object to) {
        if (this == to) {
            return true;
        }
        if (!(to instanceof DatanodeID)) {
            return false;
        }
        return this.name.equals(((DatanodeID)to).getName()) && this.storageID.equals(((DatanodeID)to).getStorageID());
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.storageID.hashCode();
    }

    public String toString() {
        return this.name;
    }

    public void updateRegInfo(DatanodeID nodeReg) {
        this.name = nodeReg.getName();
        this.peerHostName = nodeReg.getPeerHostName();
        this.infoPort = nodeReg.getInfoPort();
        this.ipcPort = nodeReg.getIpcPort();
    }

    public int compareTo(DatanodeID that) {
        return this.name.compareTo(that.getName());
    }

    public void write(DataOutput out) throws IOException {
        DeprecatedUTF8.writeString(out, this.name);
        DeprecatedUTF8.writeString(out, this.storageID);
        out.writeShort(this.infoPort);
    }

    public void readFields(DataInput in) throws IOException {
        this.name = DeprecatedUTF8.readString(in);
        this.storageID = DeprecatedUTF8.readString(in);
        this.infoPort = in.readShort() & 0xFFFF;
    }
}

