/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableFactories;
import org.apache.hadoop.io.WritableFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class BlockLocalPathInfo
implements Writable {
    static final WritableFactory FACTORY = new WritableFactory(){

        public Writable newInstance() {
            return new BlockLocalPathInfo();
        }
    };
    private ExtendedBlock block;
    private String localBlockPath = "";
    private String localMetaPath = "";

    public BlockLocalPathInfo() {
    }

    public BlockLocalPathInfo(ExtendedBlock b, String file, String metafile) {
        this.block = b;
        this.localBlockPath = file;
        this.localMetaPath = metafile;
    }

    public String getBlockPath() {
        return this.localBlockPath;
    }

    public String getMetaPath() {
        return this.localMetaPath;
    }

    public void write(DataOutput out) throws IOException {
        this.block.write(out);
        Text.writeString((DataOutput)out, (String)this.localBlockPath);
        Text.writeString((DataOutput)out, (String)this.localMetaPath);
    }

    public void readFields(DataInput in) throws IOException {
        this.block = new ExtendedBlock();
        this.block.readFields(in);
        this.localBlockPath = Text.readString((DataInput)in);
        this.localMetaPath = Text.readString((DataInput)in);
    }

    public long getNumBytes() {
        return this.block.getNumBytes();
    }

    static {
        WritableFactories.setFactory(BlockLocalPathInfo.class, (WritableFactory)FACTORY);
    }
}

